/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.code.flow;

import de.viadee.bpm.vPAV.processing.code.flow.AbstractNode;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ControlFlowGraph {
    private LinkedHashMap<String, AbstractNode> nodes = new LinkedHashMap();
    private LinkedHashMap<String, ProcessVariableOperation> operations = new LinkedHashMap();
    private int internalNodeCounter = 0;
    private int recursionCounter = 0;
    private int nodeCounter = -1;
    private int priorLevel = 0;
    private List<Integer> priorLevels = new ArrayList<Integer>();

    public void addNode(AbstractNode node) {
        String key = this.createHierarchy(node);
        node.setId(key);
        this.nodes.put(key, node);
    }

    private String createHierarchy(AbstractNode node) {
        StringBuilder key = new StringBuilder();
        key.append(node.getParentElement().getBaseElement().getId()).append("__");
        if (this.recursionCounter == 0) {
            ++this.nodeCounter;
            key.append(this.nodeCounter);
        } else {
            key.append(this.nodeCounter);
            for (int i = 1; i <= this.recursionCounter; ++i) {
                key.append(".");
                if (i == this.recursionCounter) {
                    key.append(this.internalNodeCounter);
                    String predKey = key.toString();
                    if (this.internalNodeCounter != 0) continue;
                    node.setPredsInterProcedural(predKey.substring(0, predKey.length() - 2));
                    continue;
                }
                key.append(this.getPriorLevels().get(i));
            }
            ++this.internalNodeCounter;
        }
        this.priorLevel = this.internalNodeCounter - 1;
        return key.toString();
    }

    void computePredecessorRelations() {
        this.nodes.values().forEach(node -> {
            this.operations.putAll(node.getOperations());
            node.setPreds();
            node.setSuccs();
            node.setOutUnused(new LinkedHashMap<String, ProcessVariableOperation>());
            node.setOutUsed(new LinkedHashMap<String, ProcessVariableOperation>());
        });
    }

    boolean hasImplementedDelegate() {
        for (AbstractNode node : this.nodes.values()) {
            if (!node.getElementChapter().equals((Object)ElementChapter.Implementation)) continue;
            return true;
        }
        return false;
    }

    boolean hasNodes() {
        return !this.nodes.isEmpty();
    }

    public void incrementRecursionCounter() {
        ++this.recursionCounter;
    }

    public void decrementRecursionCounter() {
        --this.recursionCounter;
    }

    public void resetInternalNodeCounter() {
        this.internalNodeCounter = 0;
    }

    public LinkedHashMap<String, AbstractNode> getNodes() {
        return this.nodes;
    }

    public int getPriorLevel() {
        return this.priorLevel;
    }

    public void setInternalNodeCounter(int internalNodeCounter) {
        this.internalNodeCounter = internalNodeCounter;
    }

    AbstractNode firstNode() {
        Iterator<AbstractNode> iterator = this.nodes.values().iterator();
        return iterator.next();
    }

    AbstractNode lastNode() {
        Iterator<AbstractNode> iterator = this.nodes.values().iterator();
        AbstractNode node = null;
        while (iterator.hasNext()) {
            node = iterator.next();
        }
        return node;
    }

    private List<Integer> getPriorLevels() {
        return this.priorLevels;
    }

    public void addPriorLevel(int i) {
        this.priorLevels.add(i);
    }

    public void removePriorLevel() {
        this.priorLevels.remove(this.priorLevels.size() - 1);
    }
}

