/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.code.flow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.viadee.bpm.vPAV.processing.code.flow.AnalysisElement;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElementDecorator;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.FlowAnalysis;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class BpmnElement
implements AnalysisElement {
    private String processDefinition;
    private BaseElement baseElement;
    private ControlFlowGraph controlFlowGraph;
    private FlowAnalysis flowAnalysis;
    private LinkedHashMap<String, ProcessVariableOperation> operations;
    private LinkedHashMap<String, ProcessVariableOperation> defined;
    private LinkedHashMap<String, ProcessVariableOperation> used;
    private LinkedHashMap<String, ProcessVariableOperation> killed;
    private LinkedHashMap<String, ProcessVariableOperation> inUsed;
    private LinkedHashMap<String, ProcessVariableOperation> inUnused;
    private LinkedHashMap<String, ProcessVariableOperation> outUsed;
    private LinkedHashMap<String, ProcessVariableOperation> outUnused;
    private LinkedHashMap<String, AnalysisElement> predecessors;
    private LinkedHashMap<String, AnalysisElement> successors;
    private List<AnomalyContainer> sourceCodeAnomalies;
    private ListMultimap<String, ProcessVariableOperation> processVariables;

    public BpmnElement(String processDefinition, BaseElement element, ControlFlowGraph controlFlowGraph, FlowAnalysis flowAnalysis) {
        this.processDefinition = processDefinition;
        this.baseElement = element;
        this.controlFlowGraph = controlFlowGraph;
        this.flowAnalysis = flowAnalysis;
        this.operations = new LinkedHashMap();
        this.predecessors = new LinkedHashMap();
        this.successors = new LinkedHashMap();
        this.processVariables = ArrayListMultimap.create();
        this.defined = new LinkedHashMap();
        this.used = new LinkedHashMap();
        this.killed = new LinkedHashMap();
        this.inUsed = new LinkedHashMap();
        this.inUnused = new LinkedHashMap();
        this.outUsed = new LinkedHashMap();
        this.outUnused = new LinkedHashMap();
        this.sourceCodeAnomalies = new ArrayList<AnomalyContainer>();
    }

    public void setProcessVariables(ListMultimap<String, ProcessVariableOperation> variables) {
        variables.entries().forEach(e -> this.addOperation((ProcessVariableOperation)e.getValue()));
        this.processVariables.putAll(variables);
    }

    private void addOperation(ProcessVariableOperation processVariableOperation) {
        this.operations.put(processVariableOperation.getId(), processVariableOperation);
        switch (processVariableOperation.getOperation()) {
            case WRITE: {
                this.defined.put(processVariableOperation.getId(), processVariableOperation);
                break;
            }
            case READ: {
                this.used.put(processVariableOperation.getId(), processVariableOperation);
                break;
            }
            case DELETE: {
                this.killed.put(processVariableOperation.getId(), processVariableOperation);
            }
        }
    }

    private void removeOperationFromSet(ProcessVariableOperation processVariableOperation) {
        this.operations.remove(processVariableOperation.getId());
        switch (processVariableOperation.getOperation()) {
            case WRITE: {
                this.defined.remove(processVariableOperation.getId());
                break;
            }
            case READ: {
                this.used.remove(processVariableOperation.getId());
                break;
            }
            case DELETE: {
                this.killed.remove(processVariableOperation.getId());
            }
        }
    }

    private List<AnomalyContainer> getSourceCodeAnomalies() {
        return this.sourceCodeAnomalies;
    }

    public String getProcessDefinition() {
        return this.processDefinition;
    }

    public ListMultimap<String, ProcessVariableOperation> getProcessVariables() {
        return this.processVariables;
    }

    @Override
    public Map<BpmnElement, List<AnomalyContainer>> getAnomalies() {
        HashMap<BpmnElement, List<AnomalyContainer>> anomalyMap = new HashMap<BpmnElement, List<AnomalyContainer>>();
        if (!this.getSourceCodeAnomalies().isEmpty()) {
            anomalyMap.put(this, this.getSourceCodeAnomalies());
        }
        return anomalyMap;
    }

    public FlowAnalysis getFlowAnalysis() {
        return this.flowAnalysis;
    }

    @Override
    public BaseElement getBaseElement() {
        return this.baseElement;
    }

    @Override
    public BpmnElement getParentElement() {
        return this;
    }

    @Override
    public void removeOperation(ProcessVariableOperation op) {
        this.removeOperationFromSet(op);
    }

    @Override
    public void addSourceCodeAnomaly(AnomalyContainer anomaly) {
        this.sourceCodeAnomalies.add(anomaly);
    }

    @Override
    public ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getInUsed() {
        return this.inUsed;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getInUnused() {
        return this.inUnused;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getOutUsed() {
        return this.outUsed;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getOutUnused() {
        return this.outUnused;
    }

    @Override
    public void setInUsed(LinkedHashMap<String, ProcessVariableOperation> inUsedB) {
        this.inUsed = inUsedB;
    }

    @Override
    public void setInUnused(LinkedHashMap<String, ProcessVariableOperation> inUnusedB) {
        this.inUnused = inUnusedB;
    }

    @Override
    public void setOutUsed(LinkedHashMap<String, ProcessVariableOperation> outUsed) {
        this.outUsed = outUsed;
    }

    @Override
    public void setOutUnused(LinkedHashMap<String, ProcessVariableOperation> outUnused) {
        this.outUnused = outUnused;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getUsed() {
        return this.used;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getKilled() {
        return this.killed;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getDefined() {
        return this.defined;
    }

    @Override
    public void setOperations(LinkedHashMap<String, ProcessVariableOperation> operations) {
        this.operations = operations;
    }

    @Override
    public void setUsed(LinkedHashMap<String, ProcessVariableOperation> used) {
        this.used = used;
    }

    @Override
    public void setDefined(LinkedHashMap<String, ProcessVariableOperation> defined) {
        this.defined = defined;
    }

    @Override
    public void addDefined(LinkedHashMap<String, ProcessVariableOperation> defined) {
        this.defined.putAll(defined);
    }

    @Override
    public String getId() {
        return this.getBaseElement().getId();
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getOperations() {
        return this.operations;
    }

    @Override
    public void setPredecessors(LinkedHashMap<String, AnalysisElement> predecessors) {
        this.predecessors = predecessors;
    }

    @Override
    public void addPredecessor(AnalysisElement predecessor) {
        this.predecessors.put(predecessor.getId(), predecessor);
    }

    @Override
    public List<AnalysisElement> getPredecessors() {
        return this.predecessors.values().stream().map(BpmnElementDecorator::new).collect(Collectors.toList());
    }

    @Override
    public List<AnalysisElement> getSuccessors() {
        return this.successors.values().stream().map(BpmnElementDecorator::new).collect(Collectors.toList());
    }

    @Override
    public void setSuccessors(LinkedHashMap<String, AnalysisElement> successors) {
        this.successors = successors;
    }

    @Override
    public void addSuccessor(AnalysisElement successor) {
        this.successors.put(successor.getId(), successor);
    }

    @Override
    public void clearPredecessors() {
        this.predecessors.clear();
    }

    @Override
    public void removePredecessor(String predecessor) {
        this.predecessors.remove(predecessor);
    }

    @Override
    public void clearSuccessors() {
        this.successors.clear();
    }

    @Override
    public void removeSuccessor(String successor) {
        this.successors.remove(successor);
    }

    public int hashCode() {
        return this.baseElement.getId().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof BpmnElement && this.hashCode() == o.hashCode();
    }

    public String toString() {
        return this.baseElement.getId();
    }
}

