/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.code.flow;

import de.viadee.bpm.vPAV.processing.code.flow.AnalysisElement;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.NodeDecorator;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public abstract class AbstractNode
implements AnalysisElement {
    protected ControlFlowGraph controlFlowGraph;
    protected LinkedHashMap<String, ProcessVariableOperation> operations;
    protected LinkedHashMap<String, ProcessVariableOperation> defined;
    protected LinkedHashMap<String, ProcessVariableOperation> used;
    protected LinkedHashMap<String, ProcessVariableOperation> killed;
    protected LinkedHashMap<String, ProcessVariableOperation> inUsed;
    protected LinkedHashMap<String, ProcessVariableOperation> inUnused;
    protected LinkedHashMap<String, ProcessVariableOperation> outUsed;
    protected LinkedHashMap<String, ProcessVariableOperation> outUnused;
    protected BpmnElement parentElement;
    protected ElementChapter elementChapter;
    protected LinkedHashMap<String, AnalysisElement> predecessors;
    protected LinkedHashMap<String, AnalysisElement> successors;
    protected String id;

    AbstractNode(ControlFlowGraph controlFlowGraph, BpmnElement parentElement, ElementChapter elementChapter) {
        this.controlFlowGraph = controlFlowGraph;
        this.parentElement = parentElement;
        this.elementChapter = elementChapter;
        this.predecessors = new LinkedHashMap();
        this.successors = new LinkedHashMap();
        this.operations = new LinkedHashMap();
        this.defined = new LinkedHashMap();
        this.used = new LinkedHashMap();
        this.killed = new LinkedHashMap();
        this.inUsed = new LinkedHashMap();
        this.inUnused = new LinkedHashMap();
        this.outUsed = new LinkedHashMap();
        this.outUnused = new LinkedHashMap();
    }

    public void addOperation(ProcessVariableOperation processVariableOperation) {
        String id = String.valueOf(processVariableOperation.getFlowOperationIndex());
        this.operations.put(processVariableOperation.getId(), processVariableOperation);
        switch (processVariableOperation.getOperation()) {
            case WRITE: {
                this.defined.put(id, processVariableOperation);
                break;
            }
            case READ: {
                this.used.put(id, processVariableOperation);
                break;
            }
            case DELETE: {
                this.killed.put(id, processVariableOperation);
            }
        }
    }

    void setPredsInterProcedural(String key) {
        AnalysisElement ae = this.controlFlowGraph.getNodes().get(key);
        this.predecessors.put(ae.getId(), ae);
    }

    protected void createIds(Pattern idPattern, Matcher blockMatcher, boolean pred) {
        if (blockMatcher.matches()) {
            String key = blockMatcher.group(2);
            Matcher idMatcher = idPattern.matcher(this.id);
            if (idMatcher.matches()) {
                String id = idMatcher.group();
                id = id.substring(0, id.length() - 1).concat(key);
                AnalysisElement ae = this.controlFlowGraph.getNodes().get(id);
                if (pred) {
                    this.addPredecessor(ae);
                } else {
                    this.addSuccessor(ae);
                }
            }
        }
    }

    abstract void setPreds();

    abstract void setSuccs();

    @Override
    public ControlFlowGraph getControlFlowGraph() {
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getOperations() {
        return this.operations;
    }

    @Override
    public void setOperations(LinkedHashMap<String, ProcessVariableOperation> operations) {
        this.operations = operations;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getDefined() {
        return this.defined;
    }

    @Override
    public void addSourceCodeAnomaly(AnomalyContainer anomalyContainer) {
        this.parentElement.addSourceCodeAnomaly(anomalyContainer);
    }

    @Override
    public void clearPredecessors() {
        this.predecessors.clear();
    }

    @Override
    public void removePredecessor(String predecessor) {
        this.predecessors.remove(predecessor);
    }

    @Override
    public void clearSuccessors() {
        this.successors.clear();
    }

    @Override
    public void removeSuccessor(String successor) {
        this.successors.remove(successor);
    }

    @Override
    public Map<BpmnElement, List<AnomalyContainer>> getAnomalies() {
        return this.getParentElement().getAnomalies();
    }

    @Override
    public BaseElement getBaseElement() {
        return this.parentElement.getBaseElement();
    }

    @Override
    public void setDefined(LinkedHashMap<String, ProcessVariableOperation> defined) {
        this.defined = defined;
    }

    @Override
    public void addDefined(LinkedHashMap<String, ProcessVariableOperation> defined) {
        this.defined.putAll(defined);
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getUsed() {
        return this.used;
    }

    @Override
    public void setUsed(LinkedHashMap<String, ProcessVariableOperation> used) {
        this.used = used;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getKilled() {
        return this.killed;
    }

    public void setKilled(LinkedHashMap<String, ProcessVariableOperation> killed) {
        this.killed = killed;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getInUsed() {
        return this.inUsed;
    }

    @Override
    public void setInUsed(LinkedHashMap<String, ProcessVariableOperation> inUsed) {
        this.inUsed = inUsed;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getInUnused() {
        return this.inUnused;
    }

    @Override
    public void setInUnused(LinkedHashMap<String, ProcessVariableOperation> inUnused) {
        this.inUnused = inUnused;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getOutUsed() {
        return this.outUsed;
    }

    @Override
    public void setOutUsed(LinkedHashMap<String, ProcessVariableOperation> outUsed) {
        this.outUsed = outUsed;
    }

    @Override
    public LinkedHashMap<String, ProcessVariableOperation> getOutUnused() {
        return this.outUnused;
    }

    @Override
    public void setOutUnused(LinkedHashMap<String, ProcessVariableOperation> outUnused) {
        this.outUnused = outUnused;
    }

    @Override
    public BpmnElement getParentElement() {
        return this.parentElement;
    }

    @Override
    public void removeOperation(ProcessVariableOperation op) {
        this.operations.remove(op.getId());
    }

    @Override
    public void setPredecessors(LinkedHashMap<String, AnalysisElement> predecessors) {
        this.predecessors = predecessors;
    }

    @Override
    public void addPredecessor(AnalysisElement predecessor) {
        this.predecessors.put(predecessor.getId(), predecessor);
    }

    @Override
    public List<AnalysisElement> getPredecessors() {
        return this.predecessors.values().stream().map(NodeDecorator::new).collect(Collectors.toList());
    }

    @Override
    public List<AnalysisElement> getSuccessors() {
        return this.successors.values().stream().map(NodeDecorator::new).collect(Collectors.toList());
    }

    @Override
    public void setSuccessors(LinkedHashMap<String, AnalysisElement> successors) {
        this.successors = successors;
    }

    @Override
    public void addSuccessor(AnalysisElement successor) {
        this.successors.put(successor.getId(), successor);
    }

    ElementChapter getElementChapter() {
        return this.elementChapter;
    }
}

