/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.ProcessingException;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.Task;

public class TaskNamingConventionChecker
extends AbstractElementChecker {
    public TaskNamingConventionChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof Task) {
            Collection<ElementConvention> elementConventions = this.rule.getElementConventions();
            if (elementConventions == null || elementConventions.size() < 1 || elementConventions.size() > 1) {
                throw new ProcessingException("task naming convention checker must have one element convention!");
            }
            String patternString = elementConventions.iterator().next().getPattern();
            String taskName = baseElement.getAttributeValue("name");
            if (taskName != null && taskName.trim().length() > 0) {
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(taskName);
                if (!matcher.matches()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("TaskNamingConventionChecker.1"), taskName), elementConventions.iterator().next().getDescription()));
                }
            } else {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, Messages.getString("TaskNamingConventionChecker.2")));
            }
        }
        return issues;
    }
}

