/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.ElementFieldTypes;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessVariablesNameConventionChecker
extends AbstractElementChecker {
    public ProcessVariablesNameConventionChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        Collection<CheckerIssue> issues = this.checkNamingConvention(element);
        return issues;
    }

    private Collection<CheckerIssue> checkNamingConvention(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Collection<ElementConvention> elementConventions = this.rule.getElementConventions();
        if (elementConventions != null) {
            for (ElementConvention convention : elementConventions) {
                Pattern pattern = Pattern.compile(convention.getPattern());
                ElementFieldTypes fieldTypes = convention.getElementFieldTypes();
                Collection<String> fieldTypeItems = fieldTypes.getElementFieldTypes();
                for (ProcessVariableOperation variable : element.getProcessVariables().values()) {
                    Matcher patternMatcher;
                    if (variable.getOperation() != VariableOperation.WRITE || fieldTypeItems == null) continue;
                    boolean isInRange = false;
                    isInRange = fieldTypes.isExcluded() ? !fieldTypeItems.contains(variable.getFieldType().name()) : fieldTypeItems.contains(variable.getFieldType().name());
                    if (!isInRange || (patternMatcher = pattern.matcher(variable.getName())).matches()) continue;
                    issues.add(IssueWriter.createSingleIssue(this.rule, CriticalityEnum.WARNING, element, variable.getResourceFilePath(), variable.getName(), String.format(Messages.getString("ProcessVariablesNameConventionChecker.0"), new Object[]{variable.getName(), convention.getName(), variable.getChapter(), variable.getFieldType().getDescription()}), convention));
                }
            }
        }
        return issues;
    }
}

