/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;

public class OverlapChecker
extends AbstractElementChecker {
    private Map<String, ArrayList<String>> sequenceFlowList = new HashMap<String, ArrayList<String>>();

    public OverlapChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        if (bpmnElement instanceof SequenceFlow) {
            ArrayList<String> sequenceFlowDef = this.bpmnScanner.getSequenceFlowDef(bpmnElement.getId());
            if (this.getSequenceFlowList().isEmpty()) {
                this.addToSequenceFlowList(bpmnElement.getId(), sequenceFlowDef);
            }
            for (Map.Entry<String, ArrayList<String>> entry : this.getSequenceFlowList().entrySet()) {
                if (!sequenceFlowDef.equals(entry.getValue()) || bpmnElement.getId().equals(entry.getKey())) continue;
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("OverlapChecker.0"), CheckName.checkName(bpmnElement))));
                return issues;
            }
            if (!this.getSequenceFlowList().containsKey(bpmnElement.getId())) {
                this.addToSequenceFlowList(bpmnElement.getId(), sequenceFlowDef);
            }
        }
        return issues;
    }

    public Map<String, ArrayList<String>> getSequenceFlowList() {
        return this.sequenceFlowList;
    }

    public void addToSequenceFlowList(String id, ArrayList<String> sequenceFlowList) {
        this.sequenceFlowList.put(id, sequenceFlowList);
    }

    public void resetSequenceFlowList() {
        this.sequenceFlowList.clear();
    }
}

