/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.ExclusiveGateway;
import org.camunda.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.bpmn.instance.ManualTask;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.UserTask;

public class NoExpressionChecker
extends AbstractElementChecker {
    public NoExpressionChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<String> listener;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        Map<String, Setting> settings = this.rule.getSettings();
        if (baseElement instanceof ServiceTask || baseElement instanceof BusinessRuleTask || baseElement instanceof SendTask || baseElement instanceof ScriptTask) {
            ArrayList<String> listener2;
            String implementationAttr = this.bpmnScanner.getImplementation(baseElement.getId());
            if (implementationAttr != null && implementationAttr.equals("camunda:expression") && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format("Usage of expressions in '%s' is against best practices.", CheckName.checkName(baseElement))));
            }
            if (!(listener2 = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener")).isEmpty() && listener2.size() > 0 && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                this.addIssue(element, issues, baseElement);
            }
        } else if (baseElement instanceof IntermediateThrowEvent || baseElement instanceof EndEvent || baseElement instanceof StartEvent) {
            ArrayList<String> listener3;
            String implementationAttrEvent = this.bpmnScanner.getEventImplementation(baseElement.getId());
            if (implementationAttrEvent != null && implementationAttrEvent.contains("camunda:expression") && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format("Usage of expression in event '%s' is against best practices.", CheckName.checkName(baseElement))));
            }
            if (!(listener3 = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener")).isEmpty() && listener3.size() > 0 && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                this.addIssue(element, issues, baseElement);
            }
        } else if (baseElement instanceof SequenceFlow) {
            ArrayList<String> listener4 = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener");
            if (!listener4.isEmpty() && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                this.addIssue(element, issues, baseElement);
            }
        } else if (baseElement instanceof ExclusiveGateway) {
            ArrayList<String> listener5 = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener");
            if (!listener5.isEmpty() && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                this.addIssue(element, issues, baseElement);
            }
        } else if (baseElement instanceof UserTask) {
            ArrayList<String> taskListener;
            ArrayList<String> listener6 = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener");
            if (!listener6.isEmpty() && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                this.addIssue(element, issues, baseElement);
            }
            if (!(taskListener = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener")).isEmpty() && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
                this.addIssue(element, issues, baseElement);
            }
        } else if (baseElement instanceof ManualTask && !(listener = this.bpmnScanner.getListener(baseElement.getId(), "expression", "camunda:executionListener")).isEmpty() && !settings.containsKey(baseElement.getElementType().getInstanceType().getSimpleName())) {
            this.addIssue(element, issues, baseElement);
        }
        return issues;
    }

    private void addIssue(BpmnElement element, Collection<CheckerIssue> issues, BaseElement baseElement) {
        issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format("Usage of expression in listeners for '%s' is against best practices.", CheckName.checkName(baseElement))));
    }
}

