/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.EntryPoint;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;

public class MessageCorrelationChecker
extends AbstractElementChecker {
    private ProcessVariablesScanner scanner;

    MessageCorrelationChecker(Rule rule, BpmnScanner bpmnScanner, ProcessVariablesScanner scanner) {
        super(rule, bpmnScanner);
        this.scanner = scanner;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        Collection messageEventDefinition;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement.getElementType().getTypeName().equals("startEvent") && (messageEventDefinition = baseElement.getChildElementsByType(MessageEventDefinition.class)) != null && messageEventDefinition.size() > 0) {
            this.retrieveMessage(element, issues, baseElement, this.scanner.getEntryPoints());
        }
        if ((baseElement.getElementType().getTypeName().equals("endEvent") || baseElement.getElementType().getTypeName().equals("intermediateCatchEvent") || baseElement.getElementType().getTypeName().equals("intermediateThrowEvent") || baseElement.getElementType().getTypeName().equals("boundaryEvent")) && (messageEventDefinition = baseElement.getChildElementsByType(MessageEventDefinition.class)) != null && messageEventDefinition.size() > 0) {
            this.retrieveMessage(element, issues, baseElement, this.scanner.getIntermediateEntryPoints());
        }
        if (baseElement.getElementType().getTypeName().equals("receiveTask")) {
            this.retrieveMessage(element, issues, baseElement, this.scanner.getIntermediateEntryPoints());
        }
        return issues;
    }

    private void retrieveMessage(BpmnElement element, Collection<CheckerIssue> issues, BaseElement baseElement, List<EntryPoint> entryPoints) {
        ArrayList<String> messageRefs = this.bpmnScanner.getMessageRefs(baseElement.getId());
        String messageName = "";
        if (messageRefs.size() == 1) {
            messageName = this.bpmnScanner.getMessageName(messageRefs.get(0));
        }
        for (EntryPoint ep : entryPoints) {
            if (ep.getMessageName().equals(messageName)) continue;
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageCorrelationChecker.1"), messageName)));
        }
    }
}

