/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class ExtensionChecker
extends AbstractElementChecker {
    private static Logger logger = Logger.getLogger(ExtensionChecker.class.getName());
    private boolean isMisconfigured = false;

    public ExtensionChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        Map<String, Setting> settings = this.rule.getSettings();
        ArrayList<String> whiteList = this.rule.getWhiteList();
        HashMap<String, String> keyPairs = new HashMap<String, String>();
        ArrayList<Setting> optionalSettings = new ArrayList<Setting>();
        ArrayList<Setting> mandatorySettings = new ArrayList<Setting>();
        keyPairs.putAll(this.bpmnScanner.getKeyPairs(bpmnElement.getId()));
        for (Map.Entry<String, Setting> settingsEntry : settings.entrySet()) {
            if (settingsEntry.getValue().getRequired()) {
                mandatorySettings.add(settingsEntry.getValue());
                continue;
            }
            optionalSettings.add(settingsEntry.getValue());
        }
        if (whiteList.contains(bpmnElement.getElementType().getInstanceType().getSimpleName())) {
            issues.addAll(this.checkManExtension(whiteList, mandatorySettings, keyPairs, bpmnElement, element));
            issues.addAll(this.checkOptExtension(whiteList, optionalSettings, keyPairs, bpmnElement, element));
        }
        this.checkMisconfiguration();
        return issues;
    }

    private Collection<CheckerIssue> checkManExtension(ArrayList<String> whiteList, ArrayList<Setting> settings, Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (Setting setting : settings) {
            this.checkKey(whiteList, keyPairs, bpmnElement, element, issues, setting);
        }
        return issues;
    }

    private void checkKey(ArrayList<String> whiteList, Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element, Collection<CheckerIssue> issues, Setting setting) {
        if (!this.checkMisconfiguration(setting)) {
            if (setting.getType() != null && setting.getId() == null && setting.getType().equals(bpmnElement.getElementType().getInstanceType().getSimpleName())) {
                if (setting.getName() != null && keyPairs.containsKey(setting.getName())) {
                    this.checkValue(keyPairs, bpmnElement, element, issues, setting, false);
                } else {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("ExtensionChecker.0"), CheckName.checkName(bpmnElement), setting.getName())));
                }
            }
            if (setting.getType() == null && setting.getId() != null && setting.getId().equals(bpmnElement.getAttributeValue("id"))) {
                this.checkValue(keyPairs, bpmnElement, element, issues, setting, false);
            }
            if (setting.getType() == null && setting.getId() == null) {
                if (setting.getName() != null && keyPairs.containsKey(setting.getName())) {
                    this.checkValue(keyPairs, bpmnElement, element, issues, setting, false);
                } else {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("ExtensionChecker.1"), CheckName.checkName(bpmnElement), setting.getName())));
                }
            }
        }
    }

    private Collection<CheckerIssue> checkOptExtension(ArrayList<String> whiteList, ArrayList<Setting> settings, Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (Setting setting : settings) {
            if (this.checkMisconfiguration(setting)) continue;
            if (setting.getType() != null && setting.getId() == null && setting.getType().equals(bpmnElement.getElementType().getInstanceType().getSimpleName()) && setting.getName() != null && keyPairs.containsKey(setting.getName())) {
                this.checkValue(keyPairs, bpmnElement, element, issues, setting, true);
            }
            if (setting.getType() == null && setting.getId() != null && setting.getId().equals(bpmnElement.getAttributeValue("id"))) {
                this.checkValue(keyPairs, bpmnElement, element, issues, setting, true);
            }
            if (setting.getType() != null || setting.getId() != null || !whiteList.contains(bpmnElement.getElementType().getInstanceType().getSimpleName()) || setting.getName() == null || !keyPairs.containsKey(setting.getName())) continue;
            this.checkValue(keyPairs, bpmnElement, element, issues, setting, true);
        }
        return issues;
    }

    private void checkValue(Map<String, String> keyPairs, BaseElement bpmnElement, BpmnElement element, Collection<CheckerIssue> issues, Setting setting, Boolean check) {
        if (keyPairs.get(setting.getName()) != null && !keyPairs.get(setting.getName()).isEmpty()) {
            String patternString = setting.getValue();
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(keyPairs.get(setting.getName()));
            if (!matcher.matches()) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("ExtensionChecker.2"), CheckName.checkName(bpmnElement), setting.getName())));
            }
        } else if (!check.booleanValue()) {
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("ExtensionChecker.3"), CheckName.checkName(bpmnElement))));
        }
    }

    public boolean checkMisconfiguration(Setting setting) {
        boolean misconfigured = false;
        if (setting.getType() != null && setting.getId() != null) {
            misconfigured = true;
            this.setIsMisconfigured(misconfigured);
            return misconfigured;
        }
        return misconfigured;
    }

    private void checkMisconfiguration() {
        if (this.getIsMisconfigured()) {
            logger.warning("Misconfiguration of rule for ExtensionChecker. Please provide either tasktype or a specific ID of an element.");
        }
    }

    public boolean getIsMisconfigured() {
        return this.isMisconfigured;
    }

    public void setIsMisconfigured(boolean isMisconfigured) {
        this.isMisconfigured = isMisconfigured;
    }
}

