/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Script;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.codehaus.groovy.control.CompilationFailedException;

public class EmbeddedGroovyScriptChecker
extends AbstractElementChecker {
    public EmbeddedGroovyScriptChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        BaseElement baseElement = element.getBaseElement();
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>(this.checkScriptTask(element.getProcessDefinition(), element));
        ExtensionElements extensionElements = baseElement.getExtensionElements();
        if (extensionElements != null) {
            issues.addAll(this.checkExecutionListener(element.getProcessDefinition(), element, extensionElements));
            issues.addAll(this.checkTaskListener(element.getProcessDefinition(), element, extensionElements));
            issues.addAll(this.checkInputOutputMapping(element.getProcessDefinition(), element, baseElement));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkInputOutputMapping(String bpmnFile, BpmnElement element, BaseElement baseElement) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        HashMap<String, Map<String, String>> inputVariables = this.bpmnScanner.getInputMapping(baseElement.getId());
        HashMap<String, Map<String, String>> outputVariables = this.bpmnScanner.getOutputMapping(baseElement.getId());
        LinkedMap<String, String> inputMappingType = this.bpmnScanner.getMappingType(element.getBaseElement().getId(), "camunda:inputParameter");
        LinkedMap<String, String> outputMappingType = this.bpmnScanner.getMappingType(element.getBaseElement().getId(), "camunda:outputParameter");
        this.checkMapping(bpmnFile, element, issues, inputVariables, inputMappingType);
        this.checkMapping(bpmnFile, element, issues, outputVariables, outputMappingType);
        return issues;
    }

    private void checkMapping(String bpmnFile, BpmnElement element, Collection<CheckerIssue> issues, Map<String, Map<String, String>> inputVariables, LinkedMap<String, String> inputMappingType) {
        for (Map.Entry<String, Map<String, String>> entry : inputVariables.entrySet()) {
            for (Map.Entry<String, String> innerEntry : entry.getValue().entrySet()) {
                CheckerIssue issueInvalidScript;
                CheckerIssue issueEmptyFormat;
                if (!((String)inputMappingType.firstKey()).equals("camunda:script")) continue;
                CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, element, (String)inputMappingType.getValue(0), innerEntry.getValue());
                if (issueEmptyScript != null) {
                    issues.add(issueEmptyScript);
                }
                if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, element, (String)inputMappingType.getValue(0), innerEntry.getValue())) != null) {
                    issues.add(issueEmptyFormat);
                }
                if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, element, (String)inputMappingType.getValue(0), innerEntry.getValue())) == null) continue;
                issues.add(issueInvalidScript);
            }
        }
    }

    private Collection<CheckerIssue> checkScriptTask(String bpmnFile, BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)baseElement;
            Script script = scriptTask.getScript();
            if (script != null && scriptTask.getCamundaResource() == null) {
                CheckerIssue issueInvalidScript;
                CheckerIssue issueEmptyFormat;
                CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, element, scriptTask.getScriptFormat(), script.getTextContent());
                if (issueEmptyScript != null) {
                    issues.add(issueEmptyScript);
                }
                if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, element, scriptTask.getScriptFormat(), script.getTextContent())) != null) {
                    issues.add(issueEmptyFormat);
                }
                if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, element, scriptTask.getScriptFormat(), script.getTextContent())) != null) {
                    issues.add(issueInvalidScript);
                }
            } else if (scriptTask.getCamundaResource() == null) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, Messages.getString("EmbeddedGroovyScriptChecker.0")));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkExecutionListener(String bpmnFile, BpmnElement element, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaExecutionListener.class).list();
        for (CamundaExecutionListener listener : listenerList) {
            CamundaScript script = listener.getCamundaScript();
            this.evaluateScript(bpmnFile, element, issues, script);
        }
        return issues;
    }

    private void evaluateScript(String bpmnFile, BpmnElement element, Collection<CheckerIssue> issues, CamundaScript script) {
        if (script != null && script.getCamundaResource() == null) {
            CheckerIssue issueInvalidScript;
            CheckerIssue issueEmptyFormat;
            CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, element, script.getCamundaScriptFormat(), script.getTextContent());
            if (issueEmptyScript != null) {
                issues.add(issueEmptyScript);
            }
            if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, element, script.getCamundaScriptFormat(), script.getTextContent())) != null) {
                issues.add(issueEmptyFormat);
            }
            if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, element, script.getCamundaScriptFormat(), script.getTextContent())) != null) {
                issues.add(issueInvalidScript);
            }
        }
    }

    private Collection<CheckerIssue> checkTaskListener(String bpmnFile, BpmnElement element, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaTaskListener.class).list();
        for (CamundaTaskListener listener : listenerList) {
            CamundaScript script = listener.getCamundaScript();
            this.evaluateScript(bpmnFile, element, issues, script);
        }
        return issues;
    }

    private CheckerIssue parseGroovyCode(String bpmnFile, BpmnElement element, String scriptText) {
        GroovyShell shell = new GroovyShell();
        try {
            shell.evaluate(scriptText);
        }
        catch (MissingMethodException | MissingPropertyException | CompilationFailedException ex) {
            if (ex instanceof CompilationFailedException) {
                return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, ex.getMessage());
            }
            return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, String.format(Messages.getString("EmbeddedGroovyScriptChecker.1"), ex.getMessage()));
        }
        return null;
    }

    private CheckerIssue checkEmptyScriptContent(String bpmnFile, BpmnElement element, String scriptFormat, String script) {
        if (scriptFormat != null && (script == null || script.isEmpty())) {
            return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, Messages.getString("EmbeddedGroovyScriptChecker.2"));
        }
        return null;
    }

    private CheckerIssue checkEmptyScriptFormat(String bpmnFile, BpmnElement element, String scriptFormat, String script) {
        if (scriptFormat == null && script != null) {
            return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, Messages.getString("EmbeddedGroovyScriptChecker.3"));
        }
        return null;
    }

    private CheckerIssue checkInvalidScriptContent(String bpmnFile, BpmnElement element, String scriptFormat, String script) {
        if (scriptFormat != null && scriptFormat.toLowerCase().equals("groovy") && script != null) {
            return this.parseGroovyCode(bpmnFile, element, script);
        }
        return null;
    }
}

