/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ModelChecker;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CheckerFactory {
    private static final Logger LOGGER = Logger.getLogger(CheckerFactory.class.getName());
    private Map<String, String> incorrectCheckers = new HashMap<String, String>();

    public Collection[] createCheckerInstances(RuleSet ruleConf, Collection<String> resourcesNewestVersions, BpmnScanner bpmnScanner, ProcessVariablesScanner scanner, Collection<DataFlowRule> dataFlowRules, Collection<ProcessVariable> processVariables, Map<AnomalyContainer, List<Path>> invalidPathMap) {
        HashSet<String> instantiatedCheckerClasses = new HashSet<String>();
        Collection[] checkers = new Collection[]{this.createElementCheckers(instantiatedCheckerClasses, ruleConf, resourcesNewestVersions, bpmnScanner, scanner), this.createModelCheckers(instantiatedCheckerClasses, ruleConf, bpmnScanner, dataFlowRules, processVariables, invalidPathMap)};
        return checkers;
    }

    private Collection<ElementChecker> createElementCheckers(HashSet<String> instantiatedCheckerClasses, RuleSet ruleConf, Collection<String> resourcesNewestVersions, BpmnScanner bpmnScanner, ProcessVariablesScanner scanner) {
        ArrayList<ElementChecker> elementCheckers = new ArrayList<ElementChecker>();
        for (Map<String, Rule> rules : ruleConf.getElementRules().values()) {
            for (Rule rule : rules.values()) {
                String fullyQualifiedName = this.getFullyQualifiedName(rule);
                if (!rule.isActive() || fullyQualifiedName.isEmpty()) continue;
                try {
                    AbstractElementChecker newChecker;
                    Constructor<?> c;
                    Class<?> clazz;
                    if (!rule.getName().equals("VersioningChecker") && !rule.getName().equals("MessageCorrelationChecker")) {
                        clazz = Class.forName(fullyQualifiedName);
                        c = clazz.getConstructor(Rule.class, BpmnScanner.class);
                        newChecker = (AbstractElementChecker)c.newInstance(rule, bpmnScanner);
                    } else if (scanner != null && rule.getName().equals("MessageCorrelationChecker")) {
                        clazz = Class.forName(fullyQualifiedName);
                        c = clazz.getConstructor(Rule.class, BpmnScanner.class, ProcessVariablesScanner.class);
                        newChecker = (AbstractElementChecker)c.newInstance(rule, bpmnScanner, scanner);
                    } else {
                        clazz = Class.forName(fullyQualifiedName);
                        c = clazz.getConstructor(Rule.class, BpmnScanner.class, Collection.class);
                        newChecker = (AbstractElementChecker)c.newInstance(rule, bpmnScanner, resourcesNewestVersions);
                    }
                    if (instantiatedCheckerClasses.contains(fullyQualifiedName)) {
                        if (newChecker.isSingletonChecker()) {
                            this.setIncorrectCheckers(rule, String.format(Messages.getString("CheckerFactory.9"), rule.getName()));
                            LOGGER.warning("Multiple rule definitions of checker '" + rule.getName() + "' found. Only the first rule will be applied.");
                            continue;
                        }
                        elementCheckers.add(newChecker);
                        continue;
                    }
                    instantiatedCheckerClasses.add(fullyQualifiedName);
                    elementCheckers.add(newChecker);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOGGER.warning("Class " + fullyQualifiedName + " not found or couldn't be instantiated");
                    rule.deactivate();
                }
            }
        }
        return elementCheckers;
    }

    private Collection<ModelChecker> createModelCheckers(HashSet<String> instantiatedCheckerClasses, RuleSet ruleConf, BpmnScanner bpmnScanner, Collection<DataFlowRule> dataFlowRules, Collection<ProcessVariable> processVariables, Map<AnomalyContainer, List<Path>> invalidPathMap) {
        ArrayList<ModelChecker> modelCheckers = new ArrayList<ModelChecker>();
        for (Map<String, Rule> rules : ruleConf.getModelRules().values()) {
            for (Rule rule : rules.values()) {
                String fullyQualifiedName = this.getFullyQualifiedName(rule);
                if (!rule.isActive() || fullyQualifiedName.isEmpty()) continue;
                try {
                    ModelChecker newModelChecker;
                    Constructor<?> c;
                    Class<?> clazz = Class.forName(fullyQualifiedName);
                    if (rule.getName().equals("DataFlowChecker")) {
                        c = clazz.getConstructor(Rule.class, Collection.class, Collection.class);
                        newModelChecker = (ModelChecker)c.newInstance(rule, dataFlowRules, processVariables);
                    } else if (rule.getName().equals("ProcessVariablesModelChecker")) {
                        c = clazz.getConstructor(Rule.class, Map.class);
                        newModelChecker = (ModelChecker)c.newInstance(rule, invalidPathMap);
                    } else {
                        c = clazz.getConstructor(Rule.class, BpmnScanner.class);
                        newModelChecker = (ModelChecker)c.newInstance(rule, bpmnScanner);
                    }
                    if (instantiatedCheckerClasses.contains(fullyQualifiedName)) {
                        if (newModelChecker.isSingletonChecker()) {
                            this.setIncorrectCheckers(rule, String.format(Messages.getString("CheckerFactory.9"), rule.getName()));
                            LOGGER.warning("Multiple rule definitions of checker '" + rule.getName() + "' found. Only the first rule will be applied.");
                            continue;
                        }
                        modelCheckers.add(newModelChecker);
                        continue;
                    }
                    instantiatedCheckerClasses.add(fullyQualifiedName);
                    modelCheckers.add(newModelChecker);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.warning("Class " + fullyQualifiedName + " not found or couldn't be instantiated");
                    rule.deactivate();
                }
            }
        }
        return modelCheckers;
    }

    private String getFullyQualifiedName(Rule rule) {
        String fullyQualifiedName = "";
        if (Arrays.asList(RuntimeConfig.getInstance().getViadeeRules()).contains(rule.getName())) {
            fullyQualifiedName = "de.viadee.bpm.vPAV.processing.checker." + rule.getName().trim();
        } else if (rule.getSettings() != null && rule.getSettings().containsKey("external_Location")) {
            fullyQualifiedName = rule.getSettings().get("external_Location").getValue() + "." + rule.getName().trim();
        }
        if (fullyQualifiedName.isEmpty()) {
            LOGGER.warning("Checker '" + rule.getName() + "' not found. Please add setting for external_location in ruleSet.xml.");
            rule.deactivate();
            this.setIncorrectCheckers(rule, String.format(Messages.getString("CheckerFactory.8"), rule.getName()));
        }
        return fullyQualifiedName;
    }

    public void setIncorrectCheckers(Rule rule, String message) {
        if (!this.getIncorrectCheckers().containsKey(rule.getName())) {
            this.incorrectCheckers.put(rule.getName(), message);
        }
    }

    public Map<String, String> getIncorrectCheckers() {
        return this.incorrectCheckers;
    }
}

