/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.constants.ConfigConstants;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class BoundaryErrorChecker
extends AbstractElementChecker {
    private static Logger logger = Logger.getLogger(BoundaryErrorChecker.class.getName());

    public BoundaryErrorChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        Map<String, String> errorEventDef;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String mappedTaskId = null;
        String implementation = null;
        String implementationRef = null;
        if (bpmnElement.getElementType().getTypeName().equals("boundaryEvent") && (errorEventDef = this.bpmnScanner.getErrorEvent(bpmnElement.getId())).size() != 0) {
            mappedTaskId = this.bpmnScanner.getErrorEventMapping(bpmnElement.getId());
            implementation = this.bpmnScanner.getImplementation(mappedTaskId);
            implementationRef = this.bpmnScanner.getImplementationReference(mappedTaskId, implementation);
            if (errorEventDef.entrySet().iterator().next().getKey() == null || errorEventDef.entrySet().iterator().next().getKey().isEmpty()) {
                String errorCode = this.bpmnScanner.getErrorCodeVar(bpmnElement.getId());
                if (errorCode == null || errorCode.isEmpty()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("BoundaryErrorChecker.0"), CheckName.checkName(bpmnElement))));
                } else {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("BoundaryErrorChecker.1"), CheckName.checkName(bpmnElement))));
                }
            } else {
                Map<String, String> errorDef = this.bpmnScanner.getErrorDef(errorEventDef.entrySet().iterator().next().getKey());
                if (errorDef.entrySet().iterator().next().getValue() == null || errorDef.entrySet().iterator().next().getValue().isEmpty()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("BoundaryErrorChecker.2"), CheckName.checkName(bpmnElement))));
                } else if (implementation != null) {
                    if (implementation.equals("camunda:delegateExpression")) {
                        this.checkBeanMapping(element, issues, bpmnElement, errorDef.entrySet().iterator().next().getValue(), implementationRef);
                    } else if (implementation.equals("camunda:class") && !this.readResourceFile(implementationRef, errorDef.entrySet().iterator().next().getValue())) {
                        issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("BoundaryErrorChecker.3"), CheckName.checkName(bpmnElement), implementationRef)));
                    }
                }
                if (errorDef.entrySet().iterator().next().getKey() == null || errorDef.entrySet().iterator().next().getKey().isEmpty()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("BoundaryErrorChecker.4"), CheckName.checkName(bpmnElement))));
                }
                if (errorEventDef.entrySet().iterator().next().getValue() == null || errorEventDef.entrySet().iterator().next().getValue().isEmpty()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("BoundaryErrorChecker.5"), CheckName.checkName(bpmnElement))));
                }
            }
        }
        return issues;
    }

    private void checkBeanMapping(BpmnElement element, Collection<CheckerIssue> issues, BaseElement bpmnElement, String errorDefEntry, String implementationRef) {
        if (RuntimeConfig.getInstance().getBeanMapping() != null) {
            Builder treeBuilder = new Builder();
            Tree tree = treeBuilder.build(implementationRef);
            Iterable identifierNodes = tree.getIdentifierNodes();
            if (identifierNodes.iterator().hasNext()) {
                for (IdentifierNode node : identifierNodes) {
                    String classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                    if (classFile != null && classFile.trim().length() > 0) {
                        if (this.checkClassFile(classFile)) {
                            if (this.readResourceFile(classFile, errorDefEntry)) continue;
                            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("BoundaryErrorChecker.6"), CheckName.checkName(bpmnElement), node.getName())));
                            continue;
                        }
                        issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, Messages.getString("BoundaryErrorChecker.7")));
                        continue;
                    }
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("BoundaryErrorChecker.8"), implementationRef)));
                }
            }
        } else if (!this.checkClassFile(implementationRef)) {
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("BoundaryErrorChecker.9"), implementationRef, CheckName.checkName(bpmnElement))));
        }
    }

    private boolean readResourceFile(String className, String errorCode) {
        String fileName = className.replaceAll("\\.", "/") + ".java";
        boolean matchingErrorCode = false;
        if (fileName != null && fileName.trim().length() > 0) {
            try {
                DirectoryScanner scanner = new DirectoryScanner();
                if (RuntimeConfig.getInstance().isTest()) {
                    if (fileName.endsWith(".java")) {
                        scanner.setBasedir("src/test/java/");
                    } else {
                        scanner.setBasedir("src/test/resources/");
                    }
                } else if (fileName.endsWith(".java")) {
                    scanner.setBasedir("src/main/java/");
                } else {
                    scanner.setBasedir(ConfigConstants.getInstance().getBasepath());
                }
                Resource s = scanner.getResource(fileName);
                if (s.isExists()) {
                    InputStreamReader resource = new InputStreamReader(new FileInputStream(s.toString()));
                    String methodBody = IOUtils.toString((Reader)resource);
                    return this.validateContent(methodBody, errorCode);
                }
                logger.warning("Class " + fileName + " could not be read or does not exist");
            }
            catch (IOException ex) {
                logger.warning("Resource '" + fileName + "' could not be read: " + ex.getMessage());
            }
        }
        return matchingErrorCode;
    }

    private boolean validateContent(String methodBody, String errorCode) {
        if (methodBody != null && !methodBody.isEmpty() && methodBody.contains("throw new BpmnError")) {
            String temp = methodBody.substring(methodBody.indexOf("throw new BpmnError"));
            if ((temp = temp.substring(0, temp.indexOf(";") + 1)).contains("\"")) {
                String delErrorCode = temp.substring(temp.indexOf("\"") + 1, temp.lastIndexOf("\""));
                if (delErrorCode.equals(errorCode)) {
                    return true;
                }
            } else {
                logger.warning("The error code could not be read because currently only string literals are supported.");
            }
        }
        return false;
    }

    private boolean checkClassFile(String className) {
        String classPath = className.replaceAll("\\.", "/") + ".java";
        try {
            RuntimeConfig.getInstance().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

