/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.EntryPoint;
import de.viadee.bpm.vPAV.processing.JavaReaderStatic;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.Node;
import de.viadee.bpm.vPAV.processing.model.data.CamundaProcessVariableFunctions;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.OutSetCFG;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableBlock;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import soot.Body;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.internal.JInstanceFieldRef;
import soot.jimple.internal.JInterfaceInvokeExpr;
import soot.jimple.internal.JInvokeStmt;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JSpecialInvokeExpr;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.Block;

class VariablesExtractor {
    private List<Value> constructorArgs;
    private JavaReaderStatic javaReaderStatic;
    private String returnStmt;

    VariablesExtractor(JavaReaderStatic reader) {
        this.javaReaderStatic = reader;
    }

    private boolean checkArgBoxes(EntryPoint entry, String assignment, String invoke, JInterfaceInvokeExpr expr, BpmnElement element) {
        if (expr.getMethodRef().getName().equals(entry.getEntryPoint()) && !assignment.isEmpty()) {
            if (element.getBaseElement().getElementType().getTypeName().equals("receiveTask")) {
                String message = expr.getArgBox(0).getValue().toString().replaceAll("\"", "");
                return message.equals(entry.getMessageName());
            }
            for (Value value : expr.getArgs()) {
                if (!value.toString().equals(invoke)) continue;
                return true;
            }
        }
        return false;
    }

    ListMultimap<String, ProcessVariableOperation> checkWriteAccess(Body body, BpmnElement element, String resourceFilePath, EntryPoint entryPoint) {
        ArrayListMultimap initialOperations = ArrayListMultimap.create();
        if (body.getMethod().getName().equals(entryPoint.getMethodName())) {
            UnitPatchingChain pc = body.getUnits();
            String assignment = "";
            String invoke = "";
            for (Unit unit : pc) {
                JInterfaceInvokeExpr expr;
                if (unit instanceof AssignStmt) {
                    JInterfaceInvokeExpr expr2;
                    String rightBox = ((AssignStmt)unit).getRightOpBox().getValue().toString();
                    String leftBox = ((AssignStmt)unit).getLeftOpBox().getValue().toString();
                    if (rightBox.contains("org.camunda.bpm.engine.variable.VariableMap createVariables()")) {
                        assignment = leftBox;
                    }
                    if (rightBox.contains(entryPoint.getEntryPoint()) && rightBox.contains(invoke)) {
                        return initialOperations;
                    }
                    if (((AssignStmt)unit).getRightOpBox().getValue() instanceof JInterfaceInvokeExpr && (expr2 = (JInterfaceInvokeExpr)((AssignStmt)unit).getRightOpBox().getValue()) != null) {
                        if (expr2.getMethodRef().getDeclaringClass().equals(Scene.v().forceResolve(VariableMap.class.getName(), 2))) {
                            initialOperations.putAll(this.parseInitialExpression(expr2, element, resourceFilePath));
                            invoke = leftBox;
                        }
                        if (this.checkArgBoxes(entryPoint, assignment, invoke, expr2, element)) {
                            return initialOperations;
                        }
                    }
                }
                if (!(unit instanceof InvokeStmt) || !(((InvokeStmt)unit).getInvokeExprBox().getValue() instanceof JInterfaceInvokeExpr) || (expr = (JInterfaceInvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue()) == null) continue;
                if (expr.getMethodRef().getDeclaringClass().equals(Scene.v().forceResolve(Map.class.getName(), 2))) {
                    initialOperations.putAll(this.parseInitialExpression(expr, element, resourceFilePath));
                }
                if (!this.checkArgBoxes(entryPoint, assignment, invoke, expr, element)) continue;
                return initialOperations;
            }
        }
        return initialOperations;
    }

    VariableBlock blockIterator(Set<String> classPaths, CallGraph cg, Block block, OutSetCFG outSet, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId, VariableBlock variableBlock, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph, Node node) {
        if (variableBlock == null) {
            variableBlock = new VariableBlock(block, new ArrayList<ProcessVariableOperation>());
        }
        String paramName = "";
        int argsCounter = 0;
        int instanceFieldRef = Integer.MAX_VALUE;
        boolean nodeSaved = true;
        for (Unit unit : block) {
            JVirtualInvokeExpr expr;
            String argument;
            Pattern pattern;
            Object matcher;
            if (unit instanceof IdentityStmt && ((IdentityStmt)unit).getRightOp() instanceof ParameterRef && ((IdentityStmt)unit).getRightOp().getType().toString().equals("java.lang.String") && ((Matcher)(matcher = (pattern = Pattern.compile("(@parameter(.):)(.*)")).matcher(argument = ((IdentityStmt)unit).getRightOpBox().getValue().toString()))).matches()) {
                Value val = args.get(Integer.parseInt(((Matcher)matcher).group(2)));
                paramName = val.toString().replace("\"", "");
                assignmentStmt = ((JIdentityStmt)unit).getLeftOpBox().getValue().toString();
            }
            if (unit instanceof ReturnStmt && ((JReturnStmt)unit).getOpBox().getValue().toString().equals(assignmentStmt)) {
                this.setReturnStmt(paramName);
            }
            if (unit instanceof InvokeStmt) {
                try {
                    boolean passesDelegateExecution = false;
                    InvokeExpr calledMethod = (InvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue();
                    matcher = calledMethod.getMethodRef().getParameterTypes().iterator();
                    while (matcher.hasNext()) {
                        Type parameter = (Type)matcher.next();
                        if (!((RefType)parameter).getClassName().equals("org.camunda.bpm.engine.delegate.DelegateExecution")) continue;
                        passesDelegateExecution = true;
                        break;
                    }
                    if (passesDelegateExecution) {
                        if (!nodeSaved) {
                            controlFlowGraph.addNode(node);
                        }
                        Node newSectionNode = (Node)node.clone();
                        assignmentStmt = this.processInvokeStmt(classPaths, cg, outSet, element, chapter, fieldType, filePath, scopeId, variableBlock, assignmentStmt, controlFlowGraph, node, paramName, argsCounter, unit);
                        paramName = this.returnStmt;
                        node = newSectionNode;
                        nodeSaved = false;
                    } else {
                        assignmentStmt = this.processInvokeStmt(classPaths, cg, outSet, element, chapter, fieldType, filePath, scopeId, variableBlock, assignmentStmt, controlFlowGraph, node, paramName, argsCounter, unit);
                    }
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            if (!(unit instanceof AssignStmt)) continue;
            if (((AssignStmt)unit).getRightOpBox().getValue() instanceof JVirtualInvokeExpr) {
                assignmentStmt = ((AssignStmt)unit).getLeftOpBox().getValue().toString();
                expr = (JVirtualInvokeExpr)((AssignStmt)unit).getRightOpBox().getValue();
                try {
                    if (!nodeSaved) {
                        controlFlowGraph.addNode(node);
                    }
                    Node newSectionNode = (Node)node.clone();
                    this.checkInterProceduralCall(classPaths, cg, outSet, element, chapter, fieldType, scopeId, variableBlock, unit, assignmentStmt, expr.getArgs(), controlFlowGraph, false);
                    paramName = this.returnStmt;
                    node = newSectionNode;
                    nodeSaved = false;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            if (((AssignStmt)unit).getRightOpBox().getValue() instanceof JInterfaceInvokeExpr && (expr = (JInterfaceInvokeExpr)((AssignStmt)unit).getRightOpBox().getValue()) != null) {
                this.parseExpression((JInterfaceInvokeExpr)expr, variableBlock, element, chapter, fieldType, filePath, scopeId, paramName, node);
            }
            if (!(((AssignStmt)unit).getRightOpBox().getValue() instanceof JInstanceFieldRef) || !((Matcher)(matcher = (pattern = Pattern.compile("(\\$r(\\d))")).matcher(argument = ((AssignStmt)unit).getLeftOpBox().getValue().toString()))).matches()) continue;
            if (instanceFieldRef > Integer.parseInt(((Matcher)matcher).group(2))) {
                instanceFieldRef = Integer.parseInt(((Matcher)matcher).group(2));
                assignmentStmt = argument;
                if (this.getConstructorArgs() == null || this.getConstructorArgs().isEmpty()) continue;
                paramName = this.getConstructorArgs().get(++argsCounter - 1).toString();
                continue;
            }
            assignmentStmt = argument;
        }
        if (!nodeSaved && node.getOperations().size() > 0) {
            controlFlowGraph.addNode(node);
        }
        return variableBlock;
    }

    private void parseExpression(JInterfaceInvokeExpr expr, VariableBlock variableBlock, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId, String paramName, Node node) {
        String functionName = expr.getMethodRef().getName();
        int numberOfArg = expr.getArgCount();
        String baseBox = expr.getBaseBox().getValue().getType().toString();
        CamundaProcessVariableFunctions foundMethod = CamundaProcessVariableFunctions.findByNameAndNumberOfBoxes(functionName, baseBox, numberOfArg);
        if (foundMethod != null) {
            int location = foundMethod.getLocation() - 1;
            VariableOperation type = foundMethod.getOperationType();
            if (expr.getMethodRef().getDeclaringClass().getName().equals("org.camunda.bpm.engine.variable.VariableMap")) {
                scopeId = ((CallActivity)element.getBaseElement()).getCalledElement();
            }
            if (expr.getArgBox(location).getValue() instanceof StringConstant) {
                StringConstant variableName = (StringConstant)expr.getArgBox(location).getValue();
                String name = variableName.value.replaceAll("\"", "");
                node.addOperation(new ProcessVariableOperation(name, element, chapter, fieldType, filePath, type, scopeId, element.getFlowAnalysis().getOperationCounter()));
                variableBlock.addProcessVariable(new ProcessVariableOperation(name, element, chapter, fieldType, filePath, type, scopeId, element.getFlowAnalysis().getOperationCounter()));
            } else if (!paramName.isEmpty()) {
                node.addOperation(new ProcessVariableOperation(paramName.replaceAll("\"", ""), element, chapter, fieldType, filePath, type, scopeId, element.getFlowAnalysis().getOperationCounter()));
                variableBlock.addProcessVariable(new ProcessVariableOperation(paramName.replaceAll("\"", ""), element, chapter, fieldType, filePath, type, scopeId, element.getFlowAnalysis().getOperationCounter()));
            } else {
                IssueWriter.createIssue(new Rule("ProcessVariablesModelChecker", true, null, null, null, null), CriticalityEnum.WARNING, filePath, element, String.format(Messages.getString("ProcessVariablesModelChecker.4"), new Object[]{CheckName.checkName(element.getBaseElement()), chapter, fieldType.getDescription()}));
            }
        }
    }

    private ListMultimap<String, ProcessVariableOperation> parseInitialExpression(JInterfaceInvokeExpr expr, BpmnElement element, String resourceFilePath) {
        ArrayListMultimap initialOperations = ArrayListMultimap.create();
        String functionName = expr.getMethodRef().getName();
        int numberOfArg = expr.getArgCount();
        String baseBox = expr.getBaseBox().getValue().getType().toString();
        CamundaProcessVariableFunctions foundMethod = CamundaProcessVariableFunctions.findByNameAndNumberOfBoxes(functionName, baseBox, numberOfArg);
        if (foundMethod != null) {
            int location = foundMethod.getLocation() - 1;
            VariableOperation type = foundMethod.getOperationType();
            if (expr.getArgBox(location).getValue() instanceof StringConstant) {
                StringConstant variableName = (StringConstant)expr.getArgBox(location).getValue();
                String name = variableName.value.replaceAll("\"", "");
                initialOperations.put((Object)name, (Object)new ProcessVariableOperation(name, element, ElementChapter.Code, KnownElementFieldType.Initial, resourceFilePath, type, element.getBaseElement().getScope().getAttributeValue("id"), element.getFlowAnalysis().getOperationCounter()));
            }
        }
        return initialOperations;
    }

    private String processInvokeStmt(Set<String> classPaths, CallGraph cg, OutSetCFG outSet, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId, VariableBlock variableBlock, String assignmentStmt, ControlFlowGraph controlFlowGraph, Node node, String paramName, int argsCounter, Unit unit) {
        JInterfaceInvokeExpr expr;
        if (((InvokeStmt)unit).getInvokeExprBox().getValue() instanceof JInterfaceInvokeExpr && (expr = (JInterfaceInvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue()) != null) {
            if (argsCounter > 0) {
                this.parseExpression(expr, variableBlock, element, chapter, fieldType, filePath, scopeId, this.getConstructorArgs().get(argsCounter - 1).toString(), node);
            } else {
                this.parseExpression(expr, variableBlock, element, chapter, fieldType, filePath, scopeId, paramName, node);
            }
        }
        if (((InvokeStmt)unit).getInvokeExprBox().getValue() instanceof JVirtualInvokeExpr) {
            expr = (JVirtualInvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue();
            this.checkInterProceduralCall(classPaths, cg, outSet, element, chapter, fieldType, scopeId, variableBlock, unit, assignmentStmt, expr.getArgs(), controlFlowGraph, true);
        }
        if (((InvokeStmt)unit).getInvokeExprBox().getValue() instanceof JSpecialInvokeExpr) {
            expr = (JSpecialInvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue();
            if (((InvokeStmt)unit).getInvokeExprBox().getValue().toString().contains("void <init>")) {
                this.setConstructorArgs(expr.getArgs());
                assignmentStmt = expr.getBaseBox().getValue().toString();
            } else {
                this.checkInterProceduralCall(classPaths, cg, outSet, element, chapter, fieldType, scopeId, variableBlock, unit, assignmentStmt, expr.getArgs(), controlFlowGraph, true);
            }
        }
        return assignmentStmt;
    }

    private List<Value> getConstructorArgs() {
        return this.constructorArgs;
    }

    private void checkInterProceduralCall(Set<String> classPaths, CallGraph cg, OutSetCFG outSet, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, VariableBlock variableBlock, Unit unit, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph, boolean isInvoke) {
        Iterator sources = cg.edgesOutOf(unit);
        while (sources.hasNext()) {
            Edge src = (Edge)sources.next();
            String methodName = src.tgt().getName();
            String className = src.tgt().getDeclaringClass().getName();
            if (!classPaths.contains(className = ProcessVariablesScanner.cleanString(className, false))) continue;
            SootMethod sootMethod = isInvoke && !className.contains("$") ? ((JInvokeStmt)unit).getInvokeExpr().getMethodRef().resolve() : (!isInvoke && !className.contains("$") ? ((JAssignStmt)unit).getInvokeExpr().getMethodRef().resolve() : null);
            controlFlowGraph.incrementRecursionCounter();
            controlFlowGraph.addPriorLevel(controlFlowGraph.getPriorLevel());
            controlFlowGraph.resetInternalNodeCounter();
            this.javaReaderStatic.classFetcherRecursive(classPaths, className, methodName, className, element, chapter, fieldType, scopeId, outSet, variableBlock, assignmentStmt, args, controlFlowGraph, sootMethod);
            controlFlowGraph.removePriorLevel();
            controlFlowGraph.decrementRecursionCounter();
            controlFlowGraph.setInternalNodeCounter(controlFlowGraph.getPriorLevel());
        }
    }

    private void setConstructorArgs(List<Value> args) {
        this.constructorArgs = args;
    }

    private void setReturnStmt(String returnStmt) {
        this.returnStmt = returnStmt;
    }
}

