/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.processing.EntryPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.internal.JInterfaceInvokeExpr;
import soot.options.Options;

public class ProcessVariablesScanner {
    private Set<String> javaResources;
    private Map<String, Collection<String>> messageIdToVariableMap = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> processIdToVariableMap = new HashMap<String, Collection<String>>();
    private Set<String> camundaProcessEntryPoints = new HashSet<String>();
    private List<EntryPoint> entryPoints = new ArrayList<EntryPoint>();
    private List<EntryPoint> intermediateEntryPoints = new ArrayList<EntryPoint>();

    public ProcessVariablesScanner(Set<String> javaResources) {
        this.javaResources = javaResources;
        this.camundaProcessEntryPoints.add("startProcessInstanceById");
        this.camundaProcessEntryPoints.add("startProcessInstanceByKey");
        this.camundaProcessEntryPoints.add("startProcessInstanceByMessage");
        this.camundaProcessEntryPoints.add("startProcessInstanceByMessageAndProcessDefinitionId");
        this.camundaProcessEntryPoints.add("createMessageCorrelation");
    }

    public void scanProcessVariables() {
        for (String filePath : this.javaResources) {
            if (filePath.startsWith("javax")) continue;
            HashSet<String> messageIds = new HashSet<String>();
            HashSet<String> processIds = new HashSet<String>();
            this.retrieveMethod(filePath, messageIds, processIds);
        }
    }

    private void retrieveMethod(String filePath, Set<String> messageIds, Set<String> processIds) {
        String sootPath = FileScanner.getSootPath();
        System.setProperty("soot.class.path", sootPath);
        Options.v().set_whole_program(true);
        Options.v().set_allow_phantom_refs(true);
        ArrayList<String> excludedClasses = new ArrayList<String>();
        excludedClasses.add("java.*");
        excludedClasses.add("sun.*");
        excludedClasses.add("jdk.*");
        excludedClasses.add("javax.*");
        Options.v().set_exclude(excludedClasses);
        Options.v().set_no_bodies_for_excluded(true);
        Scene.v().extendSootClassPath(Scene.v().defaultClassPath());
        SootClass sootClass = Scene.v().forceResolve(ProcessVariablesScanner.cleanString(filePath, true), 2);
        if (sootClass != null && !sootClass.isInterface()) {
            sootClass.setApplicationClass();
            Scene.v().loadNecessaryClasses();
            for (SootMethod method : sootClass.getMethods()) {
                if (method.isPhantom() || method.isAbstract()) continue;
                Body body = method.retrieveActiveBody();
                for (String entryPoint : this.camundaProcessEntryPoints) {
                    if (body.toString().contains(entryPoint)) {
                        UnitPatchingChain pc = body.getUnits();
                        for (Unit unit : pc) {
                            JInterfaceInvokeExpr expr;
                            String rightBox;
                            if (unit instanceof AssignStmt && (rightBox = ((AssignStmt)unit).getRightOpBox().getValue().toString()).contains(entryPoint) && ((AssignStmt)unit).getRightOpBox().getValue() instanceof JInterfaceInvokeExpr) {
                                expr = (JInterfaceInvokeExpr)((AssignStmt)unit).getRightOpBox().getValue();
                                this.checkExpression(filePath, messageIds, method, entryPoint, expr);
                            }
                            if (!(unit instanceof InvokeStmt) || !(rightBox = ((InvokeStmt)unit).getInvokeExprBox().getValue().toString()).contains(entryPoint) || !(((InvokeStmt)unit).getInvokeExprBox().getValue() instanceof JInterfaceInvokeExpr)) continue;
                            expr = (JInterfaceInvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue();
                            this.checkExpression(filePath, messageIds, method, entryPoint, expr);
                        }
                    }
                    if (!body.toString().contains("createMessageCorrelation")) continue;
                    processIds.add(entryPoint);
                }
            }
        }
    }

    private void checkExpression(String filePath, Set<String> messageIds, SootMethod method, String entryPoint, JInterfaceInvokeExpr expr) {
        if (expr != null) {
            String ex = expr.getArgBox(0).getValue().toString();
            if (entryPoint.equals("createMessageCorrelation")) {
                this.intermediateEntryPoints.add(new EntryPoint(filePath, method.getName(), ex.replaceAll("\"", ""), entryPoint));
            } else {
                messageIds.add(entryPoint);
                this.entryPoints.add(new EntryPoint(filePath, method.getName(), ex.replaceAll("\"", ""), entryPoint));
            }
        }
    }

    static String cleanString(String className, boolean dot) {
        String replaceDot = ".";
        String replaceEmpty = "";
        String replaceSingleBackSlash = "\\";
        String replaceSingleForwardSlash = "/";
        String replaceDotClass = ".class";
        String replaceDotJava = ".java";
        if (dot) {
            className = System.getProperty("os.name").startsWith("Windows") ? className.replace("\\", ".").replace("/", ".").replace(".class", "") : className.replace("/", ".").replace(".class", "").replace(".java", "");
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            className = className.replace(".", "\\");
            className = className.concat(".class");
        } else {
            className = className.replace(".", "/");
            className = className.concat(".class");
        }
        return className;
    }

    public List<EntryPoint> getIntermediateEntryPoints() {
        return this.intermediateEntryPoints;
    }

    public List<EntryPoint> getEntryPoints() {
        return this.entryPoints;
    }

    public Map<String, Collection<String>> getMessageIdToVariableMap() {
        return this.messageIdToVariableMap;
    }

    public Map<String, Collection<String>> getProcessIdToVariableMap() {
        return this.processIdToVariableMap;
    }
}

