/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.JavaReaderStatic;
import de.viadee.bpm.vPAV.processing.ProcessingException;
import de.viadee.bpm.vPAV.processing.ResourceFileReader;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.ExpressionNode;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELException;
import org.apache.commons.collections4.map.LinkedMap;
import org.camunda.bpm.engine.impl.juel.Builder;
import org.camunda.bpm.engine.impl.juel.IdentifierNode;
import org.camunda.bpm.engine.impl.juel.Tree;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.impl.instance.LoopDataInputRef;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.CompletionCondition;
import org.camunda.bpm.model.bpmn.instance.ConditionExpression;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.InputDataItem;
import org.camunda.bpm.model.bpmn.instance.LoopCardinality;
import org.camunda.bpm.model.bpmn.instance.LoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.Script;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaFormData;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaFormField;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaOut;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public final class ProcessVariableReader {
    private final Map<String, String> decisionRefToPathMap;
    private final BpmnScanner bpmnScanner;
    private final Rule rule;

    public ProcessVariableReader(Map<String, String> decisionRefToPathMap, Rule rule, BpmnScanner scanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.rule = rule;
        this.bpmnScanner = scanner;
    }

    public ListMultimap<String, ProcessVariableOperation> getVariablesFromElement(FileScanner fileScanner, BpmnElement element, ControlFlowGraph controlFlowGraph) {
        JavaReaderStatic javaReaderStatic = new JavaReaderStatic();
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        ExtensionElements extensionElements = baseElement.getExtensionElements();
        processVariables.putAll(this.searchVariablesInMultiInstanceTask(javaReaderStatic, fileScanner, element, controlFlowGraph));
        processVariables.putAll(this.getVariablesFromInputMapping(javaReaderStatic, element, fileScanner, controlFlowGraph));
        if (extensionElements != null) {
            processVariables.putAll(this.getVariablesFromExecutionListener(javaReaderStatic, fileScanner, element, extensionElements, scopeElementId, ElementChapter.ExecutionListenerStart, controlFlowGraph));
        }
        processVariables.putAll(this.getVariablesFromTask(javaReaderStatic, fileScanner, element, controlFlowGraph));
        processVariables.putAll(this.searchVariablesFromSequenceFlow(javaReaderStatic, fileScanner, element, controlFlowGraph));
        processVariables.putAll(this.searchExtensionsElements(javaReaderStatic, fileScanner, element, controlFlowGraph));
        processVariables.putAll(this.getVariablesFromSignalsAndMessage(javaReaderStatic, element, fileScanner, controlFlowGraph));
        processVariables.putAll(this.getVariablesFromLinks(javaReaderStatic, element, fileScanner, controlFlowGraph));
        if (extensionElements != null) {
            processVariables.putAll(this.getVariablesFromExecutionListener(javaReaderStatic, fileScanner, element, extensionElements, scopeElementId, ElementChapter.ExecutionListenerEnd, controlFlowGraph));
        }
        processVariables.putAll(this.getVariablesFromOutputMapping(javaReaderStatic, element, fileScanner, controlFlowGraph));
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromSignalsAndMessage(JavaReaderStatic javaReaderStatic, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        ArrayList<String> signalRefs = this.bpmnScanner.getSignalRefs(element.getBaseElement().getId());
        ArrayList<String> messagesRefs = this.bpmnScanner.getMessageRefs(element.getBaseElement().getId());
        processVariables.putAll(this.getSignalVariables(javaReaderStatic, signalRefs, element, fileScanner, controlFlowGraph));
        processVariables.putAll(this.getMessageVariables(javaReaderStatic, messagesRefs, element, fileScanner, controlFlowGraph));
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getSignalVariables(JavaReaderStatic javaReaderStatic, ArrayList<String> signalRefs, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String signalID : signalRefs) {
            names.add(this.bpmnScanner.getSignalName(signalID));
        }
        for (String signalName : names) {
            processVariables.putAll(this.checkMessageAndSignalForExpression(javaReaderStatic, signalName, element, fileScanner, ElementChapter.Signal, KnownElementFieldType.Signal, scopeElementId, controlFlowGraph));
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getMessageVariables(JavaReaderStatic javaReaderStatic, ArrayList<String> messageRefs, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String messageID : messageRefs) {
            names.add(this.bpmnScanner.getMessageName(messageID));
        }
        for (String messageName : names) {
            processVariables.putAll(this.checkMessageAndSignalForExpression(javaReaderStatic, messageName, element, fileScanner, ElementChapter.Message, KnownElementFieldType.Message, scopeElementId, controlFlowGraph));
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromLinks(JavaReaderStatic javaReaderStatic, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        ArrayList<String> links = this.bpmnScanner.getLinkRefs(element.getBaseElement().getId());
        processVariables.putAll(this.getLinkVariables(javaReaderStatic, links, element, fileScanner, controlFlowGraph));
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getLinkVariables(JavaReaderStatic javaReaderStatic, ArrayList<String> links, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        for (String link : links) {
            processVariables.putAll(this.checkMessageAndSignalForExpression(javaReaderStatic, link, element, fileScanner, ElementChapter.Signal, KnownElementFieldType.Signal, scopeElementId, controlFlowGraph));
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromInputMapping(JavaReaderStatic javaReaderStatic, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap inputMappingProcessVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        HashMap<String, Map<String, String>> inputVariables = this.bpmnScanner.getInputMapping(element.getBaseElement().getId());
        LinkedMap<String, String> inputMappingType = this.bpmnScanner.getMappingType(element.getBaseElement().getId(), "camunda:inputParameter");
        for (Map.Entry entry : inputVariables.entrySet()) {
            for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                if (((String)innerEntry.getValue()).isEmpty()) {
                    IssueWriter.createSingleIssue(this.rule, CriticalityEnum.WARNING, element, element.getProcessDefinition(), Messages.getString("ProcessVariableReader.1"));
                    continue;
                }
                if (!((String)inputMappingType.firstKey()).equals("camunda:script")) {
                    inputMappingProcessVariables.putAll(this.checkExpressionForReadVariable(javaReaderStatic, (String)innerEntry.getValue(), (String)innerEntry.getKey(), element, fileScanner, ElementChapter.InputOutput, KnownElementFieldType.InputParameter, baseElement.getId(), controlFlowGraph));
                    continue;
                }
                IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, element.getProcessDefinition(), Messages.getString("ProcessVariableReader.2"));
            }
        }
        return inputMappingProcessVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromOutputMapping(JavaReaderStatic javaReaderStatic, BpmnElement element, FileScanner fileScanner, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap outputMappingProcessVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        HashMap<String, Map<String, String>> outputVariables = this.bpmnScanner.getOutputMapping(element.getBaseElement().getId());
        LinkedMap<String, String> outputMappingType = this.bpmnScanner.getMappingType(element.getBaseElement().getId(), "camunda:outputParameter");
        for (Map.Entry entry : outputVariables.entrySet()) {
            for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                if (((String)innerEntry.getValue()).isEmpty()) {
                    IssueWriter.createSingleIssue(this.rule, CriticalityEnum.WARNING, element, element.getProcessDefinition(), Messages.getString("ProcessVariableReader.1"));
                    continue;
                }
                if (!((String)outputMappingType.firstKey()).equals("camunda:script")) {
                    outputMappingProcessVariables.putAll(this.checkExpressionForReadVariable(javaReaderStatic, (String)innerEntry.getValue(), (String)innerEntry.getKey(), element, fileScanner, ElementChapter.InputOutput, KnownElementFieldType.OutputParameter, scopeElementId, controlFlowGraph));
                    continue;
                }
                IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, element.getProcessDefinition(), Messages.getString("ProcessVariableReader.2"));
            }
        }
        return outputMappingProcessVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> searchExtensionsElements(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ControlFlowGraph controlFlowGraph) {
        ExtensionElements extensionElements;
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeElementId = null;
        if (scopeElement != null) {
            scopeElementId = scopeElement.getAttributeValue("id");
        }
        if ((extensionElements = baseElement.getExtensionElements()) != null) {
            processVariables.putAll(this.getVariablesFromTaskListener(javaReaderStatic, fileScanner, element, extensionElements, scopeElementId, controlFlowGraph));
            processVariables.putAll(this.getVariablesFromFormData(element, extensionElements, scopeElementId));
            processVariables.putAll(this.searchVariablesInInputOutputExtensions(javaReaderStatic, fileScanner, element, extensionElements, scopeElementId));
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromExecutionListener(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ExtensionElements extensionElements, String scopeId, ElementChapter listenerChapter, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaExecutionListener.class).list();
        for (CamundaExecutionListener listener : listenerList) {
            CamundaScript script;
            String l_class;
            String l_delegateExpression;
            if ((!listenerChapter.equals((Object)ElementChapter.ExecutionListenerStart) || !listener.getCamundaEvent().equals("start")) && (!listenerChapter.equals((Object)ElementChapter.ExecutionListenerEnd) || !listener.getCamundaEvent().equals("end"))) continue;
            String l_expression = listener.getCamundaExpression();
            if (l_expression != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, l_expression, element, listenerChapter, KnownElementFieldType.Expression, scopeId));
            }
            if ((l_delegateExpression = listener.getCamundaDelegateExpression()) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, l_delegateExpression, element, listenerChapter, KnownElementFieldType.DelegateExpression, scopeId));
            }
            if ((l_class = listener.getCamundaClass()) != null) {
                processVariables.putAll(javaReaderStatic.getVariablesFromJavaDelegate(fileScanner, listener.getCamundaClass(), element, listenerChapter, KnownElementFieldType.Class, scopeId, controlFlowGraph));
            }
            if ((script = listener.getCamundaScript()) == null || script.getCamundaScriptFormat() == null || !script.getCamundaScriptFormat().equals("groovy")) continue;
            String inlineScript = script.getTextContent();
            if (inlineScript != null && inlineScript.trim().length() > 0) {
                processVariables.putAll(ResourceFileReader.searchProcessVariablesInCode(element, listenerChapter, KnownElementFieldType.InlineScript, null, scopeId, inlineScript));
                continue;
            }
            String resourcePath = script.getCamundaResource();
            if (resourcePath == null) continue;
            processVariables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, listenerChapter, KnownElementFieldType.ExternalScript, scopeId));
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromTaskListener(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ExtensionElements extensionElements, String scopeId, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaTaskListener.class).list();
        for (CamundaTaskListener listener : listenerList) {
            String l_delegateExpression;
            String l_expression = listener.getCamundaExpression();
            if (l_expression != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, l_expression, element, ElementChapter.TaskListener, KnownElementFieldType.Expression, scopeId));
            }
            if ((l_delegateExpression = listener.getCamundaDelegateExpression()) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, l_delegateExpression, element, ElementChapter.TaskListener, KnownElementFieldType.DelegateExpression, scopeId));
            }
            String filePath = "";
            if (listener.getCamundaClass() != null && listener.getCamundaClass().trim().length() > 0) {
                filePath = listener.getCamundaClass().replaceAll("\\.", "/") + ".java";
            }
            processVariables.putAll(ResourceFileReader.readResourceFile(filePath, element, ElementChapter.TaskListener, KnownElementFieldType.Class, scopeId));
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaScriptFormat() == null || !script.getCamundaScriptFormat().equals("groovy")) continue;
            String inlineScript = script.getTextContent();
            if (inlineScript != null && inlineScript.trim().length() > 0) {
                processVariables.putAll(ResourceFileReader.searchProcessVariablesInCode(element, ElementChapter.TaskListener, KnownElementFieldType.InlineScript, null, scopeId, inlineScript));
                continue;
            }
            String resourcePath = script.getCamundaResource();
            if (resourcePath == null) continue;
            processVariables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.TaskListener, KnownElementFieldType.ExternalScript, scopeId));
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromFormData(BpmnElement element, ExtensionElements extensionElements, String scopeElementId) {
        CamundaFormData formData;
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        Query formDataQuery = extensionElements.getElementsQuery().filterByType(CamundaFormData.class);
        if (formDataQuery.count() > 0 && (formData = (CamundaFormData)formDataQuery.singleResult()) != null) {
            Collection formFields = formData.getCamundaFormFields();
            for (CamundaFormField field : formFields) {
                processVariables.put((Object)field.getCamundaId(), (Object)new ProcessVariableOperation(field.getCamundaId(), element, ElementChapter.FormData, KnownElementFieldType.FormField, null, VariableOperation.WRITE, scopeElementId, element.getFlowAnalysis().getOperationCounter()));
            }
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> searchVariablesInInputOutputExtensions(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ExtensionElements extensionElements, String scopeId) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof CallActivity) {
            List inputAssociations = extensionElements.getElementsQuery().filterByType(CamundaIn.class).list();
            for (CamundaIn inputAssociation : inputAssociations) {
                String source = inputAssociation.getCamundaSource();
                if (source == null || source.isEmpty()) {
                    source = inputAssociation.getCamundaSourceExpression();
                    if (source == null || source.isEmpty()) continue;
                    processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, element.getControlFlowGraph(), fileScanner, source, element, ElementChapter.InputData, KnownElementFieldType.CamundaIn, scopeId));
                } else {
                    processVariables.put((Object)source, (Object)new ProcessVariableOperation(source, element, ElementChapter.InputData, KnownElementFieldType.CamundaIn, null, VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter()));
                }
                String target = inputAssociation.getCamundaTarget();
                processVariables.put((Object)target, (Object)new ProcessVariableOperation(target, element, ElementChapter.InputData, KnownElementFieldType.CamundaIn, null, VariableOperation.WRITE, ((CallActivity)baseElement).getCalledElement(), element.getFlowAnalysis().getOperationCounter()));
            }
            List outputAssociations = extensionElements.getElementsQuery().filterByType(CamundaOut.class).list();
            for (CamundaOut outputAssociation : outputAssociations) {
                String target;
                String source = outputAssociation.getCamundaSource();
                if (source == null || source.isEmpty()) {
                    source = outputAssociation.getCamundaSourceExpression();
                    processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, element.getControlFlowGraph(), fileScanner, source, element, ElementChapter.OutputData, KnownElementFieldType.CamundaOut, ((CallActivity)baseElement).getCalledElement()));
                } else {
                    processVariables.put((Object)source, (Object)new ProcessVariableOperation(source, element, ElementChapter.OutputData, KnownElementFieldType.CamundaOut, null, VariableOperation.READ, ((CallActivity)baseElement).getCalledElement(), element.getFlowAnalysis().getOperationCounter()));
                }
                if ((target = outputAssociation.getCamundaTarget()) == null || target.isEmpty()) continue;
                processVariables.put((Object)target, (Object)new ProcessVariableOperation(target, element, ElementChapter.OutputData, KnownElementFieldType.CamundaOut, null, VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> searchVariablesFromSequenceFlow(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap variables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof SequenceFlow) {
            ConditionExpression expression;
            SequenceFlow flow = (SequenceFlow)baseElement;
            BpmnModelElementInstance scopeElement = flow.getScope();
            String scopeId = null;
            if (scopeElement != null) {
                scopeId = scopeElement.getAttributeValue("id");
            }
            if ((expression = flow.getConditionExpression()) != null) {
                if (expression.getLanguage() != null && expression.getLanguage().equals("groovy")) {
                    String inlineScript = expression.getTextContent();
                    if (inlineScript != null && inlineScript.trim().length() > 0) {
                        variables.putAll(ResourceFileReader.searchProcessVariablesInCode(element, ElementChapter.Details, KnownElementFieldType.InlineScript, scopeId, null, inlineScript));
                    } else {
                        String resourcePath = expression.getCamundaResource();
                        if (resourcePath != null) {
                            variables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.Details, KnownElementFieldType.ExternalScript, scopeId));
                        }
                    }
                } else if (expression.getTextContent().trim().length() > 0) {
                    variables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, expression.getTextContent(), element, ElementChapter.Details, KnownElementFieldType.Expression, scopeId));
                }
            }
        }
        return variables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromTask(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeId = null;
        if (scopeElement != null) {
            scopeId = scopeElement.getAttributeValue("id");
        }
        if (baseElement instanceof ServiceTask || baseElement instanceof SendTask || baseElement instanceof BusinessRuleTask) {
            String fileName;
            String t_decisionRef;
            String t_resultVariable;
            ArrayList<String> t_fieldInjectionExpressions;
            String t_delegateExpression;
            String t_expression = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "expression");
            if (t_expression != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, t_expression, element, ElementChapter.Implementation, KnownElementFieldType.Expression, scopeId));
            }
            if ((t_delegateExpression = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "delegateExpression")) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, t_delegateExpression, element, ElementChapter.Implementation, KnownElementFieldType.DelegateExpression, scopeId));
            }
            if ((t_fieldInjectionExpressions = this.bpmnScanner.getFieldInjectionExpression(baseElement.getId())) != null && !t_fieldInjectionExpressions.isEmpty()) {
                for (String t_fieldInjectionExpression : t_fieldInjectionExpressions) {
                    processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, t_fieldInjectionExpression, element, ElementChapter.FieldInjections, KnownElementFieldType.Expression, scopeId));
                }
            }
            if ((t_resultVariable = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "resultVariable")) != null && t_resultVariable.trim().length() > 0) {
                processVariables.put((Object)t_resultVariable, (Object)new ProcessVariableOperation(t_resultVariable, element, ElementChapter.Details, KnownElementFieldType.ResultVariable, null, VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
            if (baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class") != null) {
                processVariables.putAll(javaReaderStatic.getVariablesFromJavaDelegate(fileScanner, baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class"), element, ElementChapter.Implementation, KnownElementFieldType.Class, scopeId, controlFlowGraph));
            }
            if (baseElement instanceof BusinessRuleTask && (t_decisionRef = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "decisionRef")) != null && t_decisionRef.trim().length() > 0 && this.decisionRefToPathMap != null && (fileName = this.decisionRefToPathMap.get(t_decisionRef)) != null) {
                processVariables.putAll(this.readDmnFile(t_decisionRef, fileName, element, ElementChapter.Details, KnownElementFieldType.DMN, scopeId));
            }
        } else if (baseElement instanceof UserTask) {
            String followUpDate;
            String dueDate;
            String candidateGroups;
            String candidateUsers;
            UserTask userTask = (UserTask)baseElement;
            String assignee = userTask.getCamundaAssignee();
            if (assignee != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, assignee, element, ElementChapter.Details, KnownElementFieldType.Assignee, scopeId));
            }
            if ((candidateUsers = userTask.getCamundaCandidateUsers()) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, candidateUsers, element, ElementChapter.Details, KnownElementFieldType.CandidateUsers, scopeId));
            }
            if ((candidateGroups = userTask.getCamundaCandidateGroups()) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, candidateGroups, element, ElementChapter.Details, KnownElementFieldType.CandidateGroups, scopeId));
            }
            if ((dueDate = userTask.getCamundaDueDate()) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, dueDate, element, ElementChapter.Details, KnownElementFieldType.DueDate, scopeId));
            }
            if ((followUpDate = userTask.getCamundaFollowUpDate()) != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, followUpDate, element, ElementChapter.Details, KnownElementFieldType.FollowUpDate, scopeId));
            }
        } else if (baseElement instanceof ScriptTask) {
            String resultVariable;
            ScriptTask scriptTask = (ScriptTask)baseElement;
            if (scriptTask.getScriptFormat() != null && scriptTask.getScriptFormat().equals("groovy")) {
                Script script = scriptTask.getScript();
                if (script != null && script.getTextContent() != null && script.getTextContent().trim().length() > 0) {
                    processVariables.putAll(ResourceFileReader.searchProcessVariablesInCode(element, ElementChapter.Details, KnownElementFieldType.InlineScript, null, scopeId, script.getTextContent()));
                } else {
                    String resourcePath = scriptTask.getCamundaResource();
                    if (resourcePath != null) {
                        processVariables.putAll(this.getVariablesFromGroovyScript(resourcePath, element, ElementChapter.Details, KnownElementFieldType.ExternalScript, scopeId));
                    }
                }
            }
            if ((resultVariable = scriptTask.getCamundaResultVariable()) != null && resultVariable.trim().length() > 0) {
                processVariables.put((Object)resultVariable, (Object)new ProcessVariableOperation(resultVariable, element, ElementChapter.Details, KnownElementFieldType.ResultVariable, null, VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
        } else if (baseElement instanceof CallActivity) {
            String caseRef;
            CallActivity callActivity = (CallActivity)baseElement;
            String calledElement = callActivity.getCalledElement();
            if (calledElement != null && calledElement.trim().length() > 0) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, calledElement, element, ElementChapter.Details, KnownElementFieldType.CalledElement, scopeId));
            }
            if ((caseRef = callActivity.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "caseRef")) != null && caseRef.trim().length() > 0) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, caseRef, element, ElementChapter.Details, KnownElementFieldType.CaseRef, scopeId));
            }
            if (baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "variableMappingClass") != null) {
                processVariables.putAll(javaReaderStatic.getVariablesFromJavaDelegate(fileScanner, baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "variableMappingClass"), element, null, KnownElementFieldType.Class, scopeId, controlFlowGraph));
            } else if (baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "variableMappingDelegateExpression") != null) {
                processVariables.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, callActivity.getCamundaVariableMappingDelegateExpression(), element, null, KnownElementFieldType.Class, scopeId));
            }
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> searchVariablesInMultiInstanceTask(JavaReaderStatic javaReaderStatic, FileScanner fileScanner, BpmnElement element, ControlFlowGraph controlFlowGraph) {
        ModelElementInstance loopCharacteristics;
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        ArrayListMultimap processVariablesExpression = ArrayListMultimap.create();
        BaseElement baseElement = element.getBaseElement();
        BpmnModelElementInstance scopeElement = baseElement.getScope();
        String scopeId = null;
        if (scopeElement != null) {
            scopeId = element.getId();
        }
        if ((loopCharacteristics = baseElement.getUniqueChildElementByType(LoopCharacteristics.class)) != null) {
            String inputDataItemName;
            ModelElementInstance inputDataItem;
            String dataInputRefName;
            ModelElementInstance loopDataInputRef;
            String completionConditionExpression;
            ModelElementInstance completionCondition;
            String cardinality;
            ModelElementInstance loopCardinality;
            String elementVariable;
            ExpressionNode node = new ExpressionNode(element.getControlFlowGraph(), element.getParentElement(), "", ElementChapter.MultiInstance);
            element.getControlFlowGraph().addNode(node);
            processVariables.putAll(this.addDefaultMultiInstanceTaskVariables(element));
            String collectionName = loopCharacteristics.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "collection");
            if (collectionName != null && collectionName.trim().length() > 0) {
                Pattern pattern = Pattern.compile("\\$\\{.*\\}");
                Matcher matcher = pattern.matcher(collectionName);
                if (matcher.matches()) {
                    processVariablesExpression.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, collectionName, element, ElementChapter.MultiInstance, KnownElementFieldType.CollectionElement, scopeId));
                } else {
                    processVariables.put((Object)collectionName, (Object)new ProcessVariableOperation(collectionName, element, ElementChapter.MultiInstance, KnownElementFieldType.CollectionElement, null, VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter()));
                }
            }
            if ((elementVariable = loopCharacteristics.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "elementVariable")) != null && elementVariable.trim().length() > 0) {
                processVariables.put((Object)elementVariable, (Object)new ProcessVariableOperation(elementVariable, element, ElementChapter.MultiInstance, KnownElementFieldType.ElementVariable, null, VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
            if ((loopCardinality = loopCharacteristics.getUniqueChildElementByType(LoopCardinality.class)) != null && (cardinality = loopCardinality.getTextContent()) != null && cardinality.trim().length() > 0 && !cardinality.matches("\\d+")) {
                processVariablesExpression.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, cardinality, element, ElementChapter.MultiInstance, KnownElementFieldType.LoopCardinality, scopeId));
            }
            if ((completionCondition = loopCharacteristics.getUniqueChildElementByType(CompletionCondition.class)) != null && (completionConditionExpression = completionCondition.getTextContent()) != null && completionConditionExpression.trim().length() > 0) {
                processVariablesExpression.putAll(this.findVariablesInExpression(javaReaderStatic, controlFlowGraph, fileScanner, completionConditionExpression, element, ElementChapter.MultiInstance, KnownElementFieldType.CompletionCondition, scopeId));
            }
            if ((loopDataInputRef = loopCharacteristics.getUniqueChildElementByType(LoopDataInputRef.class)) != null && (dataInputRefName = loopDataInputRef.getTextContent()) != null && dataInputRefName.trim().length() > 0) {
                processVariables.put((Object)dataInputRefName, (Object)new ProcessVariableOperation(dataInputRefName, element, ElementChapter.MultiInstance, KnownElementFieldType.CollectionElement, null, VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
            if ((inputDataItem = loopCharacteristics.getUniqueChildElementByType(InputDataItem.class)) != null && (inputDataItemName = inputDataItem.getAttributeValue("name")) != null && inputDataItemName.trim().length() > 0) {
                processVariables.put((Object)inputDataItemName, (Object)new ProcessVariableOperation(inputDataItemName, element, ElementChapter.MultiInstance, KnownElementFieldType.CollectionElement, null, VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
            for (ProcessVariableOperation operation : processVariables.values()) {
                node.addOperation(operation);
            }
            processVariables.putAll((Multimap)processVariablesExpression);
        }
        return processVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> addDefaultMultiInstanceTaskVariables(BpmnElement element) {
        ArrayListMultimap defaultVariables = ArrayListMultimap.create();
        String scopeElementId = element.getId();
        ProcessVariableOperation operation = new ProcessVariableOperation("nrOfInstances", element, ElementChapter.MultiInstance, KnownElementFieldType.CamundaStandardVariables, null, VariableOperation.WRITE, scopeElementId, element.getFlowAnalysis().getOperationCounter());
        defaultVariables.put((Object)"nrOfInstances", (Object)operation);
        operation = new ProcessVariableOperation("nrOfActiveInstances", element, ElementChapter.MultiInstance, KnownElementFieldType.CamundaStandardVariables, null, VariableOperation.WRITE, scopeElementId, element.getFlowAnalysis().getOperationCounter());
        defaultVariables.put((Object)"nrOfActiveInstances", (Object)operation);
        operation = new ProcessVariableOperation("nrOfCompletedInstances", element, ElementChapter.MultiInstance, KnownElementFieldType.CamundaStandardVariables, null, VariableOperation.WRITE, scopeElementId, element.getFlowAnalysis().getOperationCounter());
        defaultVariables.put((Object)"nrOfCompletedInstances", (Object)operation);
        operation = new ProcessVariableOperation("loopCounter", element, ElementChapter.MultiInstance, KnownElementFieldType.CamundaStandardVariables, null, VariableOperation.WRITE, scopeElementId, element.getFlowAnalysis().getOperationCounter());
        defaultVariables.put((Object)"loopCounter", (Object)operation);
        return defaultVariables;
    }

    private ListMultimap<String, ProcessVariableOperation> getVariablesFromGroovyScript(String groovyFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        return ResourceFileReader.readResourceFile(groovyFile, element, chapter, fieldType, scopeId);
    }

    private ListMultimap<String, ProcessVariableOperation> readDmnFile(String decisionId, String fileName, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        InputStream resource;
        ArrayListMultimap variables = ArrayListMultimap.create();
        if (fileName != null && fileName.trim().length() > 0 && (resource = RuntimeConfig.getInstance().getClassLoader().getResourceAsStream(fileName)) != null) {
            DmnModelInstance modelInstance = Dmn.readModelFromStream((InputStream)resource);
            Decision decision = (Decision)modelInstance.getModelElementById(decisionId);
            Collection inputExpressions = decision.getModelInstance().getModelElementsByType(InputExpression.class);
            for (InputExpression inputExpression : inputExpressions) {
                Text variable = inputExpression.getText();
                variables.put((Object)variable.getTextContent(), (Object)new ProcessVariableOperation(variable.getTextContent(), element, chapter, fieldType, fileName, VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
            Collection outputs = decision.getModelInstance().getModelElementsByType(Output.class);
            for (Output output : outputs) {
                String variable = output.getName();
                variables.put((Object)variable, (Object)new ProcessVariableOperation(variable, element, chapter, fieldType, fileName, VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
        }
        return variables;
    }

    private ListMultimap<String, ProcessVariableOperation> findVariablesInExpression(JavaReaderStatic javaReaderStatic, ControlFlowGraph controlFlowGraph, FileScanner fileScanner, String expression, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        ArrayListMultimap variables = ArrayListMultimap.create();
        Pattern pattern = Pattern.compile("\\$\\{(\\w)*\\(.*\\)\\}");
        Matcher matcher = pattern.matcher(expression);
        if (matcher.matches()) {
            return variables;
        }
        boolean isDelegated = false;
        ExpressionNode expNode = new ExpressionNode(controlFlowGraph, element, expression, chapter);
        try {
            String filteredExpression = expression.replaceAll("[\\w]+\\.", "");
            Builder treeBuilder = new Builder();
            Tree tree = treeBuilder.build(filteredExpression);
            Iterable identifierNodes = tree.getIdentifierNodes();
            for (IdentifierNode node : identifierNodes) {
                String className = this.isBean(node.getName());
                if (className != null) {
                    variables.putAll(javaReaderStatic.getVariablesFromJavaDelegate(fileScanner, className, element, chapter, fieldType, scopeId, controlFlowGraph));
                    isDelegated = true;
                    continue;
                }
                ProcessVariableOperation operation = new ProcessVariableOperation(node.getName(), element, chapter, fieldType, element.getProcessDefinition(), VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter());
                variables.put((Object)node.getName(), (Object)operation);
                expNode.getUsed().put(node.getName(), operation);
                expNode.getOperations().put(node.getName(), operation);
            }
            ListMultimap<String, ProcessVariableOperation> writeOperations = ResourceFileReader.searchWrittenProcessVariablesInCode(element, chapter, fieldType, element.getProcessDefinition(), scopeId, expression);
            variables.putAll(writeOperations);
            writeOperations.asMap().forEach((key, value) -> value.forEach(op -> {
                expNode.getOperations().put(op.getId(), (ProcessVariableOperation)op);
                expNode.getDefined().put(op.getId(), (ProcessVariableOperation)op);
            }));
            ListMultimap<String, ProcessVariableOperation> deleteOperations = ResourceFileReader.searchRemovedProcessVariablesInCode(element, chapter, fieldType, element.getProcessDefinition(), scopeId, expression);
            variables.putAll(deleteOperations);
            deleteOperations.asMap().forEach((key, value) -> value.forEach(op -> {
                expNode.getOperations().put(op.getId(), (ProcessVariableOperation)op);
                expNode.getKilled().put(op.getId(), (ProcessVariableOperation)op);
            }));
        }
        catch (ELException e) {
            throw new ProcessingException("EL expression " + expression + " in " + element.getProcessDefinition() + ", element ID: " + element.getBaseElement().getId() + ", Type: " + fieldType.getDescription() + " couldn't be parsed", e);
        }
        if (!(fieldType.equals((Object)KnownElementFieldType.CalledElement) || fieldType.equals((Object)KnownElementFieldType.CamundaOut) || fieldType.equals((Object)KnownElementFieldType.CamundaIn) || isDelegated)) {
            controlFlowGraph.addNode(expNode);
        }
        return variables;
    }

    private ListMultimap<String, ProcessVariableOperation> checkMessageAndSignalForExpression(JavaReaderStatic javaReaderStatic, String expression, BpmnElement element, FileScanner fileScanner, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap variables = ArrayListMultimap.create();
        try {
            Pattern pattern = Pattern.compile(".*\\$\\{(.*?)}");
            Matcher matcher = pattern.matcher(expression);
            if (matcher.matches()) {
                if (this.isBean(matcher.group(1)) != null) {
                    variables.putAll(javaReaderStatic.getVariablesFromJavaDelegate(fileScanner, this.isBean(matcher.group(1)), element, chapter, fieldType, scopeId, controlFlowGraph));
                } else {
                    variables.put((Object)expression, (Object)new ProcessVariableOperation(expression, element, chapter, fieldType, element.getProcessDefinition(), VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter()));
                }
            }
        }
        catch (ELException e) {
            throw new ProcessingException("EL expression " + expression + " in " + element.getProcessDefinition() + ", element ID: " + element.getBaseElement().getId() + ", Type: " + (Object)((Object)KnownElementFieldType.Expression) + " couldn't be parsed", e);
        }
        return variables;
    }

    private ListMultimap<String, ProcessVariableOperation> checkExpressionForReadVariable(JavaReaderStatic javaReaderStatic, String expression, String name, BpmnElement element, FileScanner fileScanner, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap variables = ArrayListMultimap.create();
        try {
            Pattern pattern = Pattern.compile(".*\\$\\{(.*?)}");
            Matcher matcher = pattern.matcher(expression);
            if (matcher.matches()) {
                if (this.isBean(matcher.group(1)) != null) {
                    variables.putAll(javaReaderStatic.getVariablesFromJavaDelegate(fileScanner, this.isBean(matcher.group(1)), element, chapter, fieldType, scopeId, controlFlowGraph));
                } else {
                    variables.put((Object)name, (Object)new ProcessVariableOperation(name, element, chapter, fieldType, element.getProcessDefinition(), VariableOperation.READ, scopeId, element.getFlowAnalysis().getOperationCounter()));
                }
            } else {
                variables.put((Object)name, (Object)new ProcessVariableOperation(name, element, chapter, fieldType, element.getProcessDefinition(), VariableOperation.WRITE, scopeId, element.getFlowAnalysis().getOperationCounter()));
            }
        }
        catch (ELException e) {
            throw new ProcessingException("EL expression " + expression + " in " + element.getProcessDefinition() + ", element ID: " + element.getBaseElement().getId() + ", Type: " + (Object)((Object)KnownElementFieldType.Expression) + " couldn't be parsed", e);
        }
        return variables;
    }

    private String isBean(String variable) {
        if (RuntimeConfig.getInstance().getBeanMapping() != null) {
            return RuntimeConfig.getInstance().getBeanMapping().get(variable);
        }
        return null;
    }
}

