/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.processing.EntryPoint;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.VariablesExtractor;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.Node;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.OutSetCFG;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import soot.Body;
import soot.PackManager;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.ClassicCompleteBlockGraph;

class JavaReaderStatic {
    private static final Logger LOGGER = Logger.getLogger(JavaReaderStatic.class.getName());
    private VariablesExtractor variablesExtractor;

    JavaReaderStatic() {
        this.setupSoot();
        this.variablesExtractor = new VariablesExtractor(this);
    }

    ListMultimap<String, ProcessVariableOperation> getVariablesFromJavaDelegate(FileScanner fileScanner, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap variables = ArrayListMultimap.create();
        if (classFile != null && classFile.trim().length() > 0) {
            String sootPath = FileScanner.getSootPath();
            System.setProperty("soot.class.path", sootPath);
            Set<String> classPaths = fileScanner.getJavaResourcesFileInputStream();
            if (element.getBaseElement().getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "variableMappingClass") != null || element.getBaseElement().getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "variableMappingDelegateExpression") != null) {
                variables.putAll(this.classFetcher(classPaths, classFile, "mapInputVariables", classFile, element, ElementChapter.InputImplementation, fieldType, scopeId, controlFlowGraph));
                variables.putAll(this.classFetcher(classPaths, classFile, "mapOutputVariables", classFile, element, ElementChapter.OutputImplementation, fieldType, scopeId, controlFlowGraph));
            } else {
                variables.putAll(this.classFetcher(classPaths, classFile, "execute", classFile, element, chapter, fieldType, scopeId, controlFlowGraph));
                variables.putAll(this.classFetcher(classPaths, classFile, "notify", classFile, element, chapter, fieldType, scopeId, controlFlowGraph));
            }
        }
        return variables;
    }

    ListMultimap<String, ProcessVariableOperation> getVariablesFromClass(String className, BpmnElement element, String resourceFilePath, EntryPoint entryPoint) {
        ArrayListMultimap initialOperations = ArrayListMultimap.create();
        if (className != null && className.trim().length() > 0) {
            className = this.cleanString(className, true);
            SootClass sootClass = Scene.v().forceResolve(className, 2);
            if (sootClass != null) {
                sootClass.setApplicationClass();
                Scene.v().loadNecessaryClasses();
                for (SootMethod method : sootClass.getMethods()) {
                    if (!method.getName().equals(entryPoint.getMethodName())) continue;
                    Body body = method.retrieveActiveBody();
                    initialOperations.putAll(this.variablesExtractor.checkWriteAccess(body, element, resourceFilePath, entryPoint));
                }
            }
        }
        return initialOperations;
    }

    private ListMultimap<String, ProcessVariableOperation> classFetcher(Set<String> classPaths, String className, String methodName, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, ControlFlowGraph controlFlowGraph) {
        ArrayListMultimap processVariables = ArrayListMultimap.create();
        OutSetCFG outSet = new OutSetCFG(new ArrayList<VariableBlock>());
        ArrayList<Value> args = new ArrayList<Value>();
        this.classFetcherRecursive(classPaths, className, methodName, classFile, element, chapter, fieldType, scopeId, outSet, null, "", args, controlFlowGraph, null);
        if (outSet.getAllProcessVariables().size() > 0) {
            processVariables.putAll(outSet.getAllProcessVariables());
        }
        return processVariables;
    }

    void classFetcherRecursive(Set<String> classPaths, String className, String methodName, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, OutSetCFG outSet, VariableBlock originalBlock, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph, SootMethod sootMethod) {
        className = this.cleanString(className, true);
        SootClass sootClass = Scene.v().forceResolve(className, 2);
        if (sootClass != null) {
            sootClass.setApplicationClass();
            Scene.v().loadNecessaryClasses();
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            RefType delegateExecutionType = RefType.v((String)"org.camunda.bpm.engine.delegate.DelegateExecution");
            RefType activityExecutionType = RefType.v((String)"org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution");
            RefType delegateTaskType = RefType.v((String)"org.camunda.bpm.engine.delegate.DelegateTask");
            RefType mapVariablesType = RefType.v((String)"org.camunda.bpm.engine.variable.VariableMap");
            VoidType returnType = VoidType.v();
            switch (methodName) {
                case "execute": {
                    for (SootClass clazz : sootClass.getInterfaces()) {
                        if (clazz.getName().equals("org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior")) {
                            parameterTypes.add((Type)activityExecutionType);
                            continue;
                        }
                        if (!clazz.getName().equals("org.camunda.bpm.engine.delegate.JavaDelegate")) continue;
                        parameterTypes.add((Type)delegateExecutionType);
                    }
                    break;
                }
                case "notify": {
                    for (SootClass clazz : sootClass.getInterfaces()) {
                        if (clazz.getName().equals("org.camunda.bpm.engine.delegate.TaskListener")) {
                            parameterTypes.add((Type)delegateTaskType);
                            continue;
                        }
                        if (!clazz.getName().equals("org.camunda.bpm.engine.delegate.ExecutionListener")) continue;
                        parameterTypes.add((Type)delegateExecutionType);
                    }
                    break;
                }
                case "mapInputVariables": 
                case "mapOutputVariables": {
                    parameterTypes.add((Type)delegateExecutionType);
                    parameterTypes.add((Type)mapVariablesType);
                    break;
                }
                default: {
                    this.retrieveCustomMethod(sootClass, classPaths, classFile, element, chapter, fieldType, scopeId, outSet, originalBlock, assignmentStmt, args, controlFlowGraph, sootMethod, methodName);
                    return;
                }
            }
            this.retrieveMethod(classPaths, methodName, classFile, element, chapter, fieldType, scopeId, outSet, originalBlock, sootClass, parameterTypes, returnType, assignmentStmt, args, controlFlowGraph);
        } else {
            LOGGER.warning("Class " + classFile + " was not found by Soot");
        }
    }

    private void retrieveMethod(Set<String> classPaths, String methodName, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, OutSetCFG outSet, VariableBlock originalBlock, SootClass sootClass, List<Type> parameterTypes, VoidType returnType, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph) {
        SootMethod method = sootClass.getMethodUnsafe(methodName, parameterTypes, (Type)returnType);
        if (method != null) {
            this.fetchMethodBody(classPaths, classFile, element, chapter, fieldType, scopeId, outSet, originalBlock, method, assignmentStmt, args, controlFlowGraph);
        } else {
            method = sootClass.getMethodByNameUnsafe(methodName);
            if (method != null) {
                this.fetchMethodBody(classPaths, classFile, element, chapter, fieldType, scopeId, outSet, originalBlock, method, assignmentStmt, args, controlFlowGraph);
            } else {
                LOGGER.warning("In class " + classFile + " - " + methodName + " method was not found by Soot");
            }
        }
    }

    private void retrieveCustomMethod(SootClass sootClass, Set<String> classPaths, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, OutSetCFG outSet, VariableBlock originalBlock, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph, SootMethod sootMethod, String methodName) {
        if (sootMethod != null) {
            this.fetchMethodBody(classPaths, classFile, element, chapter, fieldType, scopeId, outSet, originalBlock, sootMethod, assignmentStmt, args, controlFlowGraph);
        } else {
            for (SootMethod method : sootClass.getMethods()) {
                if (method == null || !method.getName().equals(methodName)) continue;
                this.fetchMethodBody(classPaths, classFile, element, chapter, fieldType, scopeId, outSet, originalBlock, method, assignmentStmt, args, controlFlowGraph);
            }
        }
    }

    private void fetchMethodBody(Set<String> classPaths, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, OutSetCFG outSet, VariableBlock originalBlock, SootMethod method, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph) {
        Body body = method.retrieveActiveBody();
        ClassicCompleteBlockGraph graph = new ClassicCompleteBlockGraph(body);
        ArrayList<SootMethod> entryPoints = new ArrayList<SootMethod>();
        entryPoints.add(method);
        Scene.v().setEntryPoints(entryPoints);
        PackManager.v().getPack("cg").apply();
        CallGraph cg = Scene.v().getCallGraph();
        List graphHeads = graph.getHeads();
        for (int i = 0; i < graphHeads.size(); ++i) {
            outSet = this.graphIterator(classPaths, cg, (BlockGraph)graph, outSet, element, chapter, fieldType, classFile, scopeId, originalBlock, assignmentStmt, args, controlFlowGraph);
        }
    }

    private OutSetCFG graphIterator(Set<String> classPaths, CallGraph cg, BlockGraph graph, OutSetCFG outSet, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId, VariableBlock originalBlock, String assignmentStmt, List<Value> args, ControlFlowGraph controlFlowGraph) {
        for (Block block : graph.getBlocks()) {
            Node node = new Node(controlFlowGraph, element, block, chapter);
            controlFlowGraph.addNode(node);
            VariableBlock vb = this.variablesExtractor.blockIterator(classPaths, cg, block, outSet, element, chapter, fieldType, filePath, scopeId, originalBlock, assignmentStmt, args, controlFlowGraph, node);
            if (outSet.getVariableBlock(vb.getBlock()) != null) continue;
            outSet.addVariableBlock(vb);
        }
        return outSet;
    }

    private String cleanString(String className, boolean dot) {
        className = ProcessVariablesScanner.cleanString(className, dot);
        return className;
    }

    private void setupSoot() {
        String sootPath = FileScanner.getSootPath();
        System.setProperty("soot.class.path", sootPath);
        Options.v().set_whole_program(true);
        Options.v().set_allow_phantom_refs(true);
        ArrayList<String> excludedClasses = new ArrayList<String>();
        excludedClasses.add("java.*");
        excludedClasses.add("sun.*");
        excludedClasses.add("jdk.*");
        excludedClasses.add("javax.*");
        Options.v().set_exclude(excludedClasses);
        Options.v().set_no_bodies_for_excluded(true);
        Scene.v().extendSootClassPath(Scene.v().defaultClassPath());
    }
}

