/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.reader.XmlVariablesReader;
import de.viadee.bpm.vPAV.constants.ConfigConstants;
import de.viadee.bpm.vPAV.processing.EntryPoint;
import de.viadee.bpm.vPAV.processing.JavaReaderStatic;
import de.viadee.bpm.vPAV.processing.ProcessVariableReader;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.ExpressionNode;
import de.viadee.bpm.vPAV.processing.code.flow.FlowAnalysis;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Edge;
import de.viadee.bpm.vPAV.processing.model.graph.Graph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BoundaryEvent;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.SubProcess;

public class ElementGraphBuilder {
    private Map<String, BpmnElement> elementMap = new HashMap<String, BpmnElement>();
    private Map<String, String> processIdToPathMap;
    private Map<String, String> decisionRefToPathMap;
    private Map<String, Collection<String>> messageIdToVariables;
    private Map<String, Collection<String>> processIdToVariables;
    private BpmnScanner bpmnScanner;
    private Rule rule;

    public ElementGraphBuilder(BpmnScanner bpmnScanner) {
        this.bpmnScanner = bpmnScanner;
    }

    public ElementGraphBuilder(BpmnScanner bpmnScanner, Rule rule) {
        this.bpmnScanner = bpmnScanner;
        this.rule = rule;
    }

    public ElementGraphBuilder(Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Map<String, Collection<String>> messageIdToVariables, Map<String, Collection<String>> processIdToVariables, Rule rule, BpmnScanner bpmnScanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.processIdToPathMap = processIdToPathMap;
        this.messageIdToVariables = messageIdToVariables;
        this.processIdToVariables = processIdToVariables;
        this.bpmnScanner = bpmnScanner;
        this.rule = rule;
    }

    public ElementGraphBuilder(Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Map<String, Collection<String>> messageIdToVariables, Map<String, Collection<String>> processIdToVariables, BpmnScanner bpmnScanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.processIdToPathMap = processIdToPathMap;
        this.messageIdToVariables = messageIdToVariables;
        this.processIdToVariables = processIdToVariables;
        this.bpmnScanner = bpmnScanner;
    }

    public ElementGraphBuilder(Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, BpmnScanner bpmnScanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.processIdToPathMap = processIdToPathMap;
        this.bpmnScanner = bpmnScanner;
    }

    public Collection<Graph> createProcessGraph(FileScanner fileScanner, BpmnModelInstance modelInstance, String processDefinition, Collection<String> calledElementHierarchy, ProcessVariablesScanner scanner, FlowAnalysis flowAnalysis) {
        ArrayList<Graph> graphCollection = new ArrayList<Graph>();
        Collection processes = modelInstance.getModelElementsByType(Process.class);
        HashMap<Object, Object> userVariables = new HashMap();
        try {
            userVariables = new XmlVariablesReader().read(ConfigConstants.getInstance().getUserVariablesFilePath(), ((Process)processes.iterator().next()).getId());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        for (Process process : processes) {
            Graph graph = new Graph(process.getId());
            Collection elements = process.getFlowElements();
            ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
            ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
            ArrayList<SubProcess> subProcesses = new ArrayList<SubProcess>();
            HashMap<BpmnElement, FlowElement> callActivities = new HashMap<BpmnElement, FlowElement>();
            for (FlowElement flowElement : elements) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph();
                BpmnElement node = new BpmnElement(processDefinition, (BaseElement)flowElement, controlFlowGraph, flowAnalysis);
                if (flowElement instanceof SequenceFlow) {
                    SequenceFlow flow = (SequenceFlow)flowElement;
                    flows.add(flow);
                } else if (flowElement instanceof BoundaryEvent) {
                    BoundaryEvent event = (BoundaryEvent)flowElement;
                    boundaryEvents.add(event);
                } else if (flowElement instanceof CallActivity) {
                    callActivities.put(node, flowElement);
                } else if (flowElement instanceof SubProcess) {
                    SubProcess subprocess = (SubProcess)flowElement;
                    this.addElementsSubprocess(fileScanner, subProcesses, flows, boundaryEvents, graph, subprocess, processDefinition, controlFlowGraph, flowAnalysis);
                } else if (flowElement instanceof StartEvent && userVariables.containsKey("StartEvent")) {
                    if (!userVariables.containsKey(flowElement.getId())) {
                        userVariables.put(flowElement.getId(), ArrayListMultimap.create());
                    }
                    ((ListMultimap)userVariables.get(flowElement.getId())).putAll((Multimap)userVariables.get("StartEvent"));
                }
                this.createVariablesOfFlowElement(scanner, graph, node, fileScanner, (ListMultimap<String, ProcessVariableOperation>)((ListMultimap)userVariables.get(flowElement.getId())));
                this.elementMap.put(flowElement.getId(), node);
                if (flowElement.getElementType().getTypeName().equals("endEvent")) {
                    graph.addEndNode(node);
                }
                graph.addVertex(node);
            }
            this.addEdges(graph, flows, boundaryEvents, subProcesses);
            for (Map.Entry entry : callActivities.entrySet()) {
                this.integrateCallActivityFlow(fileScanner, processDefinition, (BpmnElement)entry.getKey(), (FlowElement)entry.getValue(), graph, calledElementHierarchy, scanner, flowAnalysis);
            }
            graphCollection.add(graph);
        }
        return graphCollection;
    }

    private void createVariablesOfFlowElement(ProcessVariablesScanner scanner, Graph graph, BpmnElement node, FileScanner fileScanner, ListMultimap<String, ProcessVariableOperation> userVariables) {
        String messageName;
        ArrayList<String> messageRefs;
        FlowElement element = (FlowElement)node.getBaseElement();
        ArrayListMultimap variables = ArrayListMultimap.create();
        if (userVariables != null) {
            ExpressionNode userVarNode = new ExpressionNode(node.getControlFlowGraph(), node.getParentElement(), "", ElementChapter.UserDefined);
            node.getControlFlowGraph().addNode(userVarNode);
            for (Map.Entry var : userVariables.entries()) {
                ((ProcessVariableOperation)var.getValue()).initializeOperation(node);
                userVarNode.addOperation((ProcessVariableOperation)var.getValue());
            }
        }
        if (element.getElementType().getTypeName().equals("startEvent")) {
            messageRefs = this.bpmnScanner.getMessageRefs(element.getId());
            messageName = "";
            if (messageRefs.size() == 1) {
                messageName = this.bpmnScanner.getMessageName(messageRefs.get(0));
            }
            for (EntryPoint ep : scanner.getEntryPoints()) {
                if (!ep.getMessageName().equals(messageName)) continue;
                variables.putAll(this.checkInitialVariableOperations(ep, node, node.getProcessDefinition()));
            }
            graph.addStartNode(node);
        }
        if (element.getElementType().getTypeName().equals("receiveTask")) {
            messageRefs = this.bpmnScanner.getMessageRefs(element.getId());
            messageName = "";
            if (messageRefs.size() == 1) {
                messageName = this.bpmnScanner.getMessageName(messageRefs.get(0));
            }
            for (EntryPoint ep : scanner.getIntermediateEntryPoints()) {
                if (!ep.getMessageName().equals(messageName)) continue;
                variables.putAll(this.checkInitialVariableOperations(ep, node, node.getProcessDefinition()));
            }
        }
        ProcessVariableReader reader = new ProcessVariableReader(this.decisionRefToPathMap, this.rule, this.bpmnScanner);
        variables.putAll(reader.getVariablesFromElement(fileScanner, node, node.getControlFlowGraph()));
        node.setProcessVariables((ListMultimap<String, ProcessVariableOperation>)variables);
    }

    private ListMultimap<String, ProcessVariableOperation> checkInitialVariableOperations(EntryPoint entryPoint, BpmnElement element, String resourceFilePath) {
        return new JavaReaderStatic().getVariablesFromClass(entryPoint.getClassName(), element, resourceFilePath, entryPoint);
    }

    public BpmnElement getElement(String id) {
        return this.elementMap.get(id);
    }

    public Map<AnomalyContainer, List<Path>> createInvalidPaths(Collection<Graph> graphCollection) {
        HashMap<AnomalyContainer, List<Path>> invalidPathMap = new HashMap<AnomalyContainer, List<Path>>();
        for (Graph g : graphCollection) {
            Map<BpmnElement, List<AnomalyContainer>> anomalies = g.getNodesWithAnomalies();
            for (Map.Entry<BpmnElement, List<AnomalyContainer>> element : anomalies.entrySet()) {
                for (AnomalyContainer anomaly : element.getValue()) {
                    List<Path> paths = g.getAllInvalidPaths(element.getKey(), anomaly);
                    for (Path path : paths) {
                        Collections.reverse(path.getElements());
                    }
                    invalidPathMap.put(anomaly, new ArrayList<Path>(paths));
                }
            }
        }
        return invalidPathMap;
    }

    private void addEdges(Graph graph, Collection<SequenceFlow> flows, Collection<BoundaryEvent> boundaryEvents, Collection<SubProcess> subProcesses) {
        for (SequenceFlow flow : flows) {
            BpmnElement flowElement = this.elementMap.get(flow.getId());
            BpmnElement srcElement = this.elementMap.get(flow.getSource().getId());
            BpmnElement destElement = this.elementMap.get(flow.getTarget().getId());
            flowElement.addPredecessor(srcElement);
            flowElement.addSuccessor(destElement);
            graph.addEdge(srcElement, flowElement, 100);
            graph.addEdge(flowElement, destElement, 100);
        }
        for (BoundaryEvent event : boundaryEvents) {
            BpmnElement dstElement = this.elementMap.get(event.getId());
            Activity source = event.getAttachedTo();
            BpmnElement srcElement = this.elementMap.get(source.getId());
            graph.addEdge(srcElement, dstElement, 100);
        }
        for (SubProcess subProcess : subProcesses) {
            this.addEdgesOfSubprocess(graph, subProcess);
        }
    }

    private void addEdgesOfSubprocess(Graph graph, SubProcess subProcess) {
        BpmnElement subprocessElement = this.elementMap.get(subProcess.getId());
        Collection startEvents = subProcess.getChildElementsByType(StartEvent.class);
        Collection endEvents = subProcess.getChildElementsByType(EndEvent.class);
        if (startEvents != null && !startEvents.isEmpty() && endEvents != null && !endEvents.isEmpty()) {
            Collection incomingFlows = subProcess.getIncoming();
            for (SequenceFlow incomingFlow : incomingFlows) {
                BpmnElement srcElement = this.elementMap.get(incomingFlow.getId());
                for (StartEvent startEvent : startEvents) {
                    BpmnElement dstElement = this.elementMap.get(startEvent.getId());
                    graph.addEdge(srcElement, dstElement, 100);
                    graph.removeEdge(srcElement, subprocessElement);
                }
            }
            Collection outgoingFlows = subProcess.getOutgoing();
            for (EndEvent endEvent : endEvents) {
                BpmnElement srcElement = this.elementMap.get(endEvent.getId());
                for (SequenceFlow outgoingFlow : outgoingFlows) {
                    BpmnElement dstElement = this.elementMap.get(outgoingFlow.getId());
                    graph.addEdge(srcElement, dstElement, 100);
                    graph.removeEdge(subprocessElement, dstElement);
                }
            }
        }
    }

    private void addElementsSubprocess(FileScanner fileScanner, Collection<SubProcess> subProcesses, Collection<SequenceFlow> flows, Collection<BoundaryEvent> events, Graph graph, SubProcess process, String processDefinition, ControlFlowGraph controlFlowGraph, FlowAnalysis flowAnalysis) {
        subProcesses.add(process);
        Collection subElements = process.getFlowElements();
        for (FlowElement subElement : subElements) {
            if (subElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)subElement;
                this.addElementsSubprocess(fileScanner, subProcesses, flows, events, graph, subProcess, processDefinition, controlFlowGraph, flowAnalysis);
            } else if (subElement instanceof SequenceFlow) {
                SequenceFlow flow = (SequenceFlow)subElement;
                flows.add(flow);
            } else if (subElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)subElement;
                events.add(boundaryEvent);
            }
            BpmnElement node = new BpmnElement(processDefinition, (BaseElement)subElement, controlFlowGraph, flowAnalysis);
            ArrayListMultimap variables = ArrayListMultimap.create();
            variables.putAll(new ProcessVariableReader(this.decisionRefToPathMap, this.rule, this.bpmnScanner).getVariablesFromElement(fileScanner, node, controlFlowGraph));
            node.setProcessVariables((ListMultimap<String, ProcessVariableOperation>)variables);
            this.elementMap.put(subElement.getId(), node);
            graph.addVertex(node);
        }
    }

    private void integrateCallActivityFlow(FileScanner fileScanner, String processDefinition, BpmnElement element, FlowElement activity, Graph graph, Collection<String> calledElementHierarchy, ProcessVariablesScanner scanner, FlowAnalysis flowAnalysis) {
        String callActivityPath;
        CallActivity callActivity = (CallActivity)activity;
        String calledElement = callActivity.getCalledElement();
        if (calledElementHierarchy.contains(calledElement)) {
            throw new RuntimeException("call activity hierarchy causes a deadlock (see " + processDefinition + ", " + callActivity.getId() + "). please avoid loops.");
        }
        calledElementHierarchy.add(calledElement);
        if (this.processIdToPathMap != null && this.processIdToPathMap.get(calledElement) != null && (callActivityPath = this.processIdToPathMap.get(calledElement)) != null) {
            Collection<Graph> subGraphs = this.createSubDataFlowsFromCallActivity(fileScanner, calledElementHierarchy, callActivityPath, scanner, flowAnalysis);
            for (Graph subGraph : subGraphs) {
                if (!subGraph.getProcessId().equals(calledElement)) continue;
                this.connectGraphs(graph, subGraph, element);
            }
        }
    }

    private void connectGraphs(Graph graph, Graph subGraph, BpmnElement callActivity) {
        Collection<BpmnElement> vertices = subGraph.getVertices();
        for (BpmnElement bpmnElement : vertices) {
            BaseElement baseElement = bpmnElement.getBaseElement();
            baseElement.setId("_" + baseElement.getId());
            graph.addVertex(bpmnElement);
        }
        Collection<List<Edge>> subGraphEdges = subGraph.getEdges();
        for (List<Edge> list : subGraphEdges) {
            for (Edge edge : list) {
                BpmnElement from = edge.getFrom();
                BpmnElement to = edge.getTo();
                graph.addEdge(from, to, 100);
            }
        }
        Collection<BpmnElement> collection = subGraph.getStartNodes();
        for (BpmnElement startNode : collection) {
            graph.addEdge(callActivity, startNode, 100);
        }
        Collection<BpmnElement> collection2 = subGraph.getEndNodes();
        for (BpmnElement endNode : collection2) {
            for (BpmnElement succ : graph.getAdjacencyListSuccessor(callActivity)) {
                graph.addEdge(endNode, succ, 100);
            }
        }
    }

    private Collection<Graph> createSubDataFlowsFromCallActivity(FileScanner fileScanner, Collection<String> calledElementHierarchy, String callActivityPath, ProcessVariablesScanner scanner, FlowAnalysis flowAnalysis) {
        BpmnModelInstance subModel = Bpmn.readModelFromFile((File)new File(ConfigConstants.getInstance().getBasepath() + callActivityPath));
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(this.decisionRefToPathMap, this.processIdToPathMap, this.messageIdToVariables, this.processIdToVariables, this.rule, this.bpmnScanner);
        return graphBuilder.createProcessGraph(fileScanner, subModel, callActivityPath, calledElementHierarchy, scanner, flowAnalysis);
    }
}

