/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import com.google.common.collect.ArrayListMultimap;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.checker.CheckerFactory;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ModelChecker;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.code.flow.FlowAnalysis;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.ModelDispatchResult;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Graph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class BpmnModelDispatcher {
    private Map<String, String> incorrectCheckers = new HashMap<String, String>();

    public ModelDispatchResult dispatchWithVariables(FileScanner fileScanner, File processDefinition, ProcessVariablesScanner scanner, Collection<DataFlowRule> dataFlowRules, RuleSet conf) {
        Map<String, String> decisionRefToPathMap = fileScanner.getDecisionRefToPathMap();
        Map<String, String> processIdToPathMap = fileScanner.getProcessIdToPathMap();
        Collection<String> resourcesNewestVersions = fileScanner.getResourcesNewestVersions();
        FlowAnalysis flowAnalysis = new FlowAnalysis();
        BpmnScanner bpmnScanner = this.createScanner(processDefinition);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processDefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        Rule rule = conf.getModelRules().get("ProcessVariablesModelChecker").get("ProcessVariablesModelChecker");
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, scanner.getMessageIdToVariableMap(), scanner.getProcessIdToVariableMap(), rule, bpmnScanner);
        Collection<Graph> graphCollection = graphBuilder.createProcessGraph(fileScanner, modelInstance, processDefinition.getPath(), new ArrayList<String>(), scanner, flowAnalysis);
        flowAnalysis.analyze(graphCollection);
        Map<AnomalyContainer, List<Path>> invalidPathMap = graphBuilder.createInvalidPaths(graphCollection);
        Collection<BpmnElement> bpmnElements = BpmnModelDispatcher.getBpmnElements(processDefinition, baseElements, graphBuilder, flowAnalysis);
        Collection<ProcessVariable> processVariables = BpmnModelDispatcher.getProcessVariables(bpmnElements);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Collection[] checkers = this.createCheckerInstances(resourcesNewestVersions, conf, bpmnScanner, scanner, dataFlowRules, processVariables, invalidPathMap);
        for (ModelChecker checker : checkers[1]) {
            issues.addAll(checker.check());
        }
        this.executeCheckers(processDefinition, baseElements, graphBuilder, issues, checkers[0], flowAnalysis);
        return new ModelDispatchResult(issues, bpmnElements, processVariables);
    }

    public ModelDispatchResult dispatchWithoutVariables(File processDefinition, Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Collection<String> resourcesNewestVersions, RuleSet conf) {
        FlowAnalysis flowAnalysis = new FlowAnalysis();
        BpmnScanner bpmnScanner = this.createScanner(processDefinition);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processDefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, bpmnScanner);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Collection[] checkers = this.createCheckerInstances(resourcesNewestVersions, conf, bpmnScanner, null, null, null, null);
        this.executeCheckers(processDefinition, baseElements, graphBuilder, issues, checkers[0], flowAnalysis);
        return new ModelDispatchResult(issues, BpmnModelDispatcher.getBpmnElements(processDefinition, baseElements, graphBuilder, flowAnalysis), Collections.emptyList());
    }

    public static Collection<BpmnElement> getBpmnElements(File processDefinition, Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder, FlowAnalysis flowAnalysis) {
        ArrayList<BpmnElement> elements = new ArrayList<BpmnElement>();
        for (BaseElement baseElement : baseElements) {
            BpmnElement element = graphBuilder.getElement(baseElement.getId());
            if (element == null) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph();
                element = new BpmnElement(processDefinition.getPath(), baseElement, controlFlowGraph, flowAnalysis);
            }
            elements.add(element);
        }
        return elements;
    }

    public static Collection<ProcessVariable> getProcessVariables(Collection<BpmnElement> elements) {
        ArrayListMultimap variables = ArrayListMultimap.create();
        for (BpmnElement element : elements) {
            for (ProcessVariableOperation variableOperation : element.getProcessVariables().values()) {
                String variableName = variableOperation.getName();
                if (!variables.containsKey((Object)variableName)) {
                    variables.put((Object)variableName, (Object)new ProcessVariable(variableName));
                }
                Collection processVariables = (Collection)variables.asMap().get(variableName);
                for (ProcessVariable pv : processVariables) {
                    switch (variableOperation.getOperation()) {
                        case READ: {
                            pv.addRead(variableOperation);
                            break;
                        }
                        case WRITE: {
                            pv.addWrite(variableOperation);
                            break;
                        }
                        case DELETE: {
                            pv.addDelete(variableOperation);
                        }
                    }
                }
            }
        }
        return variables.values();
    }

    private void executeCheckers(File processDefinition, Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder, Collection<CheckerIssue> issues, Collection<ElementChecker> checkerInstances, FlowAnalysis flowAnalysis) {
        for (BaseElement baseElement : baseElements) {
            BpmnElement element = graphBuilder.getElement(baseElement.getId());
            if (element == null) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph();
                element = new BpmnElement(processDefinition.getPath(), baseElement, controlFlowGraph, flowAnalysis);
            }
            for (ElementChecker checker : checkerInstances) {
                issues.addAll(checker.check(element));
            }
        }
    }

    private BpmnScanner createScanner(File processDefinition) {
        return new BpmnScanner(processDefinition.getPath());
    }

    Collection[] createCheckerInstances(Collection<String> resourcesNewestVersions, RuleSet conf, BpmnScanner bpmnScanner, ProcessVariablesScanner scanner, Collection<DataFlowRule> dataFlowRules, Collection<ProcessVariable> processVariables, Map<AnomalyContainer, List<Path>> invalidPathMap) {
        CheckerFactory checkerFactory = new CheckerFactory();
        Collection[] checkerCollection = checkerFactory.createCheckerInstances(conf, resourcesNewestVersions, bpmnScanner, scanner, dataFlowRules, processVariables, invalidPathMap);
        this.setIncorrectCheckers(checkerFactory.getIncorrectCheckers());
        return checkerCollection;
    }

    public Map<String, String> getIncorrectCheckers() {
        return this.incorrectCheckers;
    }

    private void setIncorrectCheckers(Map<String, String> incorrectCheckers) {
        this.incorrectCheckers = incorrectCheckers;
    }
}

