/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.output;

import de.viadee.bpm.vPAV.output.IssueOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.output.XmlCheckerIssue;
import de.viadee.bpm.vPAV.output.XmlCheckerIssues;
import de.viadee.bpm.vPAV.output.XmlPath;
import de.viadee.bpm.vPAV.output.XmlPathElement;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class XmlOutputWriter
implements IssueOutputWriter {
    @Override
    public void write(Collection<CheckerIssue> issues) throws OutputWriterException {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/bpmn_validation.xml"), "utf-8"));
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XmlCheckerIssues.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)XmlOutputWriter.transformToXmlDatastructure(issues), writer);
        }
        catch (UnsupportedEncodingException e) {
            throw new OutputWriterException("unsupported encoding");
        }
        catch (FileNotFoundException e) {
            throw new OutputWriterException("output file couldn't be generated");
        }
        catch (JAXBException e) {
            throw new OutputWriterException("xml output couldn't be generated (jaxb-error)");
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private static XmlCheckerIssues transformToXmlDatastructure(Collection<CheckerIssue> issues) {
        XmlCheckerIssues xmlIssues = new XmlCheckerIssues();
        for (CheckerIssue issue : issues) {
            ArrayList<XmlPath> xmlPaths = new ArrayList<XmlPath>();
            List<Path> invalidPaths = issue.getInvalidPaths();
            if (invalidPaths != null) {
                for (Path path : invalidPaths) {
                    List<BpmnElement> elements = path.getElements();
                    ArrayList<XmlPathElement> pathElements = new ArrayList<XmlPathElement>();
                    for (BpmnElement element : elements) {
                        String elementName = element.getBaseElement().getAttributeValue("name");
                        if (elementName != null) {
                            elementName = elementName.replace("\n", "");
                        }
                        pathElements.add(new XmlPathElement(element.getBaseElement().getId(), elementName));
                    }
                    xmlPaths.add(new XmlPath(pathElements));
                }
            }
            String elementName = issue.getElementName();
            xmlIssues.addIssue(new XmlCheckerIssue(issue.getId(), issue.getRuleName(), issue.getRuleDescription(), issue.getClassification().name(), issue.getBpmnFile(), issue.getResourceFile(), issue.getElementId(), elementName == null ? null : elementName.replace("\n", ""), issue.getMessage(), issue.getElementDescription(), issue.getVariable(), issue.getAnomaly() == null ? null : issue.getAnomaly().getDescription(), xmlPaths.isEmpty() ? null : xmlPaths));
        }
        return xmlIssues;
    }
}

