/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.output;

import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.ElementFieldTypes;
import de.viadee.bpm.vPAV.config.model.ModelConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.config.reader.XmlElementConvention;
import de.viadee.bpm.vPAV.config.reader.XmlElementFieldTypes;
import de.viadee.bpm.vPAV.config.reader.XmlModelConvention;
import de.viadee.bpm.vPAV.config.reader.XmlRule;
import de.viadee.bpm.vPAV.config.reader.XmlRuleSet;
import de.viadee.bpm.vPAV.config.reader.XmlSetting;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class RuleSetOutputWriter {
    public void write(RuleSet rules) throws OutputWriterException {
        Writer writer = null;
        Path path = Paths.get("target/vPAV/effectiveRuleSet.xml", new String[0]);
        if (path.toFile().exists()) {
            path.toFile().delete();
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/effectiveRuleSet.xml"), "utf-8"));
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XmlRuleSet.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)RuleSetOutputWriter.transformToXmlDatastructure(rules), writer);
        }
        catch (UnsupportedEncodingException e) {
            throw new OutputWriterException("unsupported encoding");
        }
        catch (FileNotFoundException e) {
            throw new OutputWriterException("Effective config file couldn't be generated");
        }
        catch (JAXBException e) {
            throw new OutputWriterException("xml output (effective config file) couldn't be generated (jaxb-error)");
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private static XmlRuleSet transformToXmlDatastructure(RuleSet rules) {
        XmlRuleSet xmlRuleSet = new XmlRuleSet();
        Collection<XmlRule> allRules = RuleSetOutputWriter.transformRuleMapToXml(rules.getAllRules());
        xmlRuleSet.setRules(allRules);
        return xmlRuleSet;
    }

    private static Collection<XmlRule> transformRuleMapToXml(Map<String, Map<String, Rule>> ruleMap) {
        ArrayList<XmlRule> xmlRuleCollection = new ArrayList<XmlRule>();
        for (Map.Entry<String, Map<String, Rule>> entry : ruleMap.entrySet()) {
            for (Map.Entry<String, Rule> ruleEntry : entry.getValue().entrySet()) {
                Object elCon2;
                Rule rule = ruleEntry.getValue();
                ArrayList<XmlModelConvention> xModelConventions = new ArrayList<XmlModelConvention>();
                for (ModelConvention modelConvention : rule.getModelConventions()) {
                    XmlModelConvention xmlMoCon = new XmlModelConvention(modelConvention.getType());
                    xModelConventions.add(xmlMoCon);
                }
                ArrayList<XmlElementConvention> xElementConventions = new ArrayList<XmlElementConvention>();
                for (Object elCon2 : rule.getElementConventions()) {
                    ElementFieldTypes elementFieldTypes = ((ElementConvention)elCon2).getElementFieldTypes();
                    if (elementFieldTypes != null) {
                        Collection<String> cElFieTy = elementFieldTypes.getElementFieldTypes();
                        XmlElementFieldTypes xmlElFieTy = new XmlElementFieldTypes(cElFieTy, ((ElementConvention)elCon2).getElementFieldTypes().isExcluded());
                        XmlElementConvention xmlElCon = new XmlElementConvention(((ElementConvention)elCon2).getName(), xmlElFieTy, ((ElementConvention)elCon2).getDescription(), ((ElementConvention)elCon2).getPattern());
                        xElementConventions.add(xmlElCon);
                        continue;
                    }
                    XmlElementConvention xmlElCon = new XmlElementConvention(((ElementConvention)elCon2).getName(), null, ((ElementConvention)elCon2).getDescription(), ((ElementConvention)elCon2).getPattern());
                    xElementConventions.add(xmlElCon);
                }
                ArrayList<XmlSetting> arrayList = new ArrayList<XmlSetting>();
                elCon2 = rule.getSettings().entrySet().iterator();
                while (elCon2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)elCon2.next();
                    Setting s = (Setting)entry2.getValue();
                    if (!((Setting)entry2.getValue()).getScriptPlaces().isEmpty()) {
                        for (String place : ((Setting)entry2.getValue()).getScriptPlaces()) {
                            XmlSetting xmlSetting = new XmlSetting(s.getName(), place, s.getType(), s.getId(), s.getRequired(), s.getValue());
                            arrayList.add(xmlSetting);
                        }
                        continue;
                    }
                    XmlSetting xmlSetting = new XmlSetting(s.getName(), null, s.getType(), s.getId(), s.getRequired(), s.getValue());
                    arrayList.add(xmlSetting);
                }
                XmlRule xRule = new XmlRule(rule.getId(), rule.getName(), rule.isActive(), rule.getRuleDescription(), arrayList.isEmpty() ? null : arrayList, xElementConventions.isEmpty() ? null : xElementConventions, xModelConventions.isEmpty() ? null : xModelConventions);
                xmlRuleCollection.add(xRule);
            }
        }
        return xmlRuleCollection;
    }
}

