/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.output;

import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.w3c.dom.Element;

public class IssueWriter {
    public static Collection<CheckerIssue> createIssue(Rule rule, CriticalityEnum classification, BpmnElement element, String message) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        issues.add(new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message));
        return issues;
    }

    public static Collection<CheckerIssue> createIssue(Rule rule, String ruleDescription, CriticalityEnum classification, ProcessVariable variable, String message) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BpmnElement element = variable.getOperations().get(0).getElement();
        issues.add(new CheckerIssue(rule.getName(), ruleDescription, classification, element.getProcessDefinition(), null, null, message));
        return issues;
    }

    public static Collection<CheckerIssue> createIssue(Rule rule, CriticalityEnum classification, BpmnElement element, String message, String description) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        issues.add(new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message, description));
        return issues;
    }

    public static Collection<CheckerIssue> createIssue(Rule rule, CriticalityEnum classification, ProcessVariableOperation var, List<Path> paths, AnomalyContainer anomaly, String message) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        issues.add(new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, var.getElement().getProcessDefinition(), var.getResourceFilePath(), anomaly.getElementId(), anomaly.getElementName(), var.getName(), anomaly.getAnomaly(), paths, message));
        return issues;
    }

    public static Collection<CheckerIssue> createIssue(Rule rule, CriticalityEnum classification, String resourceFile, BpmnElement element, String message) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        issues.add(new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), resourceFile, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message, null));
        return issues;
    }

    public static CheckerIssue createIssue(Rule rule, CriticalityEnum classification, BpmnElement element, Map.Entry<Element, Element> entry, String message) {
        BaseElement baseElement = element.getBaseElement();
        return new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), entry.getKey().getAttribute("id"), baseElement.getAttributeValue("name"), message);
    }

    public static CheckerIssue createSingleIssue(Rule rule, CriticalityEnum classification, BpmnElement element, String bpmnFile, String message) {
        BaseElement baseElement = element.getBaseElement();
        return new CheckerIssue(rule.getName(), classification, bpmnFile, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message);
    }

    public static CheckerIssue createSingleIssue(Rule rule, CriticalityEnum classification, BpmnElement element, String variableResourcePath, String varName, String message, ElementConvention convention) {
        BaseElement baseElement = element.getBaseElement();
        return new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), variableResourcePath, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), varName, message, convention.getDescription());
    }

    public static CheckerIssue createIssueWithClassPath(Rule rule, CriticalityEnum classification, String classPath, BpmnElement element, String message) {
        BaseElement baseElement = element.getBaseElement();
        return new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), classPath, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message, null);
    }

    public static CheckerIssue createIssueWithJavaRef(Rule rule, CriticalityEnum classification, BpmnElement element, String javaReference, String message) {
        BaseElement baseElement = element.getBaseElement();
        return new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), javaReference, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message, null);
    }

    public static CheckerIssue createIssueWithBeanRef(Rule rule, CriticalityEnum classification, BpmnElement element, String beanReference, String message) {
        BaseElement baseElement = element.getBaseElement();
        return new CheckerIssue(rule.getName(), rule.getRuleDescription(), classification, element.getProcessDefinition(), beanReference, baseElement.getAttributeValue("id"), baseElement.getAttributeValue("name"), message, null);
    }
}

