/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.config.reader;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.reader.VariablesReaderException;
import de.viadee.bpm.vPAV.config.reader.XmlVariable;
import de.viadee.bpm.vPAV.config.reader.XmlVariables;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public final class XmlVariablesReader {
    private static final Logger LOGGER = Logger.getLogger(XmlVariablesReader.class.getName());

    public HashMap<String, ListMultimap<String, ProcessVariableOperation>> read(String file, String defaultProcess) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlVariables.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        InputStream fVariables = RuntimeConfig.getInstance().getClassLoader().getResourceAsStream(file);
        if (fVariables != null) {
            XmlVariables xmlVariables = (XmlVariables)jaxbUnmarshaller.unmarshal(fVariables);
            return XmlVariablesReader.transformFromXmlDestructure(xmlVariables, defaultProcess);
        }
        LOGGER.log(Level.INFO, "No variables.xml file with user defined variables was found.");
        return new HashMap<String, ListMultimap<String, ProcessVariableOperation>>();
    }

    private static HashMap<String, ListMultimap<String, ProcessVariableOperation>> transformFromXmlDestructure(XmlVariables xmlVariables, String defaultProcess) {
        Collection<XmlVariable> variableCollection = xmlVariables.getVariables();
        HashMap<String, ListMultimap<String, ProcessVariableOperation>> operations = new HashMap<String, ListMultimap<String, ProcessVariableOperation>>();
        for (XmlVariable variable : variableCollection) {
            ProcessVariableOperation operation = null;
            try {
                operation = XmlVariablesReader.createOperationFromXml(variable, defaultProcess);
                if (variable.getCreationPoint() == null) {
                    variable.setCreationPoint("StartEvent");
                }
                if (!operations.containsKey(variable.getCreationPoint())) {
                    operations.put(variable.getCreationPoint(), (ListMultimap<String, ProcessVariableOperation>)ArrayListMultimap.create());
                }
                operations.get(variable.getCreationPoint()).put((Object)operation.getName(), (Object)operation);
            }
            catch (VariablesReaderException e) {
                LOGGER.warning("Variable in variables.xml is missing name. It will be ignored.");
            }
        }
        return operations;
    }

    private static ProcessVariableOperation createOperationFromXml(XmlVariable variable, String defaultProcess) throws VariablesReaderException {
        VariableOperation op;
        String name = variable.getName();
        String process = variable.getProcess();
        String scope = variable.getScope();
        String operation = variable.getOperation();
        if (name == null) {
            throw new VariablesReaderException("Name is not set.");
        }
        if (process == null) {
            process = defaultProcess;
        }
        if (scope == null) {
            scope = process;
        }
        if (operation == null) {
            operation = "write";
        }
        switch (operation) {
            case "read": {
                op = VariableOperation.READ;
                break;
            }
            case "delete": {
                op = VariableOperation.DELETE;
                break;
            }
            default: {
                op = VariableOperation.WRITE;
            }
        }
        return new ProcessVariableOperation(name, ElementChapter.UserDefined, KnownElementFieldType.UserDefined, op, scope);
    }
}

