/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.config.reader;

import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.ElementFieldTypes;
import de.viadee.bpm.vPAV.config.model.ModelConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.config.reader.ConfigReader;
import de.viadee.bpm.vPAV.config.reader.ConfigReaderException;
import de.viadee.bpm.vPAV.config.reader.XmlElementConvention;
import de.viadee.bpm.vPAV.config.reader.XmlElementFieldTypes;
import de.viadee.bpm.vPAV.config.reader.XmlModelConvention;
import de.viadee.bpm.vPAV.config.reader.XmlRule;
import de.viadee.bpm.vPAV.config.reader.XmlRuleSet;
import de.viadee.bpm.vPAV.config.reader.XmlSetting;
import de.viadee.bpm.vPAV.constants.ConfigConstants;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public final class XmlConfigReader
implements ConfigReader {
    private static final Logger LOGGER = Logger.getLogger(XmlConfigReader.class.getName());

    @Override
    public RuleSet read(String file) throws ConfigReaderException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlRuleSet.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            InputStream fRuleSet = RuntimeConfig.getInstance().getClassLoader().getResourceAsStream(file);
            if (fRuleSet != null) {
                XmlRuleSet ruleSet = (XmlRuleSet)jaxbUnmarshaller.unmarshal(fRuleSet);
                return XmlConfigReader.transformFromXmlDestructure(ruleSet);
            }
            throw new ConfigReaderException("ConfigFile could not be found");
        }
        catch (JAXBException e) {
            throw new ConfigReaderException(e);
        }
    }

    public RuleSet getDeactivatedRuleSet() {
        HashMap<String, Map<String, Rule>> rules = new HashMap<String, Map<String, Rule>>();
        for (String name : RuntimeConfig.getInstance().getViadeeRules()) {
            HashMap<String, Rule> newrule = new HashMap<String, Rule>();
            if (name.equals("CreateOutputHTML")) {
                newrule.put(name, new Rule(name, true, null, new HashMap<String, Setting>(), new ArrayList<ElementConvention>(), new ArrayList<ModelConvention>()));
            } else {
                newrule.put(name, new Rule(name, false, null, new HashMap<String, Setting>(), new ArrayList<ElementConvention>(), new ArrayList<ModelConvention>()));
            }
            rules.put(name, newrule);
        }
        return new RuleSet(rules, new HashMap<String, Map<String, Rule>>(), false);
    }

    private static RuleSet transformFromXmlDestructure(XmlRuleSet ruleSet) throws ConfigReaderException {
        HashMap<String, Map<String, Rule>> rules = new HashMap<String, Map<String, Rule>>();
        Collection<XmlRule> xmlRules = ruleSet.getRules();
        for (XmlRule rule : xmlRules) {
            Rule ruleObj = XmlConfigReader.transformXmlRule(rule);
            if (!rules.containsKey(ruleObj.getName())) {
                rules.put(ruleObj.getName(), new HashMap());
            }
            ((Map)rules.get(ruleObj.getName())).put(ruleObj.getId(), ruleObj);
        }
        XmlConfigReader.checkSingletonRule(rules, "HasParentRuleSet");
        XmlConfigReader.checkSingletonRule(rules, "CreateOutputHTML");
        XmlConfigReader.checkSingletonRule(rules, "language");
        return XmlConfigReader.splitRules(rules);
    }

    private static Rule transformXmlRule(XmlRule rule) throws ConfigReaderException {
        String id = rule.getId() == null ? rule.getName() : rule.getId();
        String name = rule.getName();
        if (name == null) {
            throw new ConfigReaderException("rule name is not set");
        }
        Collection<XmlElementConvention> xmlElementConventions = rule.getElementConventions();
        ArrayList<ElementConvention> elementConventions = new ArrayList<ElementConvention>();
        if (xmlElementConventions != null) {
            for (XmlElementConvention xmlElementConvention : xmlElementConventions) {
                XmlElementFieldTypes xmlElementFieldTypes = xmlElementConvention.getElementFieldTypes();
                ElementFieldTypes elementFieldTypes = null;
                if (xmlElementFieldTypes != null) {
                    elementFieldTypes = new ElementFieldTypes(xmlElementFieldTypes.getElementFieldTypes(), xmlElementFieldTypes.isExcluded());
                }
                if (!XmlConfigReader.checkRegEx(xmlElementConvention.getPattern())) {
                    throw new ConfigReaderException("RegEx (" + xmlElementConvention.getPattern() + ") of " + name + " (" + xmlElementConvention.getName() + ") is incorrect");
                }
                elementConventions.add(new ElementConvention(xmlElementConvention.getName(), elementFieldTypes, xmlElementConvention.getDescription(), xmlElementConvention.getPattern()));
            }
        }
        Collection<XmlModelConvention> xmlModelConventions = rule.getModelConventions();
        ArrayList<ModelConvention> modelConventions = new ArrayList<ModelConvention>();
        if (xmlModelConventions != null) {
            xmlModelConventions.forEach(xmlModelConvention -> modelConventions.add(new ModelConvention(xmlModelConvention.getType())));
        }
        Collection<XmlSetting> xmlSettings = rule.getSettings();
        HashMap<String, Setting> settings = new HashMap<String, Setting>();
        if (xmlSettings != null) {
            for (XmlSetting xmlSetting : xmlSettings) {
                if (!settings.containsKey(xmlSetting.getName())) {
                    settings.put(xmlSetting.getName(), new Setting(xmlSetting.getName(), xmlSetting.getScript(), xmlSetting.getType(), xmlSetting.getId(), xmlSetting.getRequired(), xmlSetting.getValue()));
                    continue;
                }
                ((Setting)settings.get(xmlSetting.getName())).addScriptPlace(xmlSetting.getScript());
            }
        }
        return new Rule(id, name, rule.isState(), rule.getDescription(), settings, elementConventions, modelConventions);
    }

    private static RuleSet splitRules(Map<String, Map<String, Rule>> rules) {
        boolean hasParentRuleSet = XmlConfigReader.extractProperties(rules);
        HashMap<String, Map<String, Rule>> elementRules = new HashMap<String, Map<String, Rule>>();
        HashMap<String, Map<String, Rule>> modelRules = new HashMap<String, Map<String, Rule>>();
        List<String> viadeeRules = Arrays.asList(RuntimeConfig.getInstance().getViadeeRules());
        List<String> viadeeElementRules = Arrays.asList(RuntimeConfig.getInstance().getViadeeElementRules());
        for (Map.Entry<String, Map<String, Rule>> checkerRules : rules.entrySet()) {
            if (viadeeRules.contains(checkerRules.getKey())) {
                if (viadeeElementRules.contains(checkerRules.getKey())) {
                    elementRules.put(checkerRules.getKey(), checkerRules.getValue());
                    continue;
                }
                modelRules.put(checkerRules.getKey(), checkerRules.getValue());
                continue;
            }
            XmlConfigReader.resolveExternalChecker(checkerRules, elementRules, modelRules);
        }
        return new RuleSet(elementRules, modelRules, hasParentRuleSet);
    }

    private static void resolveExternalChecker(Map.Entry<String, Map<String, Rule>> checkerRules, HashMap<String, Map<String, Rule>> elementRules, HashMap<String, Map<String, Rule>> modelRules) {
        String className = "";
        Rule firstRule = (Rule)checkerRules.getValue().values().toArray()[0];
        if (firstRule.getSettings() != null && firstRule.getSettings().containsKey("external_Location")) {
            className = firstRule.getSettings().get("external_Location").getValue() + "." + firstRule.getName().trim();
            try {
                Class<?> clazz = Class.forName(className);
                Class<?> superClazz = clazz.getSuperclass();
                if (superClazz.getName().equals("de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker")) {
                    elementRules.put(checkerRules.getKey(), checkerRules.getValue());
                    return;
                }
                if (superClazz.getName().equals("de.viadee.bpm.vPAV.processing.checker.AbstractModelChecker")) {
                    modelRules.put(checkerRules.getKey(), checkerRules.getValue());
                    return;
                }
                LOGGER.warning("Class " + className + " does not extend a valid checker class. All rules of this type were deactivated.");
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning("Class " + className + " was not found. All rules of this type were deactivated");
            }
            for (Rule rule : checkerRules.getValue().values()) {
                rule.deactivate();
            }
        }
    }

    @Deprecated
    private static boolean extractProperties(Map<String, Map<String, Rule>> rules) {
        boolean hasParentRuleSet = false;
        if (rules.containsKey("HasParentRuleSet")) {
            hasParentRuleSet = rules.get("HasParentRuleSet").get("HasParentRuleSet").isActive();
            rules.remove("HasParentRuleSet");
        }
        if (rules.containsKey("CreateOutputHTML")) {
            LOGGER.warning("Usage of 'CreateOutputHtml' rule is deprecated. Please use vpav.properties instead.");
            ConfigConstants.getInstance().setHtmlOutputEnabled(rules.get("CreateOutputHTML").get("CreateOutputHTML").isActive());
            rules.remove("CreateOutputHTML");
        }
        if (rules.containsKey("language")) {
            LOGGER.warning("Usage of 'language' rule is deprecated. Please use vpav.properties instead.");
            Map<String, Setting> settings = rules.get("language").get("language").getSettings();
            if (settings.get("locale").getValue().equals("de")) {
                ConfigConstants.getInstance().setLanguage("de_DE");
            } else {
                ConfigConstants.getInstance().setLanguage("en_US");
            }
            rules.remove("HasParentRuleSet");
        }
        return hasParentRuleSet;
    }

    private static void checkSingletonRule(Map<String, Map<String, Rule>> rules, String rulename) {
        Map<String, Rule> rulesSubset = rules.get(rulename);
        if (rulesSubset != null && (rulesSubset.size() > 1 || rulesSubset.get(rulename) == null)) {
            LOGGER.severe("Rule '" + rulename + "' is only allowed once and without defining an ID.");
        }
    }

    private static boolean checkRegEx(String regEx) {
        boolean correct = false;
        if (regEx.isEmpty()) {
            return false;
        }
        try {
            Pattern.compile(regEx);
            correct = true;
        }
        catch (PatternSyntaxException e) {
            LOGGER.info("PatternSyntaxException was catched.");
        }
        return correct;
    }
}

