/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.config.model;

import de.viadee.bpm.vPAV.config.model.Rule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RuleSet {
    private final Map<String, Map<String, Rule>> elementRules;
    private final Map<String, Map<String, Rule>> modelRules;
    private final Map<String, Map<String, Rule>> allRules;
    private boolean hasParentRuleSet = false;

    public RuleSet() {
        this.elementRules = new HashMap<String, Map<String, Rule>>();
        this.modelRules = new HashMap<String, Map<String, Rule>>();
        this.allRules = new HashMap<String, Map<String, Rule>>();
    }

    public RuleSet(Map<String, Map<String, Rule>> elementRules, Map<String, Map<String, Rule>> modelRules, boolean hasParentRuleSet) {
        this.elementRules = Collections.unmodifiableMap(elementRules);
        this.modelRules = Collections.unmodifiableMap(modelRules);
        this.hasParentRuleSet = hasParentRuleSet;
        HashMap<String, Map<String, Rule>> allRulesTemp = new HashMap<String, Map<String, Rule>>();
        allRulesTemp.putAll(elementRules);
        allRulesTemp.putAll(modelRules);
        this.allRules = Collections.unmodifiableMap(allRulesTemp);
    }

    public Map<String, Map<String, Rule>> getModelRules() {
        return this.modelRules;
    }

    public Map<String, Map<String, Rule>> getElementRules() {
        return this.elementRules;
    }

    public Map<String, Map<String, Rule>> getAllRules() {
        return this.allRules;
    }

    public Map<String, Map<String, Rule>> getAllActiveRules() {
        return this.allRules.entrySet().stream().filter(e -> ((Map)e.getValue()).entrySet().stream().allMatch(r -> ((Rule)r.getValue()).isActive())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean hasParentRuleSet() {
        return this.hasParentRuleSet;
    }
}

