/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.constants.ConfigConstants;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;

public class RuntimeConfig {
    private static RuntimeConfig instance;
    private ApplicationContext ctx;
    private Map<String, String> beanMap;
    private RuleSet ruleSet;
    private ClassLoader classLoader;
    private ResourceBundle resourceBundle;
    private boolean test = false;
    private static Logger logger;
    private final String[] viadeeConfigRules = new String[]{"CreateOutputHTML"};
    private final String[] viadeeElementRules = new String[]{"XorConventionChecker", "TimerExpressionChecker", "JavaDelegateChecker", "NoScriptChecker", "NoExpressionChecker", "EmbeddedGroovyScriptChecker", "VersioningChecker", "DmnTaskChecker", "ProcessVariablesNameConventionChecker", "TaskNamingConventionChecker", "ElementIdConventionChecker", "MessageEventChecker", "FieldInjectionChecker", "BoundaryErrorChecker", "ExtensionChecker", "OverlapChecker", "SignalEventChecker", "MessageCorrelationChecker"};
    private final String[] viadeeModelRules = new String[]{"ProcessVariablesModelChecker", "DataFlowChecker"};

    private RuntimeConfig() {
    }

    public static RuntimeConfig getInstance() {
        if (instance == null) {
            instance = new RuntimeConfig();
        }
        return instance;
    }

    public String findBeanByName(String string) {
        if (string != null && !string.isEmpty() && this.beanMap != null && !this.beanMap.isEmpty()) {
            return this.beanMap.get(string);
        }
        return null;
    }

    public void setBeanMapping(Map<String, String> beanMap) {
        this.beanMap = beanMap;
    }

    public Map<String, String> getBeanMapping() {
        return this.beanMap;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public String[] getViadeeRules() {
        return (String[])Stream.of(this.viadeeConfigRules, this.viadeeElementRules, this.viadeeModelRules).flatMap(Stream::of).toArray(String[]::new);
    }

    public String[] getViadeeElementRules() {
        return this.viadeeElementRules;
    }

    public ArrayList<String> getActiveRules() {
        ArrayList<String> activeRules = new ArrayList<String>(this.ruleSet.getAllActiveRules().keySet());
        return activeRules;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public ApplicationContext getApplicationContext() {
        return this.ctx;
    }

    public void retrieveLocale(RuleSet rules) {
        if (ConfigConstants.getInstance().getLanguage().equals("de_DE")) {
            this.getResource("de_DE");
        } else {
            this.getResource("en_US");
        }
    }

    public void getResource(String locale) {
        this.setResourceBundle(RuntimeConfig.fromClassLoader("messages_" + locale));
    }

    private static ResourceBundle fromClassLoader(String bundleName) {
        URLClassLoader ucl = RuntimeConfig.getInstance().getClassLoader() instanceof URLClassLoader ? (URLClassLoader)RuntimeConfig.getInstance().getClassLoader() : (URLClassLoader)RuntimeConfig.getInstance().getClassLoader().getParent();
        URL[] urls = ucl.getURLs();
        URLClassLoader loader = new URLClassLoader(urls);
        return ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    static {
        logger = Logger.getLogger(RuntimeConfig.class.getName());
    }
}

