/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.config.reader.ConfigReaderException;
import de.viadee.bpm.vPAV.config.reader.XmlConfigReader;
import de.viadee.bpm.vPAV.constants.ConfigConstants;
import de.viadee.bpm.vPAV.output.JsOutputWriter;
import de.viadee.bpm.vPAV.output.JsonOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.output.RuleSetOutputWriter;
import de.viadee.bpm.vPAV.output.XmlOutputWriter;
import de.viadee.bpm.vPAV.processing.BpmnModelDispatcher;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.ModelDispatchResult;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Runner {
    private static Logger logger = Logger.getLogger(Runner.class.getName());
    private FileScanner fileScanner;
    private ProcessVariablesScanner variableScanner;
    private Collection<CheckerIssue> issues;
    private Collection<CheckerIssue> filteredIssues;
    private RuleSet rules = new RuleSet();
    private Map<String, String> ignoredIssuesMap = new HashMap<String, String>();
    private Map<String, String> fileMapping = this.createFileFolderMapping();
    private Map<String, String> wrongCheckersMap = new HashMap<String, String>();
    private ArrayList<String> allOutputFilesArray = this.createAllOutputFilesArray();
    private Collection<BpmnElement> elements = new ArrayList<BpmnElement>();
    private Collection<ProcessVariable> processVariables = new ArrayList<ProcessVariable>();
    private Collection<DataFlowRule> dataFlowRules = new ArrayList<DataFlowRule>();
    private boolean checkProcessVariables = false;

    public void viadeeProcessApplicationValidator() {
        this.rules = this.readConfig();
        this.setFileScanner(new FileScanner(this.rules));
        this.getProcessVariables(this.rules);
        this.createIssues(this.rules, this.dataFlowRules);
        this.removeIgnoredIssues();
        this.writeOutput(this.filteredIssues, this.elements, this.processVariables);
        this.copyFiles();
        logger.info("BPMN validation successfully completed");
    }

    private RuleSet readConfig() {
        this.prepareOutputFolder();
        this.rules = new XmlConfigReader().getDeactivatedRuleSet();
        RuleSetOutputWriter ruleSetOutputWriter = new RuleSetOutputWriter();
        try {
            if (new File("src/test/resources/ruleSet.xml").exists()) {
                RuleSet localRule = new XmlConfigReader().read("ruleSet.xml");
                if (localRule.getElementRules().containsKey("HasParentRuleSet") && localRule.getElementRules().get("HasParentRuleSet").get("HasParentRuleSet").isActive()) {
                    this.rules = this.mergeRuleSet(this.rules, new XmlConfigReader().read("parentRuleSet.xml"));
                    this.rules = this.mergeRuleSet(this.rules, localRule);
                } else {
                    this.rules = this.mergeRuleSet(this.rules, localRule);
                }
            } else {
                this.rules = new XmlConfigReader().read("ruleSetDefault.xml");
            }
            ruleSetOutputWriter.write(this.rules);
            RuntimeConfig.getInstance().setRuleSet(this.rules);
        }
        catch (ConfigReaderException | OutputWriterException e) {
            throw new RuntimeException(e);
        }
        RuntimeConfig.getInstance().retrieveLocale(this.rules);
        return this.rules;
    }

    private void prepareOutputFolder() {
        this.deleteFiles();
        this.createvPAVFolder();
        try {
            Files.createDirectory(Paths.get("target/vPAV/js/", new String[0]), new FileAttribute[0]);
            Files.createDirectory(Paths.get("target/vPAV/css/", new String[0]), new FileAttribute[0]);
            Files.createDirectory(Paths.get("target/vPAV/img/", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.warning("Could not create either output folder for JS, CSS or IMG");
        }
    }

    protected RuleSet mergeRuleSet(RuleSet parentRules, RuleSet childRules) {
        HashMap<String, Map<String, Rule>> finalModelRules = new HashMap<String, Map<String, Rule>>();
        HashMap<String, Map<String, Rule>> finalElementRules = new HashMap<String, Map<String, Rule>>(parentRules.getElementRules());
        finalModelRules.putAll(parentRules.getModelRules());
        for (Map.Entry<String, Map<String, Rule>> entry : childRules.getElementRules().entrySet()) {
            if (finalElementRules.containsKey(entry.getKey())) {
                ((Map)finalElementRules.get(entry.getKey())).putAll(entry.getValue());
                continue;
            }
            finalElementRules.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Map<String, Rule>> entry : childRules.getModelRules().entrySet()) {
            if (finalModelRules.containsKey(entry.getKey())) {
                ((Map)finalModelRules.get(entry.getKey())).putAll(entry.getValue());
                continue;
            }
            finalModelRules.put(entry.getKey(), entry.getValue());
        }
        return new RuleSet(finalElementRules, finalModelRules, false);
    }

    protected void getProcessVariables(RuleSet rules) {
        if (this.oneCheckerIsActive(rules.getModelRules(), "ProcessVariablesModelChecker") || this.oneCheckerIsActive(rules.getElementRules(), "ProcessVariablesNameConventionChecker") || this.oneCheckerIsActive(rules.getModelRules(), "DataFlowChecker")) {
            this.variableScanner = new ProcessVariablesScanner(this.getFileScanner().getJavaResourcesFileInputStream());
            this.readOuterProcessVariables(this.variableScanner);
            this.setCheckProcessVariables(true);
        } else {
            this.setCheckProcessVariables(false);
        }
    }

    private boolean oneCheckerIsActive(Map<String, Map<String, Rule>> rules, String name) {
        for (Rule r : rules.get(name).values()) {
            if (!r.isActive()) continue;
            return true;
        }
        return false;
    }

    private void createIssues(RuleSet rules, Collection<DataFlowRule> dataFlowRules) {
        this.issues = this.checkModels(rules, this.getFileScanner(), this.variableScanner, dataFlowRules);
    }

    private void removeIgnoredIssues() {
        this.filteredIssues = this.filterIssues(this.issues);
    }

    private void writeOutput(Collection<CheckerIssue> filteredIssues, Collection<BpmnElement> elements, Collection<ProcessVariable> processVariables) {
        if (filteredIssues.size() > 0) {
            XmlOutputWriter xmlOutputWriter = new XmlOutputWriter();
            JsonOutputWriter jsonOutputWriter = new JsonOutputWriter();
            JsOutputWriter jsOutputWriter = new JsOutputWriter();
            try {
                jsOutputWriter.prepareMaps(this.getWrongCheckersMap(), this.getIgnoredIssuesMap(), this.getModelPath());
                xmlOutputWriter.write(filteredIssues);
                jsonOutputWriter.write(filteredIssues);
                jsOutputWriter.write(filteredIssues);
                jsOutputWriter.writeVars(elements, processVariables);
            }
            catch (OutputWriterException e) {
                throw new RuntimeException("Output couldn't be written", e);
            }
        }
        try {
            JsOutputWriter jsOutputWriter = new JsOutputWriter();
            jsOutputWriter.prepareMaps(this.getWrongCheckersMap(), this.getIgnoredIssuesMap(), this.getModelPath());
            jsOutputWriter.write(filteredIssues);
            jsOutputWriter.writeVars(elements, processVariables);
        }
        catch (OutputWriterException e) {
            throw new RuntimeException("JavaScript File couldn't be written", e);
        }
    }

    private void createvPAVFolder() {
        boolean success;
        File vPavDir = new File("target/vPAV/");
        if (!vPavDir.exists() && !(success = vPavDir.mkdirs())) {
            throw new RuntimeException("vPAV directory does not exist and could not be created");
        }
    }

    private void deleteFiles() {
        File index = new File("target/vPAV/");
        if (index.exists()) {
            String[] entries;
            for (String entry : entries = index.list()) {
                File currentFile = new File(index.getPath(), entry);
                if (currentFile.isDirectory()) {
                    String[] subEntries;
                    for (String subentry : subEntries = currentFile.list()) {
                        File file = new File(currentFile.getPath(), subentry);
                        file.delete();
                    }
                }
                currentFile.delete();
            }
        }
    }

    private void copyFiles() {
        ArrayList<Path> outputFiles = new ArrayList<Path>();
        for (String file : this.allOutputFilesArray) {
            outputFiles.add(Paths.get(this.fileMapping.get(file), file));
        }
        if (ConfigConstants.getInstance().isHtmlOutputEnabled()) {
            for (String file : this.allOutputFilesArray) {
                this.copyFileToVPAVFolder(file);
            }
        }
    }

    private ArrayList<String> createAllOutputFilesArray() {
        ArrayList<String> allFiles = new ArrayList<String>();
        allFiles.add("bootstrap.min.js");
        allFiles.add("bpmn-navigated-viewer.js");
        allFiles.add("bpmn.io.viewer.app.js");
        allFiles.add("jquery-3.2.1.min.js");
        allFiles.add("popper.min.js");
        allFiles.add("infoPOM.js");
        allFiles.add("download.js");
        allFiles.add("bootstrap.min.css");
        allFiles.add("viadee.css");
        allFiles.add("MarkerStyle.css");
        allFiles.add("vPAV.png");
        allFiles.add("viadee_weiss.png");
        allFiles.add("GitHub.png");
        allFiles.add("error.png");
        allFiles.add("warning.png");
        allFiles.add("info.png");
        allFiles.add("success.png");
        allFiles.add("dl_button.png");
        allFiles.add("validationResult.html");
        return allFiles;
    }

    private Map<String, String> createFileFolderMapping() {
        HashMap<String, String> fMap = new HashMap<String, String>();
        fMap.put("bootstrap.min.js", "target/vPAV/js/");
        fMap.put("bpmn-navigated-viewer.js", "target/vPAV/js/");
        fMap.put("bpmn.io.viewer.app.js", "target/vPAV/js/");
        fMap.put("jquery-3.2.1.min.js", "target/vPAV/js/");
        fMap.put("popper.min.js", "target/vPAV/js/");
        fMap.put("infoPOM.js", "target/vPAV/js/");
        fMap.put("download.js", "target/vPAV/js/");
        fMap.put("bootstrap.min.css", "target/vPAV/css/");
        fMap.put("viadee.css", "target/vPAV/css/");
        fMap.put("MarkerStyle.css", "target/vPAV/css/");
        fMap.put("vPAV.png", "target/vPAV/img/");
        fMap.put("viadee_weiss.png", "target/vPAV/img/");
        fMap.put("GitHub.png", "target/vPAV/img/");
        fMap.put("error.png", "target/vPAV/img/");
        fMap.put("warning.png", "target/vPAV/img/");
        fMap.put("info.png", "target/vPAV/img/");
        fMap.put("success.png", "target/vPAV/img/");
        fMap.put("dl_button.png", "target/vPAV/img/");
        fMap.put("validationResult.html", "target/vPAV/");
        return fMap;
    }

    private void copyFileToVPAVFolder(String file) {
        InputStream source = Runner.class.getClassLoader().getResourceAsStream(file);
        Path destination = Paths.get(this.fileMapping.get(file) + file, new String[0]);
        try {
            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Files couldn't be written");
        }
    }

    private Collection<CheckerIssue> filterIssues(Collection<CheckerIssue> issues) {
        Collection<CheckerIssue> filteredIssues = this.getFilteredIssues(issues);
        Collections.sort((List)filteredIssues);
        return filteredIssues;
    }

    private Collection<CheckerIssue> getFilteredIssues(Collection<CheckerIssue> issues) {
        HashMap<String, CheckerIssue> issuesMap = new HashMap<String, CheckerIssue>();
        for (CheckerIssue issue : issues) {
            if (issuesMap.containsKey(issue.getId())) continue;
            issuesMap.put(issue.getId(), issue);
        }
        Collection<String> ignoredIssues = this.collectIgnoredIssues("src/test/resources/ignoreIssues.txt");
        HashMap filteredIssues = new HashMap(issuesMap);
        for (Map.Entry entry : issuesMap.entrySet()) {
            if (!ignoredIssues.contains(entry.getKey())) continue;
            filteredIssues.remove(entry.getKey());
        }
        ArrayList<CheckerIssue> finalFilteredIssues = new ArrayList<CheckerIssue>();
        for (Map.Entry entry : filteredIssues.entrySet()) {
            finalFilteredIssues.add((CheckerIssue)entry.getValue());
        }
        return finalFilteredIssues;
    }

    private Collection<String> collectIgnoredIssues(String filePath) {
        Throwable throwable;
        FileReader fileReader;
        Map<String, String> ignoredIssuesMap = this.getIgnoredIssuesMap();
        ArrayList<String> ignoredIssues = new ArrayList<String>();
        try {
            fileReader = new FileReader("src/test/resources/.ignoreIssues");
            throwable = null;
            try {
                this.readIssues(ignoredIssuesMap, ignoredIssues, fileReader);
                logger.warning("Usage of .ignoreIssues is deprecated. Please use ignoreIssues.txt to whitelist issues.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileReader != null) {
                    if (throwable != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fileReader.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.info(ex.getMessage());
        }
        try {
            fileReader = new FileReader(filePath);
            throwable = null;
            try {
                this.readIssues(ignoredIssuesMap, ignoredIssues, fileReader);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fileReader != null) {
                    if (throwable != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileReader.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.info("Ignored issues couldn't be read successfully");
        }
        return ignoredIssues;
    }

    private void readIssues(Map<String, String> ignoredIssuesMap, Collection<String> ignoredIssues, FileReader fileReader) {
        try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String zeile;
            String prevLine = zeile = bufferedReader.readLine();
            while (zeile != null) {
                this.addIgnoredIssue(ignoredIssuesMap, ignoredIssues, zeile, prevLine);
                prevLine = zeile;
                zeile = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
    }

    private Collection<CheckerIssue> checkModels(RuleSet rules, FileScanner fileScanner, ProcessVariablesScanner variableScanner, Collection<DataFlowRule> dataFlowRules) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (String pathToModel : fileScanner.getProcessDefinitions()) {
            issues.addAll(this.checkModel(rules, pathToModel, fileScanner, variableScanner, dataFlowRules));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkModel(RuleSet rules, String processDefinition, FileScanner fileScanner, ProcessVariablesScanner variableScanner, Collection<DataFlowRule> dataFlowRules) {
        BpmnModelDispatcher bpmnModelDispatcher = new BpmnModelDispatcher();
        File bpmnfile = null;
        String basepath = ConfigConstants.getInstance().getBasepath();
        if (basepath.startsWith("file:/")) {
            try {
                bpmnfile = new File(new URI(ConfigConstants.getInstance().getBasepath() + processDefinition));
            }
            catch (URISyntaxException e) {
                logger.log(Level.SEVERE, "URI of basedirectory seems to be malformed.", e);
            }
        } else {
            bpmnfile = new File(basepath + processDefinition);
        }
        ModelDispatchResult dispatchResult = variableScanner != null ? bpmnModelDispatcher.dispatchWithVariables(fileScanner, bpmnfile, variableScanner, dataFlowRules, rules) : bpmnModelDispatcher.dispatchWithoutVariables(bpmnfile, fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), fileScanner.getResourcesNewestVersions(), rules);
        this.elements.addAll(dispatchResult.getBpmnElements());
        this.processVariables.addAll(dispatchResult.getProcessVariables());
        this.setWrongCheckersMap(bpmnModelDispatcher.getIncorrectCheckers());
        return dispatchResult.getIssues();
    }

    private void addIgnoredIssue(Map<String, String> ignoredIssuesMap, Collection<String> issues, String row, String prevLine) {
        if (row != null && !row.isEmpty() && !row.trim().startsWith("#")) {
            ignoredIssuesMap.put(row, prevLine);
            issues.add(row);
        }
    }

    private void readOuterProcessVariables(ProcessVariablesScanner scanner) {
        scanner.scanProcessVariables();
    }

    public Set<String> getModelPath() {
        return this.getFileScanner().getProcessDefinitions();
    }

    public Collection<CheckerIssue> getFilteredIssues() {
        return this.filteredIssues;
    }

    public Map<String, String> getIgnoredIssuesMap() {
        return this.ignoredIssuesMap;
    }

    public void setIgnoredIssuesMap(Map<String, String> ignoredIssuesMap) {
        this.ignoredIssuesMap = ignoredIssuesMap;
    }

    public boolean isCheckProcessVariables() {
        return this.checkProcessVariables;
    }

    public void setCheckProcessVariables(boolean checkProcessVariables) {
        this.checkProcessVariables = checkProcessVariables;
    }

    public void setDataFlowRules(Collection<DataFlowRule> dataFlowRules) {
        this.dataFlowRules = dataFlowRules;
    }

    public FileScanner getFileScanner() {
        return this.fileScanner;
    }

    public void setFileScanner(FileScanner fileScanner) {
        this.fileScanner = fileScanner;
    }

    public Map<String, String> getWrongCheckersMap() {
        return this.wrongCheckersMap;
    }

    public void setWrongCheckersMap(Map<String, String> wrongCheckersMap) {
        this.wrongCheckersMap = wrongCheckersMap;
    }
}

