/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.ProcessApplicationValidator;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.beans.BeanMappingGenerator;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.processing.BpmnModelDispatcher;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.ProcessVariablesScanner;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.FlowAnalysis;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.io.File;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.springframework.context.ApplicationContext;

public class ProcessApplicationVariableParser {
    public static Collection<ProcessVariable> parseProcessVariables(File modelFile, ApplicationContext ctx) {
        RuntimeConfig.getInstance().setApplicationContext(ctx);
        RuntimeConfig.getInstance().setBeanMapping(BeanMappingGenerator.generateBeanMappingFile(ctx));
        RuntimeConfig.getInstance().setClassLoader(ProcessApplicationValidator.class.getClassLoader());
        FileScanner fileScanner = new FileScanner(new RuleSet());
        ProcessVariablesScanner variableScanner = ProcessApplicationVariableParser.readOuterProcessVariables(fileScanner);
        BpmnScanner bpmnScanner = ProcessApplicationVariableParser.createScanner(modelFile);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)modelFile);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), variableScanner.getMessageIdToVariableMap(), variableScanner.getProcessIdToVariableMap(), bpmnScanner);
        Collection<BpmnElement> bpmnElements = BpmnModelDispatcher.getBpmnElements(modelFile, baseElements, graphBuilder, new FlowAnalysis());
        return BpmnModelDispatcher.getProcessVariables(bpmnElements);
    }

    private static ProcessVariablesScanner readOuterProcessVariables(FileScanner fileScanner) {
        ProcessVariablesScanner variableScanner = new ProcessVariablesScanner(fileScanner.getJavaResourcesFileInputStream());
        variableScanner.scanProcessVariables();
        return variableScanner;
    }

    private static BpmnScanner createScanner(File processDefinition) {
        return new BpmnScanner(processDefinition.getPath());
    }
}

