/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.Runner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.beans.BeanMappingGenerator;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.context.ApplicationContext;

public class ProcessApplicationValidator {
    private static Collection<DataFlowRule> dataFlowRules = new ArrayList<DataFlowRule>();

    public static void setDataFlowRules(Collection<DataFlowRule> dataFlowRules) {
        ProcessApplicationValidator.dataFlowRules = dataFlowRules;
    }

    public static Collection<CheckerIssue> findModelInconsistencies(ApplicationContext ctx) {
        RuntimeConfig.getInstance().setApplicationContext(ctx);
        RuntimeConfig.getInstance().setBeanMapping(BeanMappingGenerator.generateBeanMappingFile(ctx));
        RuntimeConfig.getInstance().setClassLoader(ProcessApplicationValidator.class.getClassLoader());
        Runner runner = ProcessApplicationValidator.createRunner();
        return runner.getFilteredIssues();
    }

    public static Collection<CheckerIssue> findModelErrors(ApplicationContext ctx) {
        return ProcessApplicationValidator.filterErrors(ProcessApplicationValidator.findModelInconsistencies(ctx), CriticalityEnum.ERROR);
    }

    public static Collection<CheckerIssue> findModelInconsistencies() {
        RuntimeConfig.getInstance().setClassLoader(ProcessApplicationValidator.class.getClassLoader());
        Runner runner = ProcessApplicationValidator.createRunner();
        return runner.getFilteredIssues();
    }

    public static Collection<CheckerIssue> findModelErrors() {
        return ProcessApplicationValidator.filterErrors(ProcessApplicationValidator.findModelInconsistencies(), CriticalityEnum.ERROR);
    }

    public static Collection<CheckerIssue> findModelInconsistencies(HashMap<String, String> beanMap) {
        RuntimeConfig.getInstance().setClassLoader(ProcessApplicationValidator.class.getClassLoader());
        RuntimeConfig.getInstance().setBeanMapping(beanMap);
        Runner runner = ProcessApplicationValidator.createRunner();
        return runner.getFilteredIssues();
    }

    public static Collection<CheckerIssue> findModelErrors(HashMap<String, String> beanMap) {
        return ProcessApplicationValidator.filterErrors(ProcessApplicationValidator.findModelInconsistencies(beanMap), CriticalityEnum.ERROR);
    }

    public static Collection<CheckerIssue> findModelErrorsFromClassloader(ClassLoader classloader) {
        return ProcessApplicationValidator.filterErrors(ProcessApplicationValidator.findModelInconsistenciesFromClassloader(classloader), CriticalityEnum.ERROR);
    }

    public static Collection<CheckerIssue> findModelInconsistenciesFromClassloader(ClassLoader classloader) {
        RuntimeConfig.getInstance().setClassLoader(classloader);
        Runner runner = ProcessApplicationValidator.createRunner();
        return runner.getFilteredIssues();
    }

    private static Collection<CheckerIssue> filterErrors(Collection<CheckerIssue> filteredIssues, CriticalityEnum status) {
        ArrayList<CheckerIssue> filteredErrors = new ArrayList<CheckerIssue>();
        for (CheckerIssue issue : filteredIssues) {
            if (!issue.getClassification().equals((Object)status)) continue;
            filteredErrors.add(issue);
        }
        return filteredErrors;
    }

    private static Runner createRunner() {
        Runner runner = new Runner();
        runner.setDataFlowRules(dataFlowRules);
        dataFlowRules = new ArrayList<DataFlowRule>();
        runner.viadeeProcessApplicationValidator();
        return runner;
    }
}

