/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.RuleSet;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.constants.ConfigConstants;
import de.viadee.bpm.vPAV.processing.ConfigItemNotFoundException;
import de.viadee.bpm.vPAV.processing.checker.VersioningChecker;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.tools.ant.DirectoryScanner;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelException;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelException;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;

public class FileScanner {
    private final Set<String> processDefinitions;
    private static Set<String> resourcesFileInputStream = new HashSet<String>();
    private Set<String> includedFiles = new HashSet<String>();
    private Map<String, String> decisionRefToPathMap;
    private Collection<String> resourcesNewestVersions = new ArrayList<String>();
    private Map<String, String> processIdToPathMap;
    private String scanPath;
    private static String scheme = null;
    private static StringBuilder sootPath = new StringBuilder();
    private static Collection<String> sootPaths = new ArrayList<String>();
    private static boolean isDirectory = false;
    private static final Logger LOGGER = Logger.getLogger(FileScanner.class.getName());

    public FileScanner(RuleSet rules) {
        Rule rule;
        DirectoryScanner scanner = new DirectoryScanner();
        File basedir = null;
        String basepath = ConfigConstants.getInstance().getBasepath();
        if (basepath.startsWith("file:/")) {
            try {
                basedir = new File(new URI(ConfigConstants.getInstance().getBasepath()));
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "URI of basedirectory seems to be malformed.", e);
            }
        } else {
            basedir = new File(basepath);
        }
        scanner.setBasedir(basedir);
        scanner.setIncludes(new String[]{"**/*.bpmn"});
        scanner.scan();
        this.processDefinitions = new HashSet<String>(Arrays.asList(scanner.getIncludedFiles()));
        if (this.processDefinitions.size() < 1 && !RuntimeConfig.getInstance().isTest()) {
            LOGGER.log(Level.SEVERE, "No model present in given location (" + basepath + ")");
            System.exit(0);
        }
        this.scanPath = ConfigConstants.getInstance().getScanPath();
        String filePattern = ConfigConstants.getInstance().getFilePattern();
        scanner.setBasedir(this.scanPath);
        scanner.setIncludes(new String[]{filePattern});
        if (scanner.getBasedir().exists()) {
            scanner.scan();
            resourcesFileInputStream = new HashSet<String>(Arrays.asList(scanner.getIncludedFiles()));
        } else {
            LOGGER.log(Level.SEVERE, "No compiled files in target folder. Build project at least once.");
        }
        scanner.setBasedir("target/generated-sources/");
        scanner.setIncludes(new String[]{filePattern});
        if (scanner.getBasedir().exists()) {
            scanner.scan();
            resourcesFileInputStream.addAll(Arrays.asList(scanner.getIncludedFiles()));
        }
        this.processIdToPathMap = FileScanner.createProcessIdToPathMap(this.processDefinitions);
        String versioningScheme = null;
        try {
            versioningScheme = FileScanner.loadVersioningScheme(rules.getElementRules());
        }
        catch (ConfigItemNotFoundException e) {
            LOGGER.log(Level.WARNING, "Versioning Scheme could not be loaded.", e);
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "RuleSet appears to be null", e);
        }
        LinkedList<File> dirs = new LinkedList<File>();
        URLClassLoader ucl = RuntimeConfig.getInstance().getClassLoader() instanceof URLClassLoader ? (URLClassLoader)RuntimeConfig.getInstance().getClassLoader() : (URLClassLoader)RuntimeConfig.getInstance().getClassLoader().getParent();
        URL[] urls = ucl.getURLs();
        try {
            URL urlTargetClass = RuntimeConfig.getInstance().isTest() ? Paths.get("target/test-classes", new String[0]).toUri().toURL() : Paths.get("target/classes", new String[0]).toUri().toURL();
            String path = urlTargetClass.toString();
            this.addStringToSootPath(path);
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Could not find target/classes folder");
        }
        for (URL url : urls) {
            LinkedList files;
            if (Pattern.compile(".*target/classes.*").matcher(url.toString()).find() || Pattern.compile(".*target/test-classes.*").matcher(url.toString()).find()) {
                String sootPathCurrent = url.toString();
                this.addStringToSootPath(sootPathCurrent);
            }
            if (!url.getFile().contains("target/classes")) continue;
            File f = new File(url.getFile());
            if (!isDirectory && f.exists()) {
                files = (LinkedList)FileUtils.listFiles((File)f, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                this.addResources(files);
                continue;
            }
            files = (LinkedList)FileUtils.listFilesAndDirs((File)f, (IOFileFilter)DirectoryFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            dirs.addAll(this.findLastDir(files));
        }
        scanner.setBasedir(basedir);
        scanner.setIncludes(new String[]{"**/*.dmn"});
        scanner.scan();
        this.decisionRefToPathMap = FileScanner.createDmnKeyToPathMap(new HashSet<String>(Arrays.asList(scanner.getIncludedFiles())));
        if (rules.getElementRules().get(VersioningChecker.class.getSimpleName()) != null && (rule = rules.getElementRules().get(VersioningChecker.class.getSimpleName()).get(VersioningChecker.class.getSimpleName())) != null && rule.isActive()) {
            if (versioningScheme != null && !isDirectory) {
                scanner.setIncludes(new String[]{"**/*.groovy"});
                scanner.scan();
                this.includedFiles.addAll(Arrays.asList(scanner.getIncludedFiles()));
                this.resourcesNewestVersions = FileScanner.createResourcesToNewestVersions(this.includedFiles, versioningScheme);
            } else {
                for (File file : dirs) {
                    this.includedFiles.add(file.getAbsolutePath());
                }
                this.resourcesNewestVersions = FileScanner.createDirectoriesToNewestVersions(this.includedFiles, versioningScheme);
            }
        }
    }

    private void addStringToSootPath(String sootPathCurrent) {
        if (sootPathCurrent != null) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                sootPathCurrent = sootPathCurrent.replace("file:/", "");
                if (!sootPaths.contains(sootPathCurrent = sootPathCurrent.replace("/./", "\\\\").replaceAll("/$", ""))) {
                    sootPaths.add(sootPathCurrent);
                }
            } else {
                sootPathCurrent = sootPathCurrent.replace("file:", "");
                if (!sootPaths.contains(sootPathCurrent = sootPathCurrent.replace("/./", "\\\\").replaceAll("/$", ""))) {
                    sootPaths.add(sootPathCurrent);
                }
            }
        }
    }

    private LinkedList<File> findLastDir(LinkedList<File> list) {
        LinkedList<File> returnList = new LinkedList<File>(list);
        for (File f : list) {
            File[] fileArr;
            if (f.isFile()) {
                returnList.remove(f);
            }
            for (File uF : fileArr = f.listFiles()) {
                if (!uF.isDirectory()) continue;
                returnList.remove(f);
            }
        }
        return returnList;
    }

    private void addResources(LinkedList<File> classes) {
        for (File file : classes) {
            this.includedFiles.add(file.getName());
        }
    }

    Set<String> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public Map<String, String> getProcessIdToPathMap() {
        return this.processIdToPathMap;
    }

    public Map<String, String> getDecisionRefToPathMap() {
        return this.decisionRefToPathMap;
    }

    public Collection<String> getResourcesNewestVersions() {
        return this.resourcesNewestVersions;
    }

    private static Map<String, String> createProcessIdToPathMap(Set<String> paths) {
        HashMap<String, String> keyToPathMap = new HashMap<String, String>();
        for (String path : paths) {
            Collection processes;
            BpmnModelInstance modelInstance;
            File bpmnfile = null;
            String basepath = ConfigConstants.getInstance().getBasepath();
            if (basepath.startsWith("file:/")) {
                try {
                    bpmnfile = new File(new URI(ConfigConstants.getInstance().getBasepath() + path));
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "URI of basedirectory seems to be malformed.", e);
                }
            } else {
                bpmnfile = new File(basepath + path);
            }
            try {
                modelInstance = Bpmn.readModelFromFile(bpmnfile);
            }
            catch (BpmnModelException ex) {
                throw new RuntimeException("bpmn model couldn't be read", ex);
            }
            if (modelInstance == null || (processes = modelInstance.getModelElementsByType(Process.class)) == null) continue;
            for (Process process : processes) {
                keyToPathMap.put(process.getId(), path);
            }
        }
        return keyToPathMap;
    }

    private static Map<String, String> createDmnKeyToPathMap(Set<String> paths) {
        HashMap<String, String> keyToPathMap = new HashMap<String, String>();
        for (String path : paths) {
            Collection decisions;
            DmnModelInstance modelInstance;
            try {
                modelInstance = Dmn.readModelFromFile((File)new File(ConfigConstants.getInstance().getBasepath() + path));
            }
            catch (DmnModelException ex) {
                throw new RuntimeException("dmn model couldn't be read", ex);
            }
            if (modelInstance == null || (decisions = modelInstance.getModelElementsByType(Decision.class)) == null) continue;
            for (Decision decision : decisions) {
                keyToPathMap.put(decision.getId(), path);
            }
        }
        return keyToPathMap;
    }

    private static Collection<String> createDirectoriesToNewestVersions(Set<String> versionedFiles, String versioningSchema) {
        HashMap<String, String> newestVersionsPathMap = new HashMap<String, String>();
        HashMap<String, String> newestVersionsMap = new HashMap<String, String>();
        if (versionedFiles != null && versioningSchema != null) {
            for (String versionedFile : versionedFiles) {
                Pattern pattern = Pattern.compile(versioningSchema);
                Matcher matcher = pattern.matcher(versionedFile);
                while (matcher.find()) {
                    String temp = matcher.group(0).contains(File.separator) ? versionedFile.replace(matcher.group(0).substring(matcher.group(0).lastIndexOf(File.separator)), "") : versionedFile.replace(matcher.group(0), "");
                    String value = versionedFile.substring(versionedFile.lastIndexOf("classes") + 8);
                    String resource = temp.substring(temp.lastIndexOf("classes") + 8);
                    String oldVersion = (String)newestVersionsMap.get(resource);
                    if (oldVersion != null) {
                        if (oldVersion.compareTo(matcher.group(0)) >= 0) continue;
                        newestVersionsMap.put(resource, matcher.group(0));
                        newestVersionsPathMap.put(resource, value);
                        continue;
                    }
                    newestVersionsMap.put(resource, matcher.group(0));
                    newestVersionsPathMap.put(resource, value);
                }
            }
        }
        return newestVersionsPathMap.values();
    }

    private static Collection<String> createResourcesToNewestVersions(Set<String> versionedFiles, String versioningSchema) {
        HashMap<String, String> newestVersionsMap = new HashMap<String, String>();
        if (versionedFiles != null) {
            for (String versionedFile : versionedFiles) {
                Pattern pattern = Pattern.compile(versioningSchema);
                Matcher matcher = pattern.matcher(versionedFile);
                while (matcher.find()) {
                    String resource = matcher.group(1);
                    String oldVersion = (String)newestVersionsMap.get(resource);
                    if (oldVersion != null) {
                        if (oldVersion.compareTo(versionedFile) >= 0) continue;
                        newestVersionsMap.put(resource, versionedFile);
                        continue;
                    }
                    newestVersionsMap.put(resource, versionedFile);
                }
            }
        }
        return newestVersionsMap.values();
    }

    private static String loadVersioningScheme(Map<String, Map<String, Rule>> rules) throws ConfigItemNotFoundException {
        Rule rule;
        if (rules.get(VersioningChecker.class.getSimpleName()) != null && (rule = rules.get(VersioningChecker.class.getSimpleName()).get(VersioningChecker.class.getSimpleName())) != null && rule.isActive()) {
            Setting setting = null;
            Map<String, Setting> settings = rule.getSettings();
            if (settings.containsKey("versioningSchemeClass") && !settings.containsKey("versioningSchemePackage")) {
                setting = settings.get("versioningSchemeClass");
                isDirectory = false;
            } else if (!settings.containsKey("versioningSchemeClass") && settings.containsKey("versioningSchemePackage")) {
                setting = settings.get("versioningSchemePackage");
                isDirectory = true;
            }
            if (setting == null) {
                throw new ConfigItemNotFoundException("VersioningChecker: Versioning Scheme could not be read. Possible options: versioningSchemeClass or versioningSchemePackage");
            }
            scheme = setting.getValue().trim();
        }
        return scheme;
    }

    public static String getVersioningScheme() {
        return scheme;
    }

    public Set<String> getJavaResourcesFileInputStream() {
        return resourcesFileInputStream;
    }

    public void setJavaResourcesFileInputStream(Set<String> javaResources) {
        resourcesFileInputStream = javaResources;
    }

    public static boolean getIsDirectory() {
        return isDirectory;
    }

    public static void setIsDirectory(boolean isDirectory) {
        FileScanner.isDirectory = isDirectory;
    }

    public static String getSootPath() {
        for (String entry : sootPaths) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                sootPath.append(entry);
                sootPath.append(";");
                continue;
            }
            sootPath.append(entry);
            sootPath.append(":");
        }
        return sootPath.toString().substring(0, sootPath.toString().length() - 1);
    }

    public void setScanPath(String scanPath) {
        this.scanPath = scanPath;
    }
}

