/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.dataflow;

import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.dataflow.DescribedPredicateEvaluator;
import de.viadee.bpm.vPAV.processing.dataflow.EvaluationResult;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SimpleDataFlowRule
implements DataFlowRule {
    private static final String RULE_VIOLATION_DESCRIPTION_TEMPLATE = "Rule '%s' was violated %s times%s:\n";
    private static final String RULE_DESCRIPTION_TEMPLATE = "Process variables%s should be %s%s";
    private static final String VIOLATION_TEMPLATE = "'%s' needed to be %s%s";
    private final DescribedPredicateEvaluator<ProcessVariable> constraint;
    private final DescribedPredicateEvaluator<ProcessVariable> condition;
    private String reason;
    private CriticalityEnum criticality = CriticalityEnum.ERROR;

    SimpleDataFlowRule(DescribedPredicateEvaluator<ProcessVariable> constraint, DescribedPredicateEvaluator<ProcessVariable> condition) {
        this.constraint = constraint;
        this.condition = condition;
    }

    @Override
    public Collection<EvaluationResult<ProcessVariable>> evaluate(Collection<ProcessVariable> variables) {
        Stream<ProcessVariable> variableStream = variables.stream();
        if (this.constraint != null) {
            variableStream = variableStream.filter(p -> this.constraint.evaluate((ProcessVariable)p).isFulfilled());
        }
        List<EvaluationResult<ProcessVariable>> results = variableStream.map(this.condition::evaluate).collect(Collectors.toList());
        return results;
    }

    @Override
    public void check(Collection<ProcessVariable> variables) {
        this.assertNoViolations(this.evaluate(variables));
    }

    private void assertNoViolations(Collection<EvaluationResult<ProcessVariable>> result) {
        List violations = result.stream().filter(r -> !r.isFulfilled()).collect(Collectors.toList());
        if (violations.size() > 0) {
            String ruleDescription = this.createRuleDescriptionMessage(violations.size());
            String violationsString = violations.stream().map(this::getViolationMessageFor).collect(Collectors.joining("\n"));
            throw new AssertionError((Object)(ruleDescription + violationsString));
        }
    }

    @Override
    public String getRuleDescription() {
        String constraintDescription = this.constraint != null ? " that are " + this.constraint.getDescription() : "";
        String reasonMessage = this.reason != null ? " because " + this.reason : "";
        return String.format(RULE_DESCRIPTION_TEMPLATE, constraintDescription, this.condition.getDescription(), reasonMessage);
    }

    @Override
    public CriticalityEnum getCriticality() {
        return this.criticality;
    }

    @Override
    public DataFlowRule because(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public DataFlowRule withCriticality(CriticalityEnum criticality) {
        this.criticality = criticality;
        return this;
    }

    private String createRuleDescriptionMessage(int violationCount) {
        String criticalityMessage = this.criticality != null ? " [Criticality: " + (Object)((Object)this.criticality) + "]" : "";
        return String.format(RULE_VIOLATION_DESCRIPTION_TEMPLATE, this.getRuleDescription(), violationCount, criticalityMessage);
    }

    @Override
    public String getViolationMessageFor(EvaluationResult<ProcessVariable> result) {
        String violationMessage = result.getMessage().isPresent() ? " but was " + result.getMessage().get() : "";
        return String.format(VIOLATION_TEMPLATE, result.getEvaluatedVariable().getName(), this.condition.getDescription(), violationMessage);
    }
}

