/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.ProcessingException;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.ExclusiveGateway;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XorConventionChecker
extends AbstractElementChecker {
    public XorConventionChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        String xor_gateway;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        Map<String, Setting> settings = this.rule.getSettings();
        if (bpmnElement instanceof ExclusiveGateway && this.bpmnScanner.getOutgoing(xor_gateway = this.bpmnScanner.getXorGateWays(bpmnElement.getId())) > 1) {
            ArrayList elementConventions;
            if (settings != null && settings.containsKey("requiredDefault") && settings.get("requiredDefault").getValue().equals("true") && bpmnElement.getAttributeValue("default") == null) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("XorConventionChecker.1"), CheckName.checkName(bpmnElement))));
            }
            if ((elementConventions = (ArrayList)this.rule.getElementConventions()) == null) {
                throw new ProcessingException("xor naming convention checker must have one element convention!");
            }
            String patternString = ((ElementConvention)elementConventions.get(0)).getPattern().trim();
            String taskName = bpmnElement.getAttributeValue("name");
            if (taskName != null && taskName.trim().length() > 0) {
                String taskNameClean;
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(taskNameClean = taskName.replaceAll("\n", "").replaceAll("\r", ""));
                if (!matcher.matches()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("XorConventionChecker.7"), CheckName.checkName(bpmnElement)), ((ElementConvention)elementConventions.get(0)).getDescription()));
                }
            } else {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, Messages.getString("XorConventionChecker.8")));
            }
            ArrayList<Node> edges = this.bpmnScanner.getOutgoingEdges(bpmnElement.getId());
            String patternStringEdge = ((ElementConvention)elementConventions.get(1)).getPattern().trim();
            for (int i = 0; i < edges.size(); ++i) {
                Element Task_Element = (Element)edges.get(i);
                String edgeName = Task_Element.getAttribute("name");
                if (edgeName != null && edgeName.trim().length() > 0) {
                    String edgeNameClean;
                    Pattern pattern = Pattern.compile(patternStringEdge);
                    Matcher matcher = pattern.matcher(edgeNameClean = edgeName.replaceAll("\n", "").replaceAll("\r", ""));
                    if (matcher.matches()) continue;
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("XorConventionChecker.13"), CheckName.checkName(bpmnElement)), ((ElementConvention)elementConventions.get(1)).getDescription()));
                    continue;
                }
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, Messages.getString("XorConventionChecker.14")));
            }
        }
        return issues;
    }
}

