/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.ProcessingException;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.el.ELException;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;

public class VersioningChecker
extends AbstractElementChecker {
    private Collection<String> resourcesNewestVersions;

    public VersioningChecker(Rule rule, BpmnScanner bpmnScanner, Collection<String> resourcesNewestVersions) {
        super(rule, bpmnScanner);
        this.resourcesNewestVersions = resourcesNewestVersions;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        issues.addAll(this.checkCommonTasks(element));
        issues.addAll(this.checkScriptTask(element));
        ExtensionElements extensionElements = baseElement.getExtensionElements();
        if (extensionElements != null) {
            issues.addAll(this.checkExecutionListener(element, extensionElements));
            issues.addAll(this.checkTaskListener(element, extensionElements));
        }
        issues.addAll(this.checkMessageEventDefinition(element));
        return issues;
    }

    private Collection<CheckerIssue> checkExecutionListener(BpmnElement element, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List execListenerList = extensionElements.getElementsQuery().filterByType(CamundaExecutionListener.class).list();
        for (CamundaExecutionListener listener : execListenerList) {
            CamundaScript script;
            String javaReference;
            String l_delegateExpression;
            String l_expression = listener.getCamundaExpression();
            if (l_expression != null) {
                this.prepareBeanWarning(l_expression, element, issues);
            }
            if ((l_delegateExpression = listener.getCamundaDelegateExpression()) != null) {
                this.prepareBeanWarning(l_delegateExpression, element, issues);
            }
            if ((javaReference = this.getClassReference(listener.getCamundaClass())) != null) {
                this.prepareClassWarning(javaReference, element, issues);
            }
            if ((script = listener.getCamundaScript()) == null || script.getCamundaScriptFormat() == null || !script.getCamundaScriptFormat().equals("groovy")) continue;
            String resourcePath = this.getGroovyReference(script.getCamundaResource());
            this.prepareScriptWarning(resourcePath, element, issues);
        }
        return issues;
    }

    private Collection<CheckerIssue> checkTaskListener(BpmnElement element, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List taskListenerList = extensionElements.getElementsQuery().filterByType(CamundaTaskListener.class).list();
        for (CamundaTaskListener listener : taskListenerList) {
            CamundaScript script;
            String javaReference;
            String l_delegateExpression;
            String l_expression = listener.getCamundaExpression();
            if (l_expression != null) {
                this.prepareBeanWarning(l_expression, element, issues);
            }
            if ((l_delegateExpression = listener.getCamundaDelegateExpression()) != null) {
                this.prepareBeanWarning(l_delegateExpression, element, issues);
            }
            if ((javaReference = this.getClassReference(listener.getCamundaClass())) != null) {
                this.prepareClassWarning(javaReference, element, issues);
            }
            if ((script = listener.getCamundaScript()) == null || script.getCamundaScriptFormat() == null || !script.getCamundaScriptFormat().equals("groovy")) continue;
            String resourcePath = this.getGroovyReference(script.getCamundaResource());
            this.prepareScriptWarning(resourcePath, element, issues);
        }
        return issues;
    }

    private Collection<CheckerIssue> checkCommonTasks(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof ServiceTask || baseElement instanceof SendTask || baseElement instanceof BusinessRuleTask) {
            String t_delegateExpression;
            String t_expression = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "expression");
            if (t_expression != null) {
                this.prepareBeanWarning(t_expression, element, issues);
            }
            if ((t_delegateExpression = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "delegateExpression")) != null && !FileScanner.getIsDirectory()) {
                this.prepareBeanWarning(t_delegateExpression, element, issues);
            } else if (t_delegateExpression != null && FileScanner.getIsDirectory()) {
                this.prepareDirBasedBeanWarning(t_delegateExpression, element, issues);
            }
            String javaReference = baseElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class");
            if (this.getClassReference(javaReference) != null && !FileScanner.getIsDirectory()) {
                this.prepareClassWarning(this.getClassReference(javaReference), element, issues);
            } else if (javaReference != null && FileScanner.getIsDirectory()) {
                this.prepareDirBasedClassWarning(javaReference, element, issues);
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkScriptTask(BpmnElement element) {
        ScriptTask scriptTask;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof ScriptTask && (scriptTask = (ScriptTask)baseElement).getScriptFormat() != null && scriptTask.getScriptFormat().equals("groovy")) {
            String resourcePath = scriptTask.getCamundaResource();
            resourcePath = this.getGroovyReference(resourcePath);
            this.prepareScriptWarning(resourcePath, element, issues);
        }
        return issues;
    }

    private Collection<CheckerIssue> checkMessageEventDefinition(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof MessageEventDefinition) {
            String e_delegateExpression;
            String e_expression;
            MessageEventDefinition eventDef = (MessageEventDefinition)baseElement;
            String javaReference = this.getClassReference(eventDef.getCamundaClass());
            if (javaReference != null) {
                this.prepareClassWarning(javaReference, element, issues);
            }
            if ((e_expression = eventDef.getCamundaExpression()) != null) {
                this.prepareBeanWarning(e_expression, element, issues);
            }
            if ((e_delegateExpression = eventDef.getCamundaDelegateExpression()) != null) {
                this.prepareBeanWarning(e_delegateExpression, element, issues);
            }
        }
        return issues;
    }

    private String getClassReference(String javaResource) {
        if (javaResource != null && !FileScanner.getIsDirectory()) {
            return javaResource.substring(javaResource.lastIndexOf(46) + 1, javaResource.length()) + ".class";
        }
        if (javaResource != null && FileScanner.getIsDirectory()) {
            return javaResource;
        }
        return null;
    }

    private String getGroovyReference(String resourcePath) {
        if (resourcePath != null) {
            resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf(46));
            return resourcePath.substring(resourcePath.lastIndexOf(46) + 1, resourcePath.length()) + ".groovy";
        }
        return null;
    }

    private String findBeanReferenceInExpression(String expression, BpmnElement element, Collection<CheckerIssue> issues) {
        try {
            String filteredExpression = expression.replaceAll("[\\w]+\\.", "");
            Builder treeBuilder = new Builder();
            Tree tree = treeBuilder.build(filteredExpression);
            Iterable identifierNodes = tree.getIdentifierNodes();
            HashSet<String> paths = new HashSet<String>();
            for (IdentifierNode node : identifierNodes) {
                String packagePath;
                if (RuntimeConfig.getInstance().getBeanMapping() == null || (packagePath = RuntimeConfig.getInstance().getBeanMapping().get(node.getName())) == null) continue;
                paths.add(packagePath);
            }
            if (!paths.isEmpty()) {
                return this.getClassReference((String)paths.iterator().next());
            }
        }
        catch (ELException e) {
            throw new ProcessingException("el expression " + expression + " in " + element.getProcessdefinition() + ", element ID: " + element.getBaseElement().getId() + " couldn't be parsed", e);
        }
        return null;
    }

    private void prepareScriptWarning(String resourcePath, BpmnElement element, Collection<CheckerIssue> issues) {
        if (resourcePath != null && !this.resourcesNewestVersions.contains(resourcePath)) {
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, resourcePath, element, Messages.getString("VersioningChecker.8")));
        }
    }

    private void prepareBeanWarning(String expression, BpmnElement element, Collection<CheckerIssue> issues) {
        String beanReference = this.findBeanReferenceInExpression(expression, element, issues);
        if (beanReference != null && !this.resourcesNewestVersions.contains(beanReference)) {
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, beanReference, element, String.format(Messages.getString("VersioningChecker.9"), beanReference, expression)));
        }
    }

    private void prepareDirBasedBeanWarning(String expression, BpmnElement element, Collection<CheckerIssue> issues) {
        String beanReference = this.findBeanReferenceInExpression(expression, element, issues);
        if (beanReference != null) {
            beanReference = beanReference.replace(".", "\\");
            beanReference = beanReference.substring(0, beanReference.lastIndexOf("\\"));
            if (!this.resourcesNewestVersions.contains(beanReference = beanReference.replace("\\", "/"))) {
                issues.add(IssueWriter.createIssueWithBeanRef(this.rule, CriticalityEnum.WARNING, element, beanReference, String.format(Messages.getString("VersioningChecker.13"), beanReference)));
            }
        }
    }

    private void prepareClassWarning(String javaReference, BpmnElement element, Collection<CheckerIssue> issues) {
        if (javaReference != null && !this.resourcesNewestVersions.contains(javaReference)) {
            if (element.getBaseElement().getId() == null) {
                issues.add(IssueWriter.createIssueWithJavaRef(this.rule, CriticalityEnum.WARNING, element, javaReference, String.format(Messages.getString("VersioningChecker.14"), javaReference)));
            } else {
                issues.add(IssueWriter.createIssueWithJavaRef(this.rule, CriticalityEnum.WARNING, element, javaReference, String.format(Messages.getString("VersioningChecker.14"), javaReference)));
            }
        }
    }

    private void prepareDirBasedClassWarning(String javaReference, BpmnElement element, Collection<CheckerIssue> issues) {
        if (javaReference != null) {
            javaReference = javaReference.replace(".", "\\");
            if (!this.resourcesNewestVersions.contains(javaReference = javaReference.substring(0, javaReference.lastIndexOf("\\")))) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, javaReference, element, String.format(Messages.getString("VersioningChecker.19"), javaReference)));
            }
        }
    }
}

