/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.checker.ModelChecker;
import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class ProcessVariablesModelChecker
implements ModelChecker {
    private final Rule rule;
    private final Map<AnomalyContainer, List<Path>> invalidPathsMap;

    public ProcessVariablesModelChecker(Rule rule, Map<AnomalyContainer, List<Path>> invalidPathsMap) {
        this.rule = rule;
        this.invalidPathsMap = invalidPathsMap;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnModelInstance processdefinition) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (AnomalyContainer anomaly : this.invalidPathsMap.keySet()) {
            List<Path> paths = this.invalidPathsMap.get(anomaly);
            ProcessVariableOperation var = anomaly.getVariable();
            if (paths == null) continue;
            if (anomaly.getAnomaly() == Anomaly.DD) {
                issues.addAll(IssueWriter.createIssue(this.rule, this.determineCriticality(anomaly.getAnomaly()), var, paths, anomaly, String.format(Messages.getString("ProcessVariablesModelChecker.0"), new Object[]{var.getName(), var.getElement().getBaseElement().getAttributeValue("name"), var.getChapter(), var.getFieldType().getDescription()})));
                continue;
            }
            if (anomaly.getAnomaly() == Anomaly.DU) {
                issues.addAll(IssueWriter.createIssue(this.rule, this.determineCriticality(anomaly.getAnomaly()), var, paths, anomaly, String.format(Messages.getString("ProcessVariablesModelChecker.1"), new Object[]{var.getName(), var.getElement().getBaseElement().getAttributeValue("name"), var.getChapter(), var.getFieldType().getDescription()})));
                continue;
            }
            if (anomaly.getAnomaly() != Anomaly.UR) continue;
            issues.addAll(IssueWriter.createIssue(this.rule, this.determineCriticality(anomaly.getAnomaly()), var, paths, anomaly, String.format(Messages.getString("ProcessVariablesModelChecker.2"), new Object[]{var.getName(), var.getElement().getBaseElement().getAttributeValue("name"), var.getChapter(), var.getFieldType().getDescription()})));
        }
        return issues;
    }

    private CriticalityEnum determineCriticality(Anomaly anomaly) {
        if (anomaly == Anomaly.DD || anomaly == Anomaly.DU) {
            return CriticalityEnum.WARNING;
        }
        return CriticalityEnum.ERROR;
    }
}

