/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.SubProcess;

public class NoScriptChecker
extends AbstractElementChecker {
    public NoScriptChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        if (!(bpmnElement instanceof Process || bpmnElement instanceof SubProcess || bpmnElement.getElementType().getInstanceType().getSimpleName().equals("Process") || bpmnElement.getElementType().getInstanceType().getSimpleName().equals("SubProcess"))) {
            Map<String, Setting> settings = this.rule.getSettings();
            ArrayList<String> scriptTypes = this.bpmnScanner.getScriptTypes(bpmnElement.getAttributeValue("id"));
            if (scriptTypes != null && !scriptTypes.isEmpty()) {
                if (!settings.containsKey(bpmnElement.getElementType().getInstanceType().getSimpleName())) {
                    for (String string : scriptTypes) {
                        issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("NoScriptChecker.0"), CheckName.checkName(bpmnElement), string)));
                    }
                } else {
                    ArrayList<String> allowedPlaces = settings.get(bpmnElement.getElementType().getInstanceType().getSimpleName()).getScriptPlaces();
                    if (!allowedPlaces.isEmpty()) {
                        for (String scriptType : scriptTypes) {
                            if (allowedPlaces.contains(scriptType)) continue;
                            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("NoScriptChecker.1"), CheckName.checkName(bpmnElement), scriptType)));
                        }
                    }
                }
            }
            if (bpmnElement instanceof ScriptTask && !settings.containsKey("ScriptTask")) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("NoScriptChecker.2"), CheckName.checkName(bpmnElement))));
            }
            if (bpmnElement instanceof SequenceFlow) {
                boolean scriptCondExp = this.bpmnScanner.hasScriptInCondExp(bpmnElement.getAttributeValue("id"));
                if (settings.containsKey("SequenceFlow")) {
                    ArrayList<String> arrayList = settings.get("SequenceFlow").getScriptPlaces();
                    if (!arrayList.isEmpty() && !arrayList.contains("conditionExpression") && scriptCondExp) {
                        issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("NoScriptChecker.3"), CheckName.checkName(bpmnElement))));
                    }
                } else if (scriptCondExp) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("NoScriptChecker.4"), CheckName.checkName(bpmnElement))));
                }
            }
        }
        return issues;
    }
}

