/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;

public class MessageEventChecker
extends AbstractElementChecker {
    public MessageEventChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement.getElementType().getTypeName().equals("endEvent") || baseElement.getElementType().getTypeName().equals("intermediateCatchEvent") || baseElement.getElementType().getTypeName().equals("intermediateThrowEvent") || baseElement.getElementType().getTypeName().equals("boundaryEvent")) {
            this.checkEventsInSubProcess(element, issues, baseElement);
        } else if (baseElement.getElementType().getTypeName().equals("receiveTask")) {
            if (baseElement.getAttributeValue("messageRef") == null || baseElement.getAttributeValue("messageRef").isEmpty()) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.0"), CheckName.checkName(baseElement))));
            } else if (this.bpmnScanner.getMessageName(baseElement.getAttributeValue("messageRef")) == null || this.bpmnScanner.getMessageName(baseElement.getAttributeValue("messageRef")).isEmpty()) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.1"), CheckName.checkName(baseElement))));
            }
        } else if (baseElement.getElementType().getTypeName().equals("startEvent")) {
            if (this.bpmnScanner.checkStartEvent(baseElement.getAttributeValue("id"))) {
                this.checkEventsInSubProcess(element, issues, baseElement);
            } else {
                this.checkEventsInProcess(element, issues, baseElement);
            }
        }
        return issues;
    }

    private void checkEventsInProcess(BpmnElement element, Collection<CheckerIssue> issues, BaseElement baseElement) {
        Event event = (Event)baseElement;
        Collection messageEventDefinitions = event.getChildElementsByType(MessageEventDefinition.class);
        if (messageEventDefinitions != null) {
            for (MessageEventDefinition eventDef : messageEventDefinitions) {
                if (eventDef == null) continue;
                Message message = eventDef.getMessage();
                if (message == null) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.2"), CheckName.checkName(baseElement))));
                    continue;
                }
                if (message.getName() == null || message.getName().isEmpty()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.3"), CheckName.checkName(baseElement))));
                    continue;
                }
                if (!message.getName().contains("{") && !message.getName().contains("}")) continue;
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.6"), CheckName.checkName(baseElement))));
            }
        }
    }

    private void checkEventsInSubProcess(BpmnElement element, Collection<CheckerIssue> issues, BaseElement baseElement) {
        Event event = (Event)baseElement;
        Collection messageEventDefinitions = event.getChildElementsByType(MessageEventDefinition.class);
        if (messageEventDefinitions != null) {
            for (MessageEventDefinition eventDef : messageEventDefinitions) {
                if (eventDef == null) continue;
                Message message = eventDef.getMessage();
                if (message == null) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.7"), CheckName.checkName(baseElement))));
                    continue;
                }
                if (message.getName() != null && !message.getName().isEmpty()) continue;
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("MessageEventChecker.8"), CheckName.checkName(baseElement))));
            }
        }
    }
}

