/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.UserTask;

public class JavaDelegateChecker
extends AbstractElementChecker {
    public JavaDelegateChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        String classFile;
        Iterable identifierNodes;
        Tree tree;
        Builder treeBuilder;
        String tempImp;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String implementationAttr = null;
        String implementation = null;
        ArrayList<String> executionDelegate = new ArrayList();
        ArrayList<String> executionClass = new ArrayList();
        ArrayList<String> executionExpression = new ArrayList();
        ArrayList<String> taskDelegate = new ArrayList();
        ArrayList<String> taskClass = new ArrayList();
        ArrayList<String> taskExpression = new ArrayList();
        if (bpmnElement instanceof ServiceTask || bpmnElement instanceof BusinessRuleTask || bpmnElement instanceof SendTask) {
            implementationAttr = this.bpmnScanner.getImplementation(bpmnElement.getId());
        }
        if (bpmnElement instanceof UserTask) {
            taskDelegate = this.bpmnScanner.getListener(bpmnElement.getId(), "delegateExpression", "camunda:taskListener");
            taskClass = this.bpmnScanner.getListener(bpmnElement.getId(), "class", "camunda:taskListener");
            taskExpression = this.bpmnScanner.getListener(bpmnElement.getId(), "expression", "camunda:taskListener");
        }
        if ((bpmnElement.getElementType().getTypeName().equals("intermediateThrowEvent") || bpmnElement.getElementType().getTypeName().equals("endEvent")) && (tempImp = this.bpmnScanner.getEventImplementation(bpmnElement.getId())) != null && tempImp.contains("=")) {
            implementationAttr = tempImp.substring(0, tempImp.indexOf("=")).trim();
            implementation = tempImp.substring(tempImp.indexOf("=") + 1, tempImp.length()).replace("\"", "").trim();
        }
        executionDelegate = this.bpmnScanner.getListener(bpmnElement.getId(), "delegateExpression", "camunda:executionListener");
        executionClass = this.bpmnScanner.getListener(bpmnElement.getId(), "class", "camunda:executionListener");
        executionExpression = this.bpmnScanner.getListener(bpmnElement.getId(), "expression", "camunda:executionListener");
        String classAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class");
        String delegateExprAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "delegateExpression");
        String exprAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "expression");
        String typeAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "type");
        String dmnAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "decisionRef");
        if (implementationAttr != null && (bpmnElement instanceof ServiceTask || bpmnElement instanceof BusinessRuleTask || bpmnElement instanceof SendTask)) {
            if (implementationAttr.equals("camunda:class")) {
                if (classAttr == null || classAttr.trim().length() == 0) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.5"), bpmnElement.getAttributeValue("name"))));
                } else {
                    issues.addAll(this.checkClassFile(element, classAttr, false, false));
                }
            } else if (implementationAttr.equals("camunda:delegateExpression")) {
                if (delegateExprAttr == null || delegateExprAttr.trim().length() == 0) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.6"), bpmnElement.getAttributeValue("name"))));
                } else if (RuntimeConfig.getInstance().getBeanMapping() != null) {
                    treeBuilder = new Builder();
                    tree = treeBuilder.build(delegateExprAttr);
                    identifierNodes = tree.getIdentifierNodes();
                    if (identifierNodes.iterator().hasNext()) {
                        for (IdentifierNode node : identifierNodes) {
                            classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                            if (classFile != null && classFile.trim().length() > 0) {
                                issues.addAll(this.checkClassFile(element, classFile, false, false));
                                continue;
                            }
                            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.7"), delegateExprAttr)));
                        }
                    } else {
                        issues.addAll(this.checkClassFile(element, delegateExprAttr, false, false));
                    }
                } else {
                    issues.addAll(this.checkClassFile(element, delegateExprAttr, false, false));
                }
            } else if (implementationAttr.equals("camunda:type")) {
                if (typeAttr == null || typeAttr.trim().length() == 0) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.8"), bpmnElement.getAttributeValue("name"))));
                }
            } else if (implementationAttr.equals("implementation") && dmnAttr == null && classAttr == null && delegateExprAttr == null && exprAttr == null && typeAttr == null) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.9"), CheckName.checkName(bpmnElement))));
            }
        }
        if (bpmnElement.getElementType().getTypeName().equals("intermediateThrowEvent") || bpmnElement.getElementType().getTypeName().equals("endEvent")) {
            if (implementationAttr != null && implementationAttr.equals("implementation")) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.10"), bpmnElement.getElementType().getTypeName(), bpmnElement.getAttributeValue("id"))));
            } else if (implementationAttr != null && implementationAttr.equals("camunda:delegateExpression")) {
                if (RuntimeConfig.getInstance().getBeanMapping() != null) {
                    treeBuilder = new Builder();
                    tree = treeBuilder.build(implementation);
                    identifierNodes = tree.getIdentifierNodes();
                    if (identifierNodes.iterator().hasNext()) {
                        for (IdentifierNode node : identifierNodes) {
                            classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                            if (classFile != null && classFile.trim().length() > 0) {
                                issues.addAll(this.checkClassFile(element, classFile, false, false));
                                continue;
                            }
                            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.11"), implementation)));
                        }
                    } else {
                        issues.addAll(this.checkClassFile(element, implementation, false, false));
                    }
                } else {
                    issues.addAll(this.checkClassFile(element, delegateExprAttr, false, false));
                }
            } else if (implementationAttr != null && implementationAttr.equals("camunda:class")) {
                issues.addAll(this.checkClassFile(element, implementation, false, false));
            }
        }
        if (executionClass != null || executionDelegate != null || executionExpression != null) {
            issues.addAll(this.checkListener(element, executionClass, executionDelegate, executionExpression, false));
        }
        if (taskClass != null || taskDelegate != null || taskExpression != null) {
            issues.addAll(this.checkListener(element, taskClass, taskDelegate, taskExpression, true));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkListener(BpmnElement element, ArrayList<String> aClass, ArrayList<String> aDelegate, ArrayList<String> aExpression, boolean taskListener) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        String location = "";
        location = taskListener ? "taskListener" : "taskListener";
        if (aClass == null || aClass.size() > 0) {
            for (String eClass : aClass) {
                if (eClass != null && eClass.trim().length() == 0) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.13"), location)));
                    continue;
                }
                if (eClass == null) continue;
                issues.addAll(this.checkClassFile(element, eClass, true, taskListener));
            }
        }
        if (aDelegate != null && aDelegate.size() > 0) {
            for (String eDel : aDelegate) {
                if (eDel == null || eDel.trim().length() == 0) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.14"), location)));
                    continue;
                }
                if (eDel == null) continue;
                if (RuntimeConfig.getInstance().getBeanMapping() != null) {
                    Builder treeBuilder = new Builder();
                    Tree tree = treeBuilder.build(eDel);
                    Iterable identifierNodes = tree.getIdentifierNodes();
                    if (identifierNodes.iterator().hasNext()) {
                        for (IdentifierNode node : identifierNodes) {
                            String classFile = RuntimeConfig.getInstance().getBeanMapping().get(node.getName());
                            if (classFile != null && classFile.trim().length() > 0) {
                                issues.addAll(this.checkClassFile(element, classFile, true, taskListener));
                                continue;
                            }
                            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("JavaDelegateChecker.15"), eDel, location)));
                        }
                        continue;
                    }
                    issues.addAll(this.checkClassFile(element, eDel, true, taskListener));
                    continue;
                }
                issues.addAll(this.checkClassFile(element, eDel, true, taskListener));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkClassFile(BpmnElement element, String className, boolean listener, boolean taskListener) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String classPath = className.replaceAll("\\.", "/") + ".java";
        String location = "";
        if (listener) {
            location = taskListener ? "taskListener" : "taskListener";
        }
        if (location.isEmpty()) {
            location = this.bpmnScanner.getImplementation(bpmnElement.getAttributeValue("id"));
        }
        try {
            Class<?> clazz = RuntimeConfig.getInstance().getClassLoader().loadClass(className);
            Class<?> sClass = clazz.getSuperclass();
            boolean extendsSuperClass = false;
            if (!listener && sClass.getName().contains("AbstractBpmnActivityBehavior")) {
                extendsSuperClass = true;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            boolean interfaceImplemented = false;
            for (Class<?> _interface : interfaces) {
                if (!listener) {
                    if (!_interface.getName().contains("JavaDelegate") && !_interface.getName().contains("SignallableActivityBehavior") && !_interface.getName().contains("ActivityBehavior")) continue;
                    interfaceImplemented = true;
                    if (!_interface.getName().contains("ActivityBehavior") || _interface.getName().contains("SignallableActivityBehavior")) continue;
                    issues.add(IssueWriter.createIssueWithClassPath(this.rule, CriticalityEnum.INFO, classPath, element, String.format(Messages.getString("JavaDelegateChecker.20"), clazz.getSimpleName(), location)));
                    continue;
                }
                if (taskListener && _interface.getName().contains("TaskListener")) {
                    interfaceImplemented = true;
                    continue;
                }
                if (!_interface.getName().contains("ExecutionListener") && !_interface.getName().contains("JavaDelegate")) continue;
                interfaceImplemented = true;
            }
            if (!interfaceImplemented && !extendsSuperClass) {
                issues.add(IssueWriter.createIssueWithClassPath(this.rule, CriticalityEnum.ERROR, classPath, element, String.format(Messages.getString("JavaDelegateChecker.21"), clazz.getSimpleName(), location)));
            }
        }
        catch (ClassNotFoundException e) {
            if (className == null || !className.isEmpty()) {
                issues.add(IssueWriter.createIssueWithClassPath(this.rule, CriticalityEnum.ERROR, classPath, element, String.format(Messages.getString("JavaDelegateChecker.22"), className.substring(className.lastIndexOf(46) + 1), location)));
            }
            issues.add(IssueWriter.createIssueWithClassPath(this.rule, CriticalityEnum.ERROR, classPath, element, String.format(Messages.getString("JavaDelegateChecker.23"), CheckName.checkName(bpmnElement))));
        }
        return issues;
    }
}

