/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.ElementConvention;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.model.bpmn.instance.BaseElement;

public class ElementIdConventionChecker
extends AbstractElementChecker {
    public ElementIdConventionChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        Collection<ElementConvention> elementConventions = this.rule.getElementConventions();
        String elementId = baseElement.getAttributeValue("id");
        if (elementConventions != null && !elementConventions.isEmpty() && elementId != null) {
            for (ElementConvention convention : elementConventions) {
                Pattern pattern = Pattern.compile(convention.getPattern().trim());
                Matcher matcher = pattern.matcher(elementId);
                String bpmnInstance = convention.getName();
                if (matcher.matches() || !baseElement.getElementType().getInstanceType().getSimpleName().toLowerCase().equals(bpmnInstance.toLowerCase())) continue;
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.WARNING, element, String.format(Messages.getString("ElementIdConventionChecker.0"), elementId), convention.getDescription()));
            }
        }
        return issues;
    }
}

