/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;

public class DmnTaskChecker
extends AbstractElementChecker {
    public DmnTaskChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        if (bpmnElement instanceof BusinessRuleTask) {
            String implementationAttr = this.bpmnScanner.getImplementation(bpmnElement.getId());
            String dmnAttr = bpmnElement.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "decisionRef");
            if (implementationAttr != null && implementationAttr.equals("camunda:decisionRef")) {
                if (dmnAttr == null || dmnAttr.trim().length() == 0) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("DmnTaskChecker.0"), CheckName.checkName(bpmnElement))));
                } else {
                    issues.addAll(this.checkDMNFile(element, dmnAttr));
                }
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkDMNFile(BpmnElement element, String dmnName) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        String dmnPath = dmnName.replaceAll("\\.", "/") + ".dmn";
        URL urlDMN = RuntimeConfig.getInstance().getClassLoader().getResource(dmnPath);
        if (urlDMN == null) {
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("DmnTaskChecker.4"), CheckName.checkName(bpmnElement))));
        }
        return issues;
    }
}

