/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.checker.ModelChecker;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.dataflow.EvaluationResult;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class DataFlowChecker
implements ModelChecker {
    private Rule rule;
    private Collection<DataFlowRule> dataFlowRules;
    private Collection<ProcessVariable> processVariables;

    public DataFlowChecker(Rule rule, Collection<DataFlowRule> dataFlowRules, Collection<ProcessVariable> processVariables) {
        this.rule = rule;
        this.dataFlowRules = dataFlowRules;
        this.processVariables = processVariables;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnModelInstance processdefinition) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (DataFlowRule dataFlowRule : this.dataFlowRules) {
            dataFlowRule.evaluate(this.processVariables).stream().filter(r -> !r.isFulfilled()).map(r -> IssueWriter.createIssue(this.rule, dataFlowRule.getRuleDescription(), dataFlowRule.getCriticality(), (ProcessVariable)r.getEvaluatedVariable(), dataFlowRule.getViolationMessageFor((EvaluationResult<ProcessVariable>)r))).forEach(issues::addAll);
        }
        return issues;
    }
}

