/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class CheckerFactory {
    private static final Logger LOGGER = Logger.getLogger(CheckerFactory.class.getName());
    private Map<String, String> incorrectCheckers = new HashMap<String, String>();

    public Collection<ElementChecker> createCheckerInstances(Map<String, Rule> ruleConf, Collection<String> resourcesNewestVersions, BpmnScanner bpmnScanner) {
        ArrayList<ElementChecker> checkers = new ArrayList<ElementChecker>();
        for (Map.Entry<String, Rule> rule : ruleConf.entrySet()) {
            String fullyQualifiedName = this.getFullyQualifiedName(rule);
            if (rule.getKey().equals("CreateOutputHTML") || fullyQualifiedName.isEmpty() || rule.getKey().equals("ProcessVariablesModelChecker") || rule.getKey().equals("DataFlowChecker")) continue;
            try {
                Constructor<?> c;
                Class<?> clazz;
                if (!rule.getKey().equals("VersioningChecker")) {
                    clazz = Class.forName(fullyQualifiedName);
                    c = clazz.getConstructor(Rule.class, BpmnScanner.class);
                    checkers.add((AbstractElementChecker)c.newInstance(rule.getValue(), bpmnScanner));
                    continue;
                }
                clazz = Class.forName(fullyQualifiedName);
                c = clazz.getConstructor(Rule.class, BpmnScanner.class, Collection.class);
                checkers.add((AbstractElementChecker)c.newInstance(rule.getValue(), bpmnScanner, resourcesNewestVersions));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.warning("Class " + fullyQualifiedName + " not found or couldn't be instantiated");
                rule.getValue().deactivate();
            }
        }
        return checkers;
    }

    private String getFullyQualifiedName(Map.Entry<String, Rule> rule) {
        String fullyQualifiedName = "";
        if (Arrays.asList(RuntimeConfig.getInstance().getViadeeRules()).contains(rule.getKey()) && rule.getValue().isActive()) {
            fullyQualifiedName = "de.viadee.bpm.vPAV.processing.checker." + rule.getValue().getName().trim();
        } else if (rule.getValue().isActive() && rule.getValue().getSettings() != null && rule.getValue().getSettings().containsKey("external_Location")) {
            fullyQualifiedName = rule.getValue().getSettings().get("external_Location").getValue() + "." + rule.getValue().getName().trim();
        }
        if (fullyQualifiedName.isEmpty() && rule.getValue().isActive()) {
            LOGGER.warning("Checker '" + rule.getValue().getName() + "' not found. Please add setting for external_location in ruleSet.xml.");
            rule.getValue().deactivate();
            this.setIncorrectCheckers(rule, String.format(Messages.getString("CheckerFactory.8"), rule.getValue().getName()));
        }
        return fullyQualifiedName;
    }

    public void setIncorrectCheckers(Map.Entry<String, Rule> rule, String message) {
        if (!this.getIncorrectCheckers().containsKey(rule.getValue().getName())) {
            this.incorrectCheckers.put(rule.getValue().getName(), message);
        }
    }

    public Map<String, String> getIncorrectCheckers() {
        return this.incorrectCheckers;
    }
}

