/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;

public class ResourceFileReader {
    public static final Logger LOGGER = Logger.getLogger(ResourceFileReader.class.getName());

    public static Map<String, ProcessVariableOperation> readResourceFile(String fileName, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        Map<String, ProcessVariableOperation> variables = new HashMap<String, ProcessVariableOperation>();
        if (fileName != null && fileName.trim().length() > 0) {
            try {
                DirectoryScanner directoryScanner = new DirectoryScanner();
                if (RuntimeConfig.getInstance().isTest()) {
                    if (fileName.endsWith(".java")) {
                        directoryScanner.setBasedir("src/test/java/");
                    } else {
                        directoryScanner.setBasedir("src/test/resources/");
                    }
                } else if (fileName.endsWith(".java")) {
                    directoryScanner.setBasedir("src/main/java/");
                } else {
                    directoryScanner.setBasedir("src/main/resources/");
                }
                Resource s = directoryScanner.getResource(fileName);
                if (s.isExists()) {
                    InputStreamReader resource = new InputStreamReader(new FileInputStream(s.toString()));
                    String methodBody = IOUtils.toString((Reader)resource);
                    variables = ResourceFileReader.searchProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, methodBody);
                } else {
                    LOGGER.warning("Class " + fileName + " does not exist");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("resource '" + fileName + "' could not be read: " + ex.getMessage());
            }
        }
        return variables;
    }

    public static Map<String, ProcessVariableOperation> searchProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariableOperation> variables = new HashMap<String, ProcessVariableOperation>();
        variables.putAll(ResourceFileReader.searchReadProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, code));
        variables.putAll(ResourceFileReader.searchWrittenProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, code));
        variables.putAll(ResourceFileReader.searchRemovedProcessVariablesInCode(element, chapter, fieldType, fileName, scopeId, code));
        return variables;
    }

    public static Map<String, ProcessVariableOperation> searchReadProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariableOperation> variables = new HashMap<String, ProcessVariableOperation>();
        String FILTER_PATTERN = "'|\"| ";
        String COMMENT_PATTERN = "//.*";
        String IMPORT_PATTERN = "import .*";
        String PACKAGE_PATTERN = "package .*";
        String cleanedCode = code.replaceAll("//.*", "").replaceAll("import .*", "").replaceAll("package .*", "").replaceAll("'|\"| ", "");
        Pattern getVariablePatternRuntimeService = Pattern.compile("\\.getVariable\\((.*),(\\w+)\\)");
        Matcher matcherRuntimeService = getVariablePatternRuntimeService.matcher(cleanedCode);
        while (matcherRuntimeService.find()) {
            String match = matcherRuntimeService.group(2);
            variables.put(match, new ProcessVariableOperation(match, element, chapter, fieldType, fileName, VariableOperation.READ, scopeId));
        }
        Pattern getVariablePatternDelegateExecution = Pattern.compile("\\.getVariable\\((\\w+)\\)");
        Matcher matcherDelegateExecution = getVariablePatternDelegateExecution.matcher(cleanedCode);
        while (matcherDelegateExecution.find()) {
            String match = matcherDelegateExecution.group(1);
            variables.put(match, new ProcessVariableOperation(match, element, chapter, fieldType, fileName, VariableOperation.READ, scopeId));
        }
        return variables;
    }

    public static Map<String, ProcessVariableOperation> searchWrittenProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariableOperation> variables = new HashMap<String, ProcessVariableOperation>();
        String FILTER_PATTERN = "'|\"| ";
        String COMMENT_PATTERN = "//.*";
        String IMPORT_PATTERN = "import .*";
        String PACKAGE_PATTERN = "package .*";
        String cleanedCode = code.replaceAll("//.*", "").replaceAll("import .*", "").replaceAll("package .*", "").replaceAll("'|\"| ", "");
        Pattern setVariablePatternRuntimeService = Pattern.compile("\\.setVariable\\((.*),(\\w+),(.*)\\)");
        Matcher matcherPatternRuntimeService = setVariablePatternRuntimeService.matcher(cleanedCode);
        while (matcherPatternRuntimeService.find()) {
            String match = matcherPatternRuntimeService.group(2);
            variables.put(match, new ProcessVariableOperation(match, element, chapter, fieldType, fileName, VariableOperation.WRITE, scopeId));
        }
        Pattern setVariablePatternDelegateExecution = Pattern.compile("\\.setVariable\\((\\w+),(.*)\\)");
        Matcher matcherPatternDelegateExecution = setVariablePatternDelegateExecution.matcher(cleanedCode);
        while (matcherPatternDelegateExecution.find()) {
            String match = matcherPatternDelegateExecution.group(1);
            variables.put(match, new ProcessVariableOperation(match, element, chapter, fieldType, fileName, VariableOperation.WRITE, scopeId));
        }
        return variables;
    }

    public static Map<String, ProcessVariableOperation> searchRemovedProcessVariablesInCode(BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String fileName, String scopeId, String code) {
        HashMap<String, ProcessVariableOperation> variables = new HashMap<String, ProcessVariableOperation>();
        String FILTER_PATTERN = "'|\"| ";
        String COMMENT_PATTERN = "//.*";
        String IMPORT_PATTERN = "import .*";
        String PACKAGE_PATTERN = "package .*";
        String cleanedCode = code.replaceAll("//.*", "").replaceAll("import .*", "").replaceAll("package .*", "").replaceAll("'|\"| ", "");
        Pattern removeVariablePatternRuntimeService = Pattern.compile("\\.removeVariable\\((.*),(\\w+)\\)");
        Matcher matcherRuntimeService = removeVariablePatternRuntimeService.matcher(cleanedCode);
        while (matcherRuntimeService.find()) {
            String match = matcherRuntimeService.group(2);
            variables.put(match, new ProcessVariableOperation(match, element, chapter, fieldType, fileName, VariableOperation.DELETE, scopeId));
        }
        Pattern removeVariablePatternDelegateExecution = Pattern.compile("\\.removeVariable\\((\\w+)\\)");
        Matcher matcherDelegateExecution = removeVariablePatternDelegateExecution.matcher(cleanedCode);
        while (matcherDelegateExecution.find()) {
            String match = matcherDelegateExecution.group(1);
            variables.put(match, new ProcessVariableOperation(match, element, chapter, fieldType, fileName, VariableOperation.DELETE, scopeId));
        }
        return variables;
    }
}

