/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.processing.JavaReader;
import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CamundaProcessVariableFunctions;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.OutSetCFG;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableBlock;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import soot.Body;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JInterfaceInvokeExpr;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.ClassicCompleteBlockGraph;

public class JavaReaderStatic
implements JavaReader {
    public static final Logger LOGGER = Logger.getLogger(JavaReaderStatic.class.getName());

    @Override
    public Map<String, ProcessVariableOperation> getVariablesFromJavaDelegate(String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        HashMap<String, ProcessVariableOperation> variables = new HashMap<String, ProcessVariableOperation>();
        if (classFile != null && classFile.trim().length() > 0) {
            String sootPath = FileScanner.getSootPath();
            System.setProperty("soot.class.path", sootPath);
            Set<String> classPaths = FileScanner.getJavaResourcesFileInputStream();
            String delegateMethodName = "execute";
            variables.putAll(this.classFetcher(classPaths, classFile, "execute", classFile, element, chapter, fieldType, scopeId));
        }
        return variables;
    }

    public Map<String, ProcessVariableOperation> classFetcher(Set<String> classPaths, String className, String methodName, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId) {
        HashMap<String, ProcessVariableOperation> processVariables = new HashMap<String, ProcessVariableOperation>();
        OutSetCFG outSet = new OutSetCFG(new ArrayList<VariableBlock>());
        this.classFetcherRecursive(classPaths, className, methodName, classFile, element, chapter, fieldType, scopeId, outSet, null);
        processVariables.putAll(outSet.getAllProcessVariables());
        try {
            this.addAnomaliesFoundInSourceCode(element, outSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processVariables;
    }

    public OutSetCFG classFetcherRecursive(Set<String> classPaths, String className, String methodName, String classFile, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String scopeId, OutSetCFG outSet, VariableBlock originalBlock) {
        className = System.getProperty("os.name").startsWith("Windows") ? className.replace("\\", ".").replace(".java", "") : className.replace("/", ".").replace(".java", "");
        Options.v().set_whole_program(true);
        Options.v().set_allow_phantom_refs(true);
        SootClass sootClass = Scene.v().forceResolve(className, 2);
        if (sootClass != null) {
            sootClass.setApplicationClass();
            Scene.v().loadNecessaryClasses();
            SootMethod method = sootClass.getMethodByNameUnsafe(methodName);
            if (method != null) {
                Body body = method.retrieveActiveBody();
                ClassicCompleteBlockGraph graph = new ClassicCompleteBlockGraph(body);
                ArrayList<SootMethod> entryPoints = new ArrayList<SootMethod>();
                entryPoints.add(method);
                Scene.v().setEntryPoints(entryPoints);
                PackManager.v().getPack("cg").apply();
                CallGraph cg = Scene.v().getCallGraph();
                List graphHeads = graph.getHeads();
                List graphTails = graph.getTails();
                for (Block head : graphHeads) {
                    outSet = this.graphIterator(classPaths, cg, (BlockGraph)graph, head, graphTails, outSet, element, chapter, fieldType, classFile, scopeId, originalBlock, className);
                }
            } else {
                LOGGER.warning("In class " + classFile + " - " + methodName + " method was not found by Soot");
            }
        } else {
            LOGGER.warning("Class " + classFile + " was not found by Soot");
        }
        return outSet;
    }

    private OutSetCFG graphIterator(Set<String> classPaths, CallGraph cg, BlockGraph graph, Block head, List<Block> blockTails, OutSetCFG outSet, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId, VariableBlock originalBlock, String oldClassName) {
        for (Block block : graph) {
            VariableBlock vb = this.blockIteraror(classPaths, cg, block, outSet, element, chapter, fieldType, filePath, scopeId, originalBlock, oldClassName);
            if (outSet.getVariableBlock(vb.getBlock()) != null) continue;
            outSet.addVariableBlock(vb);
        }
        return outSet;
    }

    private VariableBlock blockIteraror(Set<String> classPaths, CallGraph cg, Block block, OutSetCFG outSet, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId, VariableBlock variableBlock, String oldClassName) {
        if (variableBlock == null) {
            variableBlock = new VariableBlock(block, new ArrayList<ProcessVariableOperation>());
        }
        Iterator unitIt = block.iterator();
        while (unitIt.hasNext()) {
            JInterfaceInvokeExpr expr;
            Unit unit;
            if (cg != null & ((unit = (Unit)unitIt.next()) instanceof InvokeStmt || unit instanceof AssignStmt)) {
                JInterfaceInvokeExpr expr2;
                Iterator sources = cg.edgesOutOf(unit);
                while (sources.hasNext()) {
                    Edge src = (Edge)sources.next();
                    String methodName = src.tgt().getName();
                    String className = src.tgt().getDeclaringClass().getName();
                    if (className.equals(oldClassName) || !classPaths.contains(className = System.getProperty("os.name").startsWith("Windows") ? className.replace(".", "\\") + ".java" : className.replace(".", "/") + ".java")) continue;
                    G.reset();
                    this.classFetcherRecursive(classPaths, className, methodName, className, element, chapter, fieldType, scopeId, outSet, variableBlock);
                }
                if (unit instanceof InvokeStmt && ((InvokeStmt)unit).getInvokeExprBox().getValue() instanceof JInterfaceInvokeExpr && (expr2 = (JInterfaceInvokeExpr)((InvokeStmt)unit).getInvokeExprBox().getValue()) != null) {
                    this.parseExpression(expr2, variableBlock, element, chapter, fieldType, filePath, scopeId);
                }
            }
            if (!(unit instanceof AssignStmt) || !(((AssignStmt)unit).getRightOpBox().getValue() instanceof JInterfaceInvokeExpr) || (expr = (JInterfaceInvokeExpr)((AssignStmt)unit).getRightOpBox().getValue()) == null) continue;
            this.parseExpression(expr, variableBlock, element, chapter, fieldType, filePath, scopeId);
        }
        return variableBlock;
    }

    private void parseExpression(JInterfaceInvokeExpr expr, VariableBlock variableBlock, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String filePath, String scopeId) {
        String functionName = expr.getMethodRef().name();
        int numberOfArg = expr.getArgCount();
        String baseBox = expr.getBaseBox().getValue().getType().toString();
        CamundaProcessVariableFunctions foundMethod = CamundaProcessVariableFunctions.findByNameAndNumberOfBoxes(functionName, baseBox, numberOfArg);
        if (foundMethod != null) {
            int location = foundMethod.getLocation() - 1;
            VariableOperation type = foundMethod.getOperationType();
            if (expr.getArgBox(location).getValue() instanceof StringConstant) {
                StringConstant variableName = (StringConstant)expr.getArgBox(location).getValue();
                String name = variableName.value;
                variableBlock.addProcessVariable(new ProcessVariableOperation(name, element, chapter, fieldType, filePath, type, scopeId));
            }
        }
    }

    private void addAnomaliesFoundInSourceCode(BpmnElement element, OutSetCFG outSet) {
        for (VariableBlock vb : outSet.getAllVariableBlocks()) {
            if (vb.getBlock().getIndexInMethod() != 0) continue;
            this.addAnomaliesFoundInPathsRecursive(element, vb.getBlock(), new LinkedList<String>(), outSet, new LinkedList<ProcessVariableOperation>(), "");
        }
    }

    private void addAnomaliesFoundInPathsRecursive(BpmnElement element, Block currentBlock, LinkedList<String> currentPath, OutSetCFG outSet, LinkedList<ProcessVariableOperation> predecessorVaribalesList, String edge) {
        currentPath.add(edge);
        VariableBlock variableBlock = outSet.getVariableBlock(currentBlock);
        LinkedList<ProcessVariableOperation> usedVariables = new LinkedList<ProcessVariableOperation>();
        usedVariables.addAll(variableBlock.getAllProcessVariables());
        for (ProcessVariableOperation variable : usedVariables) {
            if (predecessorVaribalesList.lastIndexOf(variable) < 0) continue;
            ProcessVariableOperation lastApperance = predecessorVaribalesList.get(predecessorVaribalesList.lastIndexOf(variable));
            if (this.urSourceCode(lastApperance, variable)) {
                element.addSourceCodeAnomaly(new AnomalyContainer(variable.getName(), Anomaly.UR, element.getBaseElement().getId(), variable));
            }
            if (this.ddSourceCode(lastApperance, variable)) {
                element.addSourceCodeAnomaly(new AnomalyContainer(variable.getName(), Anomaly.DD, element.getBaseElement().getId(), variable));
            }
            if (!this.duSourceCode(lastApperance, variable)) continue;
            element.addSourceCodeAnomaly(new AnomalyContainer(variable.getName(), Anomaly.DU, element.getBaseElement().getId(), variable));
        }
        predecessorVaribalesList.addAll(usedVariables);
        List sucessors = currentBlock.getSuccs();
        for (Block sucessor : sucessors) {
            String newEdge = currentBlock.toShortString() + sucessor.toShortString();
            int occurance = Collections.frequency(currentPath, newEdge);
            if (occurance >= 2) continue;
            this.addAnomaliesFoundInPathsRecursive(element, sucessor, currentPath, outSet, predecessorVaribalesList, newEdge);
        }
        currentPath.removeLast();
        for (ProcessVariableOperation pv : variableBlock.getAllProcessVariables()) {
            predecessorVaribalesList.removeLastOccurrence(pv);
        }
    }

    private boolean urSourceCode(ProcessVariableOperation lastApperance, ProcessVariableOperation currentApperance) {
        return currentApperance.getOperation().equals((Object)VariableOperation.READ) && lastApperance.getOperation().equals((Object)VariableOperation.DELETE);
    }

    private boolean ddSourceCode(ProcessVariableOperation last, ProcessVariableOperation pv) {
        return pv.getOperation().equals((Object)VariableOperation.WRITE) && last.getOperation().equals((Object)VariableOperation.WRITE);
    }

    private boolean duSourceCode(ProcessVariableOperation last, ProcessVariableOperation pv) {
        return pv.getOperation().equals((Object)VariableOperation.DELETE) && last.getOperation().equals((Object)VariableOperation.WRITE);
    }
}

