/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.processing.ProcessVariableReader;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Edge;
import de.viadee.bpm.vPAV.processing.model.graph.Graph;
import de.viadee.bpm.vPAV.processing.model.graph.IGraph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BoundaryEvent;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.ParallelGateway;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaOut;

public class ElementGraphBuilder {
    private Map<String, BpmnElement> elementMap = new HashMap<String, BpmnElement>();
    private Map<String, String> processIdToPathMap;
    private Map<String, String> decisionRefToPathMap;
    private Map<String, Collection<String>> messageIdToVariables;
    private Map<String, Collection<String>> processIdToVariables;
    private BpmnScanner bpmnScanner;

    public ElementGraphBuilder(BpmnScanner bpmnScanner) {
        this.bpmnScanner = bpmnScanner;
    }

    public ElementGraphBuilder(Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Map<String, Collection<String>> messageIdToVariables, Map<String, Collection<String>> processIdToVariables, BpmnScanner bpmnScanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.processIdToPathMap = processIdToPathMap;
        this.messageIdToVariables = messageIdToVariables;
        this.processIdToVariables = processIdToVariables;
        this.bpmnScanner = bpmnScanner;
    }

    public ElementGraphBuilder(Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, BpmnScanner bpmnScanner) {
        this.decisionRefToPathMap = decisionRefToPathMap;
        this.processIdToPathMap = processIdToPathMap;
        this.bpmnScanner = bpmnScanner;
    }

    public Collection<IGraph> createProcessGraph(BpmnModelInstance modelInstance, String processdefinition, Collection<String> calledElementHierarchy) {
        ArrayList<IGraph> graphCollection = new ArrayList<IGraph>();
        Collection processes = modelInstance.getModelElementsByType(Process.class);
        for (Process process : processes) {
            Graph graph = new Graph(process.getId());
            Collection elements = process.getFlowElements();
            ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
            ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
            ArrayList<SubProcess> subProcesses = new ArrayList<SubProcess>();
            ArrayList<CallActivity> callActivities = new ArrayList<CallActivity>();
            for (FlowElement element : elements) {
                if (element instanceof SequenceFlow) {
                    SequenceFlow flow = (SequenceFlow)element;
                    flows.add(flow);
                } else if (element instanceof BoundaryEvent) {
                    BoundaryEvent event = (BoundaryEvent)element;
                    boundaryEvents.add(event);
                } else if (element instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)element;
                    callActivities.add(callActivity);
                } else if (element instanceof SubProcess) {
                    SubProcess subprocess = (SubProcess)element;
                    this.addElementsSubprocess(subProcesses, flows, boundaryEvents, graph, subprocess, processdefinition);
                }
                BpmnElement node = new BpmnElement(processdefinition, (BaseElement)element);
                Map<String, ProcessVariableOperation> variables = new ProcessVariableReader(this.decisionRefToPathMap, this.bpmnScanner).getVariablesFromElement(node);
                node.setProcessVariables(variables);
                this.elementMap.put(element.getId(), node);
                if (element.getElementType().getBaseType().getBaseType().getTypeName().equals("event")) {
                    this.addProcessVariablesForMessageName(element, node);
                }
                if (element.getElementType().getTypeName().equals("startEvent")) {
                    String processId = node.getBaseElement().getParentElement().getAttributeValue("id");
                    this.addProcessVariablesByStartForProcessId(node, processId);
                    graph.addStartNode(node);
                }
                if (element.getElementType().getTypeName().equals("endEvent")) {
                    graph.addEndNode(node);
                }
                graph.addVertex(node);
            }
            this.addEdges(processdefinition, graph, flows, boundaryEvents, subProcesses);
            for (CallActivity callActivity : callActivities) {
                this.integrateCallActivityFlow(processdefinition, modelInstance, callActivity, graph, calledElementHierarchy);
            }
            graphCollection.add(graph);
        }
        return graphCollection;
    }

    private void addProcessVariablesByStartForProcessId(BpmnElement node, String processId) {
        Collection<String> outerVariables;
        if (this.processIdToVariables != null && processId != null && (outerVariables = this.processIdToVariables.get(processId)) != null) {
            for (String varName : outerVariables) {
                node.setProcessVariable(varName, new ProcessVariableOperation(varName, node, ElementChapter.OutstandingVariable, KnownElementFieldType.Class, null, VariableOperation.WRITE, ""));
            }
        }
    }

    private void addProcessVariablesForMessageName(FlowElement element, BpmnElement node) {
        Event event;
        Collection messageEventDefinitions;
        if (this.messageIdToVariables != null && element instanceof Event && (messageEventDefinitions = (event = (Event)element).getChildElementsByType(MessageEventDefinition.class)) != null) {
            for (MessageEventDefinition eventDef : messageEventDefinitions) {
                String messageName;
                Collection<String> outerVariables;
                Message message;
                if (eventDef == null || (message = eventDef.getMessage()) == null || (outerVariables = this.messageIdToVariables.get(messageName = message.getName())) == null) continue;
                for (String varName : outerVariables) {
                    node.setProcessVariable(varName, new ProcessVariableOperation(varName, node, ElementChapter.OutstandingVariable, KnownElementFieldType.Class, null, VariableOperation.WRITE, ""));
                }
            }
        }
    }

    public BpmnElement getElement(String id) {
        return this.elementMap.get(id);
    }

    public Map<AnomalyContainer, List<Path>> createInvalidPaths(Collection<IGraph> graphCollection) {
        HashMap<AnomalyContainer, List<Path>> invalidPathMap = new HashMap<AnomalyContainer, List<Path>>();
        for (IGraph g : graphCollection) {
            g.setAnomalyInformation(g.getStartNodes().iterator().next());
            Map<BpmnElement, List<AnomalyContainer>> anomalies = g.getNodesWithAnomalies();
            for (BpmnElement element : anomalies.keySet()) {
                for (AnomalyContainer anomaly : anomalies.get(element)) {
                    List<Path> paths = g.getAllInvalidPaths(element, anomaly);
                    for (Path path : paths) {
                        Collections.reverse(path.getElements());
                    }
                    invalidPathMap.put(anomaly, new ArrayList<Path>(paths));
                }
            }
        }
        return invalidPathMap;
    }

    private void addEdges(String processdefinition, IGraph graph, Collection<SequenceFlow> flows, Collection<BoundaryEvent> boundaryEvents, Collection<SubProcess> subProcesses) {
        for (SequenceFlow flow : flows) {
            BpmnElement flowElement = this.elementMap.get(flow.getId());
            BpmnElement srcElement = this.elementMap.get(flow.getSource().getId());
            BpmnElement destElement = this.elementMap.get(flow.getTarget().getId());
            graph.addEdge(srcElement, flowElement, 100);
            graph.addEdge(flowElement, destElement, 100);
        }
        for (BoundaryEvent event : boundaryEvents) {
            BpmnElement dstElement = this.elementMap.get(event.getId());
            Activity source = event.getAttachedTo();
            BpmnElement srcElement = this.elementMap.get(source.getId());
            graph.addEdge(srcElement, dstElement, 100);
        }
        for (SubProcess subProcess : subProcesses) {
            BpmnElement subprocessElement = this.elementMap.get(subProcess.getId());
            Collection startEvents = subProcess.getChildElementsByType(StartEvent.class);
            Collection endEvents = subProcess.getChildElementsByType(EndEvent.class);
            if (startEvents == null || startEvents.size() <= 0 || endEvents == null || endEvents.size() <= 0) continue;
            Collection incomingFlows = subProcess.getIncoming();
            for (SequenceFlow incomingFlow : incomingFlows) {
                BpmnElement srcElement = this.elementMap.get(incomingFlow.getId());
                for (StartEvent startEvent : startEvents) {
                    BpmnElement dstElement = this.elementMap.get(startEvent.getId());
                    graph.addEdge(srcElement, dstElement, 100);
                    graph.removeEdge(srcElement, subprocessElement);
                }
            }
            Collection outgoingFlows = subProcess.getOutgoing();
            for (EndEvent endEvent : endEvents) {
                BpmnElement srcElement = this.elementMap.get(endEvent.getId());
                for (SequenceFlow outgoingFlow : outgoingFlows) {
                    BpmnElement dstElement = this.elementMap.get(outgoingFlow.getId());
                    graph.addEdge(srcElement, dstElement, 100);
                    graph.removeEdge(subprocessElement, dstElement);
                }
            }
        }
    }

    private void addElementsSubprocess(Collection<SubProcess> subProcesses, Collection<SequenceFlow> flows, Collection<BoundaryEvent> events, IGraph graph, SubProcess process, String processdefinitionPath) {
        subProcesses.add(process);
        Collection subElements = process.getFlowElements();
        for (FlowElement subElement : subElements) {
            if (subElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)subElement;
                this.addElementsSubprocess(subProcesses, flows, events, graph, subProcess, processdefinitionPath);
            } else if (subElement instanceof SequenceFlow) {
                SequenceFlow flow = (SequenceFlow)subElement;
                flows.add(flow);
            } else if (subElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)subElement;
                events.add(boundaryEvent);
            }
            BpmnElement node = new BpmnElement(processdefinitionPath, (BaseElement)subElement);
            Map<String, ProcessVariableOperation> variables = new ProcessVariableReader(this.decisionRefToPathMap, this.bpmnScanner).getVariablesFromElement(node);
            node.setProcessVariables(variables);
            this.elementMap.put(subElement.getId(), node);
            graph.addVertex(node);
        }
    }

    private void integrateCallActivityFlow(String processdefinition, BpmnModelInstance modelInstance, CallActivity callActivity, IGraph graph, Collection<String> calledElementHierarchy) {
        String calledElement = callActivity.getCalledElement();
        if (calledElementHierarchy.contains(calledElement)) {
            throw new RuntimeException("call activity hierarchy causes a deadlock (see " + processdefinition + ", " + callActivity.getId() + "). please avoid loops.");
        }
        calledElementHierarchy.add(calledElement);
        if (this.processIdToPathMap != null && this.processIdToPathMap.get(calledElement) != null) {
            ArrayList<String> inVariables = new ArrayList<String>();
            ArrayList<String> outVariables = new ArrayList<String>();
            this.readCallActivityDataInterfaces(callActivity, inVariables, outVariables);
            List<BpmnElement> parallelGateways = this.addParallelGatewaysBeforeAndAfterCallActivityInMainDataFlow(modelInstance, callActivity, graph);
            BpmnElement parallelGateway1 = parallelGateways.get(0);
            BpmnElement parallelGateway2 = parallelGateways.get(1);
            String callActivityPath = this.processIdToPathMap.get(calledElement);
            if (callActivityPath != null) {
                Collection<IGraph> subgraphs = this.createSubDataFlowsFromCallActivity(RuntimeConfig.getInstance().getClassLoader(), calledElementHierarchy, callActivityPath);
                for (IGraph subgraph : subgraphs) {
                    if (!subgraph.getProcessId().equals(calledElement)) continue;
                    this.connectParallelGatewaysWithSubDataFlow(graph, inVariables, outVariables, parallelGateway1, parallelGateway2, subgraph);
                }
            }
        }
    }

    private List<BpmnElement> addParallelGatewaysBeforeAndAfterCallActivityInMainDataFlow(BpmnModelInstance modelInstance, CallActivity callActivity, IGraph graph) {
        ParallelGateway element1 = (ParallelGateway)modelInstance.newInstance(ParallelGateway.class);
        element1.setAttributeValue("id", "_gw_in", true);
        ParallelGateway element2 = (ParallelGateway)modelInstance.newInstance(ParallelGateway.class);
        element2.setAttributeValue("id", "_gw_out", true);
        ArrayList<BpmnElement> elements = new ArrayList<BpmnElement>();
        BpmnElement parallelGateway1 = new BpmnElement(null, (BaseElement)element1);
        BpmnElement parallelGateway2 = new BpmnElement(null, (BaseElement)element2);
        elements.add(parallelGateway1);
        elements.add(parallelGateway2);
        graph.addVertex(parallelGateway1);
        graph.addVertex(parallelGateway2);
        this.connectParallelGatewaysWithMainDataFlow(callActivity, graph, parallelGateway1, parallelGateway2);
        return elements;
    }

    private void connectParallelGatewaysWithSubDataFlow(IGraph graph, Collection<String> inVariables, Collection<String> outVariables, BpmnElement parallelGateway1, BpmnElement parallelGateway2, IGraph subgraph) {
        Collection<BpmnElement> vertices = subgraph.getVertices();
        for (BpmnElement bpmnElement : vertices) {
            BaseElement baseElement = bpmnElement.getBaseElement();
            baseElement.setId("_" + baseElement.getId());
            graph.addVertex(bpmnElement);
        }
        Collection<List<Edge>> edges = subgraph.getEdges();
        for (List<Edge> list : edges) {
            for (Edge edge : list) {
                BpmnElement from = edge.getFrom();
                BpmnElement to = edge.getTo();
                graph.addEdge(from, to, 100);
            }
        }
        Collection<BpmnElement> collection = subgraph.getStartNodes();
        for (BpmnElement startNode : collection) {
            startNode.setInCa(inVariables);
            graph.addEdge(parallelGateway1, startNode, 100);
        }
        Collection<BpmnElement> collection2 = subgraph.getEndNodes();
        for (BpmnElement endNode : collection2) {
            endNode.setOutCa(outVariables);
            graph.addEdge(endNode, parallelGateway2, 100);
        }
    }

    private Collection<IGraph> createSubDataFlowsFromCallActivity(ClassLoader classLoader, Collection<String> calledElementHierarchy, String callActivityPath) {
        BpmnModelInstance submodel = Bpmn.readModelFromFile((File)new File(callActivityPath));
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(this.decisionRefToPathMap, this.processIdToPathMap, this.messageIdToVariables, this.processIdToVariables, this.bpmnScanner);
        Collection<IGraph> subgraphs = graphBuilder.createProcessGraph(submodel, callActivityPath, calledElementHierarchy);
        return subgraphs;
    }

    private void connectParallelGatewaysWithMainDataFlow(CallActivity callActivity, IGraph graph, BpmnElement parallelGateway1, BpmnElement parallelGateway2) {
        SequenceFlow incomingSequenceFlow = (SequenceFlow)callActivity.getIncoming().iterator().next();
        SequenceFlow outgoingSequenceFlow = (SequenceFlow)callActivity.getOutgoing().iterator().next();
        graph.removeEdge(this.elementMap.get(incomingSequenceFlow.getId()), this.elementMap.get(callActivity.getId()));
        graph.removeEdge(this.elementMap.get(callActivity.getId()), this.elementMap.get(outgoingSequenceFlow.getId()));
        graph.addEdge(this.elementMap.get(incomingSequenceFlow.getId()), parallelGateway1, 100);
        graph.addEdge(parallelGateway2, this.elementMap.get(outgoingSequenceFlow.getId()), 100);
        graph.addEdge(parallelGateway1, this.elementMap.get(callActivity.getId()), 100);
        graph.addEdge(this.elementMap.get(callActivity.getId()), parallelGateway2, 100);
    }

    private void readCallActivityDataInterfaces(CallActivity callActivity, Collection<String> inVariables, Collection<String> outVariables) {
        ExtensionElements extensionElements = callActivity.getExtensionElements();
        if (extensionElements != null) {
            List inputAssociations = extensionElements.getElementsQuery().filterByType(CamundaIn.class).list();
            for (CamundaIn inputAssociation : inputAssociations) {
                String source = inputAssociation.getCamundaSource();
                if (source == null || source.isEmpty()) continue;
                inVariables.add(source);
            }
            List outputAssociations = extensionElements.getElementsQuery().filterByType(CamundaOut.class).list();
            for (CamundaOut outputAssociation : outputAssociations) {
                String target = outputAssociation.getCamundaTarget();
                if (target == null || target.isEmpty()) continue;
                outVariables.add(target);
            }
        }
    }
}

