/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.checker.CheckerFactory;
import de.viadee.bpm.vPAV.processing.checker.DataFlowChecker;
import de.viadee.bpm.vPAV.processing.checker.ElementChecker;
import de.viadee.bpm.vPAV.processing.checker.ProcessVariablesModelChecker;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.ModelDispatchResult;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.IGraph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.xml.sax.SAXException;

public class BpmnModelDispatcher {
    private Map<String, String> incorrectCheckers = new HashMap<String, String>();

    public ModelDispatchResult dispatchWithVariables(File processdefinition, Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Map<String, Collection<String>> messageIdToVariables, Map<String, Collection<String>> processIdToVariables, Collection<DataFlowRule> dataFlowRules, Collection<String> resourcesNewestVersions, Map<String, Rule> conf) {
        Rule dataFlowRule;
        BpmnScanner bpmnScanner = this.createScanner(processdefinition);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processdefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, messageIdToVariables, processIdToVariables, bpmnScanner);
        Collection<IGraph> graphCollection = graphBuilder.createProcessGraph(modelInstance, processdefinition.getPath(), new ArrayList<String>());
        Map<AnomalyContainer, List<Path>> invalidPathMap = graphBuilder.createInvalidPaths(graphCollection);
        Collection<BpmnElement> bpmnElements = BpmnModelDispatcher.getBpmnElements(processdefinition, baseElements, graphBuilder);
        Collection<ProcessVariable> processVariables = BpmnModelDispatcher.getProcessVariables(bpmnElements);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Rule processVariablesModelRule = conf.get(this.getClassName(ProcessVariablesModelChecker.class));
        if (processVariablesModelRule != null && processVariablesModelRule.isActive()) {
            ProcessVariablesModelChecker processVarChecker = new ProcessVariablesModelChecker(processVariablesModelRule, invalidPathMap);
            issues.addAll(processVarChecker.check(modelInstance));
        }
        if ((dataFlowRule = conf.get(this.getClassName(DataFlowChecker.class))) != null && dataFlowRule.isActive() && !dataFlowRules.isEmpty()) {
            DataFlowChecker dataFlowChecker = new DataFlowChecker(dataFlowRule, dataFlowRules, processVariables);
            issues.addAll(dataFlowChecker.check(modelInstance));
        }
        Collection<ElementChecker> checkerInstances = this.createCheckerInstances(resourcesNewestVersions, conf, bpmnScanner, issues);
        this.executeCheckers(processdefinition, baseElements, graphBuilder, issues, checkerInstances);
        return new ModelDispatchResult(issues, bpmnElements, processVariables);
    }

    public ModelDispatchResult dispatchWithoutVariables(File processdefinition, Map<String, String> decisionRefToPathMap, Map<String, String> processIdToPathMap, Collection<String> resourcesNewestVersions, Map<String, Rule> conf) {
        BpmnScanner bpmnScanner = this.createScanner(processdefinition);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)processdefinition);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(decisionRefToPathMap, processIdToPathMap, bpmnScanner);
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        Collection<ElementChecker> checkerInstances = this.createCheckerInstances(resourcesNewestVersions, conf, bpmnScanner, issues);
        this.executeCheckers(processdefinition, baseElements, graphBuilder, issues, checkerInstances);
        return new ModelDispatchResult(issues, BpmnModelDispatcher.getBpmnElements(processdefinition, baseElements, graphBuilder), Collections.emptyList());
    }

    public static Collection<BpmnElement> getBpmnElements(File processdefinition, Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder) {
        ArrayList<BpmnElement> elements = new ArrayList<BpmnElement>();
        for (BaseElement baseElement : baseElements) {
            BpmnElement element = graphBuilder.getElement(baseElement.getId());
            if (element == null) {
                element = new BpmnElement(processdefinition.getPath(), baseElement);
            }
            elements.add(element);
        }
        return elements;
    }

    public static Collection<ProcessVariable> getProcessVariables(Collection<BpmnElement> elements) {
        HashMap<String, ProcessVariable> processVariables = new HashMap<String, ProcessVariable>();
        for (BpmnElement element : elements) {
            for (ProcessVariableOperation variableOperation : element.getProcessVariables().values()) {
                String variableName = variableOperation.getName();
                if (!processVariables.containsKey(variableName)) {
                    processVariables.put(variableName, new ProcessVariable(variableName));
                }
                ProcessVariable processVariable = (ProcessVariable)processVariables.get(variableName);
                switch (variableOperation.getOperation()) {
                    case READ: {
                        processVariable.addRead(variableOperation);
                        break;
                    }
                    case WRITE: {
                        processVariable.addWrite(variableOperation);
                        break;
                    }
                    case DELETE: {
                        processVariable.addDelete(variableOperation);
                    }
                }
            }
        }
        return processVariables.values();
    }

    private void executeCheckers(File processdefinition, Collection<BaseElement> baseElements, ElementGraphBuilder graphBuilder, Collection<CheckerIssue> issues, Collection<ElementChecker> checkerInstances) {
        for (BaseElement baseElement : baseElements) {
            BpmnElement element = graphBuilder.getElement(baseElement.getId());
            if (element == null) {
                element = new BpmnElement(processdefinition.getPath(), baseElement);
            }
            for (ElementChecker checker : checkerInstances) {
                issues.addAll(checker.check(element));
            }
        }
    }

    public BpmnScanner createScanner(File processdefinition) {
        BpmnScanner bpmnScanner;
        try {
            bpmnScanner = new BpmnScanner(processdefinition.getPath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Model couldn't be parsed");
        }
        return bpmnScanner;
    }

    private Collection<ElementChecker> createCheckerInstances(Collection<String> resourcesNewestVersions, Map<String, Rule> conf, BpmnScanner bpmnScanner, Collection<CheckerIssue> issues) {
        CheckerFactory checkerFactory = new CheckerFactory();
        Collection<ElementChecker> checkerCollection = checkerFactory.createCheckerInstances(conf, resourcesNewestVersions, bpmnScanner);
        this.setIncorrectCheckers(checkerFactory.getIncorrectCheckers());
        return checkerCollection;
    }

    private String getClassName(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public Map<String, String> getIncorrectCheckers() {
        return this.incorrectCheckers;
    }

    public void setIncorrectCheckers(Map<String, String> incorrectCheckers) {
        this.incorrectCheckers = incorrectCheckers;
    }
}

