/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.output;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.output.IssueOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;

public class JsOutputWriter
implements IssueOutputWriter {
    private static Logger logger = Logger.getLogger(JsOutputWriter.class.getName());
    private Map<String, String> ignoredIssuesMap = new HashMap<String, String>();
    private Map<String, String> wrongCheckersMap = new HashMap<String, String>();
    private Set<String> modelPaths = new HashSet<String>();

    @Override
    public void write(Collection<CheckerIssue> issues) throws OutputWriterException {
        String json = this.transformToJsonDatastructure(issues, "elementsToMark");
        String json_noIssues = this.transformToJsonDatastructure(this.getNoIssues(issues), "noIssuesElements");
        String bpmn = this.transformToXMLDatastructure();
        String wrongCheckers = this.transformToJsDatastructure(this.getWrongCheckersMap());
        String defaultCheckers = this.transformDefaultRulesToJsDatastructure(this.extractExternalCheckers(RuntimeConfig.getInstance().getActiveRules()));
        String issueSeverity = this.transformSeverityToJsDatastructure(this.createIssueSeverity(issues));
        String ignoredIssues = this.transformIgnoredIssuesToJsDatastructure(this.getIgnoredIssuesMap());
        this.writeJS(json, json_noIssues, bpmn, wrongCheckers, defaultCheckers, issueSeverity, ignoredIssues);
    }

    public void prepareMaps(Map<String, String> wrongCheckers, Map<String, String> ignoredIssues, Set<String> modelPath) {
        this.setWrongCheckersMap(wrongCheckers);
        this.setIgnoredIssuesMap(ignoredIssues);
        this.setModelPaths(modelPath);
    }

    private Map<String, CriticalityEnum> createIssueSeverity(Collection<CheckerIssue> issues) {
        HashMap<String, CriticalityEnum> issueSeverity = new HashMap<String, CriticalityEnum>();
        for (CheckerIssue issue : issues) {
            if (!issueSeverity.containsKey(issue.getElementId())) {
                issueSeverity.put(issue.getElementId(), issue.getClassification());
                continue;
            }
            if (!issueSeverity.containsKey(issue.getElementId()) || !((CriticalityEnum)((Object)issueSeverity.get(issue.getElementId()))).equals((Object)CriticalityEnum.WARNING) || !issue.getClassification().equals((Object)CriticalityEnum.ERROR)) continue;
            issueSeverity.put(issue.getElementId(), issue.getClassification());
        }
        return issueSeverity;
    }

    private ArrayList<String> extractExternalCheckers(ArrayList<String> activeRules) {
        ArrayList<String> defaultRules = new ArrayList<String>();
        for (String entry : RuntimeConfig.getInstance().getViadeeRules()) {
            if (!activeRules.contains(entry)) continue;
            defaultRules.add(entry);
        }
        return defaultRules;
    }

    private void writeJS(String json, String json_noIssues, String bpmn, String wrongCheckers, String defaultCheckers, String issueSeverity, String ignoredIssues) throws OutputWriterException {
        if (json != null && !json.isEmpty()) {
            try {
                FileWriter file = new FileWriter("target/vPAV/js/bpmn_model.js");
                file.write(bpmn);
                file.close();
                OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/bpmn_validation.js"), StandardCharsets.UTF_8);
                osWriter.write(json);
                osWriter.close();
                OutputStreamWriter osWriterSuccess = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/bpmn_validation_success.js"), StandardCharsets.UTF_8);
                osWriterSuccess.write(json_noIssues);
                osWriterSuccess.close();
                if (wrongCheckers != null && !wrongCheckers.isEmpty() && defaultCheckers != null && !defaultCheckers.isEmpty()) {
                    OutputStreamWriter wrongAndDefaultCheckers = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/checkers.js"), StandardCharsets.UTF_8);
                    wrongAndDefaultCheckers.write(wrongCheckers);
                    wrongAndDefaultCheckers.write(defaultCheckers);
                    wrongAndDefaultCheckers.close();
                } else if ((wrongCheckers == null || wrongCheckers.isEmpty()) && defaultCheckers != null && !defaultCheckers.isEmpty()) {
                    OutputStreamWriter defaultCheckerJS = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/checkers.js"), StandardCharsets.UTF_8);
                    defaultCheckerJS.write(defaultCheckers);
                    defaultCheckerJS.close();
                }
                if (issueSeverity != null && !issueSeverity.isEmpty()) {
                    OutputStreamWriter issueSeverityWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/issue_severity.js"), StandardCharsets.UTF_8);
                    issueSeverityWriter.write(issueSeverity);
                    issueSeverityWriter.close();
                }
                if (ignoredIssues != null && !ignoredIssues.isEmpty()) {
                    OutputStreamWriter ignoredIssuesWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("target/vPAV/js/ignoredIssues.js"), StandardCharsets.UTF_8);
                    ignoredIssuesWriter.write(ignoredIssues);
                    ignoredIssuesWriter.close();
                }
            }
            catch (IOException ex) {
                throw new OutputWriterException("js output couldn't be written", ex);
            }
        }
    }

    public void writeVars(Collection<BpmnElement> elements, Collection<ProcessVariable> processVariables) throws OutputWriterException {
        try {
            FileWriter writer = new FileWriter("target/vPAV/js/processVariables.js", true);
            JsonArray jsonElements = elements.stream().map(JsOutputWriter::transformElementToJsonIncludingProcessVariables).filter(o -> o.has("elementId")).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
            StringBuilder jsFile = new StringBuilder();
            jsFile.append("var proz_vars = ").append(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonElements)).append(";\n\n");
            JsonArray jsonVariables = processVariables.stream().map(JsOutputWriter::transformProcessVariablesToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
            jsFile.append("var processVariables = ").append(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonVariables)).append(";");
            writer.write(jsFile.toString());
            writer.close();
        }
        catch (IOException e) {
            logger.warning("Processvariables couldn't be written");
        }
    }

    private static JsonObject transformElementToJsonIncludingProcessVariables(BpmnElement element) {
        JsonObject obj = new JsonObject();
        if (!element.getProcessVariables().isEmpty()) {
            obj.addProperty("elementId", element.getBaseElement().getId());
            obj.addProperty("bpmnFile", JsOutputWriter.replace(File.separator, "\\", element.getProcessdefinition()));
            if (element.getBaseElement().getAttributeValue("name") != null) {
                obj.addProperty("elementName", element.getBaseElement().getAttributeValue("name"));
            }
            Function<ProcessVariableOperation, JsonObject> processVariableToJson = o -> {
                JsonObject jsonOperation = new JsonObject();
                jsonOperation.addProperty("name", o.getName());
                jsonOperation.addProperty("fieldType", o.getFieldType().getDescription());
                jsonOperation.addProperty("elementChapter", o.getChapter().toString());
                return jsonOperation;
            };
            obj.add("read", (JsonElement)element.getProcessVariables().values().stream().filter(o -> o.getOperation() == VariableOperation.READ).map(processVariableToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            obj.add("write", (JsonElement)element.getProcessVariables().values().stream().filter(o -> o.getOperation() == VariableOperation.WRITE).map(processVariableToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            obj.add("delete", (JsonElement)element.getProcessVariables().values().stream().filter(o -> o.getOperation() == VariableOperation.DELETE).map(processVariableToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        }
        return obj;
    }

    private static JsonObject transformProcessVariablesToJson(ProcessVariable processVariable) {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", processVariable.getName());
        if (processVariable.getOperations().size() > 0) {
            String bpmnFile = processVariable.getOperations().get(0).getElement().getProcessdefinition();
            obj.addProperty("bpmnFile", JsOutputWriter.replace(File.separator, "\\", bpmnFile));
        }
        Function<ProcessVariableOperation, JsonObject> processVariableToJson = o -> {
            JsonObject jsonOperation = new JsonObject();
            jsonOperation.addProperty("elementId", o.getElement().getBaseElement().getId());
            jsonOperation.addProperty("elementName", o.getElement().getBaseElement().getAttributeValue("name"));
            jsonOperation.addProperty("fieldType", o.getFieldType().getDescription());
            jsonOperation.addProperty("elementChapter", o.getChapter().toString());
            return jsonOperation;
        };
        obj.add("read", (JsonElement)processVariable.getReads().stream().map(processVariableToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        obj.add("write", (JsonElement)processVariable.getWrites().stream().map(processVariableToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        obj.add("delete", (JsonElement)processVariable.getDeletes().stream().map(processVariableToJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        return obj;
    }

    private Collection<CheckerIssue> getNoIssues(Collection<CheckerIssue> issues) {
        ArrayList<CheckerIssue> newIssues = new ArrayList<CheckerIssue>();
        for (String bpmnFilename : this.getModelPaths()) {
            ArrayList<CheckerIssue> modelIssues = new ArrayList<CheckerIssue>();
            modelIssues.addAll(issues);
            for (CheckerIssue issue : issues) {
                String prettyBpmnFilename = JsOutputWriter.replace(File.separator, "\\", issue.getBpmnFile());
                if (prettyBpmnFilename.equals("src\\main\\resources\\" + bpmnFilename)) continue;
                modelIssues.remove(issue);
            }
            for (String ruleName : RuntimeConfig.getInstance().getActiveRules()) {
                ArrayList<CheckerIssue> ruleIssues = new ArrayList<CheckerIssue>();
                ruleIssues.addAll(modelIssues);
                for (CheckerIssue issue : modelIssues) {
                    if (issue.getRuleName().equals(ruleName)) continue;
                    ruleIssues.remove(issue);
                }
                if (!ruleIssues.isEmpty()) continue;
                newIssues.add(new CheckerIssue(ruleName, null, CriticalityEnum.SUCCESS, "src\\main\\resources\\" + bpmnFilename, null, "", "", null, null, null, "No issues found", null));
            }
        }
        return newIssues;
    }

    private String transformToXMLDatastructure() throws OutputWriterException {
        String output = "var diagramXMLSource = [\n";
        try {
            for (String bpmnFilename : this.getModelPaths()) {
                String prettyBpmnFileName = JsOutputWriter.replace(File.separator, "\\\\", bpmnFilename);
                output = output + "{\"name\":\"" + prettyBpmnFileName + "\",\n \"xml\": \"";
                output = output + this.convertBpmnFile("src/main/resources/" + bpmnFilename);
                output = output + "\"},\n";
            }
        }
        catch (IOException e) {
            throw new OutputWriterException("bpmnFile not found");
        }
        return output + "];\n";
    }

    private static String replace(String search, String replace, String str) {
        int start = str.indexOf(search);
        while (start != -1) {
            str = str.substring(0, start) + replace + str.substring(start + search.length(), str.length());
            start = str.indexOf(search, start + replace.length());
        }
        return str;
    }

    private String convertBpmnFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        String s = new String(encoded);
        s = s.replace("\"", "\\\"");
        s = s.replace('\n', ' ');
        s = s.replace('\r', ' ');
        s = s.replaceAll(">\\u0020*<", "><");
        s = s.replaceAll(">\\u0027*<", "><");
        return s;
    }

    private String transformToJsonDatastructure(Collection<CheckerIssue> issues, String varName) {
        JsonArray jsonIssues = new JsonArray();
        if (issues != null && issues.size() > 0) {
            for (CheckerIssue issue : issues) {
                JsonObject obj = new JsonObject();
                obj.addProperty("id", issue.getId());
                obj.addProperty("bpmnFile", JsOutputWriter.replace(File.separator, "\\", issue.getBpmnFile()));
                obj.addProperty("ruleName", issue.getRuleName());
                obj.addProperty("ruleDescription", issue.getRuleDescription());
                obj.addProperty("elementId", issue.getElementId());
                obj.addProperty("elementName", issue.getElementName());
                obj.addProperty("classification", issue.getClassification().name());
                obj.addProperty("resourceFile", issue.getResourceFile());
                obj.addProperty("variable", issue.getVariable());
                obj.addProperty("anomaly", issue.getAnomaly() == null ? null : issue.getAnomaly().getDescription());
                JsonArray jsonPaths = new JsonArray();
                List<Path> paths = issue.getInvalidPaths();
                if (paths != null && paths.size() > 0) {
                    for (Path path : paths) {
                        JsonArray jsonPath = new JsonArray();
                        List<BpmnElement> elements = path.getElements();
                        for (BpmnElement element : elements) {
                            JsonObject jsonElement = new JsonObject();
                            String id = element.getBaseElement().getId();
                            String name = element.getBaseElement().getAttributeValue("name");
                            jsonElement.addProperty("elementId", id);
                            jsonElement.addProperty("elementName", name == null ? null : name.replaceAll("\n", ""));
                            jsonPath.add((JsonElement)jsonElement);
                        }
                        jsonPaths.add((JsonElement)jsonPath);
                    }
                }
                obj.add("paths", (JsonElement)jsonPaths);
                obj.addProperty("message", issue.getMessage());
                obj.addProperty("elementDescription", issue.getElementDescription());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "var " + varName + " = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    private String transformToJsDatastructure(Map<String, String> wrongCheckers) {
        String varName = "unlocatedCheckers";
        JsonArray jsonIssues = new JsonArray();
        if (wrongCheckers != null && wrongCheckers.size() > 0) {
            for (Map.Entry<String, String> entry : wrongCheckers.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("rulename", entry.getKey());
                obj.addProperty("message", entry.getValue());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "var unlocatedCheckers = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    private String transformSeverityToJsDatastructure(Map<String, CriticalityEnum> issues) {
        String varName = "issueSeverity";
        JsonArray jsonIssues = new JsonArray();
        if (issues != null && issues.size() > 0) {
            for (Map.Entry<String, CriticalityEnum> entry : issues.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("id", entry.getKey());
                obj.addProperty("Criticality", entry.getValue().name().toString());
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "var issueSeverity = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    private String transformIgnoredIssuesToJsDatastructure(Map<String, String> ignoredIssues) {
        String ignoredIssuesList = "ignoredIssues";
        JsonArray ignoredIssesJson = new JsonArray();
        if (ignoredIssues != null && ignoredIssues.size() > 0) {
            for (Map.Entry<String, String> entry : ignoredIssues.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("ID", entry.getKey());
                obj.addProperty("Comment", entry.getValue());
                ignoredIssesJson.add((JsonElement)obj);
            }
        }
        return "var ignoredIssues = " + new GsonBuilder().setPrettyPrinting().create().toJson(ignoredIssues) + ";";
    }

    private String transformDefaultRulesToJsDatastructure(ArrayList<String> defaultCheckers) {
        String varName = "defaultCheckers";
        JsonArray jsonIssues = new JsonArray();
        if (defaultCheckers != null && defaultCheckers.size() > 0) {
            for (String entry : defaultCheckers) {
                JsonObject obj = new JsonObject();
                obj.addProperty("rulename", entry);
                jsonIssues.add((JsonElement)obj);
            }
        }
        return "\n var defaultCheckers = " + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonIssues) + ";";
    }

    public Map<String, String> getIgnoredIssuesMap() {
        return this.ignoredIssuesMap;
    }

    public void setIgnoredIssuesMap(Map<String, String> ignoredIssuesMap) {
        this.ignoredIssuesMap = ignoredIssuesMap;
    }

    public Map<String, String> getWrongCheckersMap() {
        return this.wrongCheckersMap;
    }

    public void setWrongCheckersMap(Map<String, String> wrongCheckersMap) {
        this.wrongCheckersMap = wrongCheckersMap;
    }

    public Set<String> getModelPaths() {
        return this.modelPaths;
    }

    public void setModelPaths(Set<String> modelPaths) {
        this.modelPaths = modelPaths;
    }
}

