/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.OuterProcessVariablesScanner;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.config.model.Setting;
import de.viadee.bpm.vPAV.config.reader.ConfigReaderException;
import de.viadee.bpm.vPAV.config.reader.XmlConfigReader;
import de.viadee.bpm.vPAV.output.JsOutputWriter;
import de.viadee.bpm.vPAV.output.JsonOutputWriter;
import de.viadee.bpm.vPAV.output.OutputWriterException;
import de.viadee.bpm.vPAV.output.RuleSetOutputWriter;
import de.viadee.bpm.vPAV.output.XmlOutputWriter;
import de.viadee.bpm.vPAV.processing.BpmnModelDispatcher;
import de.viadee.bpm.vPAV.processing.dataflow.DataFlowRule;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.ModelDispatchResult;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Runner {
    private static Logger logger = Logger.getLogger(Runner.class.getName());
    private FileScanner fileScanner;
    private OuterProcessVariablesScanner variableScanner;
    private Collection<CheckerIssue> issues;
    private Collection<CheckerIssue> filteredIssues;
    private Map<String, Rule> rules = new HashMap<String, Rule>();
    private Map<String, String> ignoredIssuesMap = new HashMap<String, String>();
    private Map<String, String> fileMapping = this.createFileFolderMapping();
    private Map<String, String> wrongCheckersMap = new HashMap<String, String>();
    private ArrayList<String> allOutputFilesArray = this.createAllOutputFilesArray();
    private Collection<BpmnElement> elements = new ArrayList<BpmnElement>();
    private Collection<ProcessVariable> processVariables = new ArrayList<ProcessVariable>();
    private Collection<DataFlowRule> dataFlowRules = new ArrayList<DataFlowRule>();
    private boolean checkProcessVariables = false;
    private static boolean isStatic = false;

    public void viadeeProcessApplicationValidator(String javaScanPath) {
        this.processVariables = new ArrayList<ProcessVariable>();
        this.elements = new ArrayList<BpmnElement>();
        this.rules = this.readConfig();
        this.setFileScanner(new FileScanner(this.rules, javaScanPath));
        this.getProcessVariables(this.rules);
        this.createIssues(this.rules, this.dataFlowRules);
        this.removeIgnoredIssues();
        this.writeOutput(this.filteredIssues, this.elements, this.processVariables);
        this.copyFiles();
        logger.info("BPMN validation successfully completed");
    }

    private Map<String, Rule> readConfig() {
        this.prepareOutputFolder();
        this.rules = new XmlConfigReader().getDeactivatedRuleSet();
        RuleSetOutputWriter ruleSetOutputWriter = new RuleSetOutputWriter();
        try {
            if (new File("src/test/resources/ruleSet.xml").exists()) {
                Map<String, Rule> localRule = new XmlConfigReader().read("ruleSet.xml");
                if (localRule.containsKey("HasParentRuleSet") && localRule.get("HasParentRuleSet").isActive()) {
                    this.rules = this.mergeRuleSet(this.rules, new XmlConfigReader().read("parentRuleSet.xml"));
                    this.rules = this.mergeRuleSet(this.rules, localRule);
                } else {
                    this.rules = this.mergeRuleSet(this.rules, localRule);
                }
            } else {
                this.rules = new XmlConfigReader().read("ruleSetDefault.xml");
            }
            ruleSetOutputWriter.write(this.rules);
            RuntimeConfig.getInstance().addActiveRules(this.rules);
        }
        catch (ConfigReaderException | OutputWriterException e) {
            throw new RuntimeException(e);
        }
        this.rules.remove("HasParentRuleSet");
        try {
            RuntimeConfig.getInstance().retrieveLocale(this.rules);
        }
        catch (MalformedURLException e) {
            logger.warning("Could not read language files. No localization available");
        }
        Runner.setIsStatic(this.rules);
        return this.rules;
    }

    private void prepareOutputFolder() {
        this.deleteFiles();
        this.createvPAVFolder();
        try {
            Files.createDirectory(Paths.get("target/vPAV/js/", new String[0]), new FileAttribute[0]);
            Files.createDirectory(Paths.get("target/vPAV/css/", new String[0]), new FileAttribute[0]);
            Files.createDirectory(Paths.get("target/vPAV/img/", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.warning("Could not create either output folder for JS, CSS or IMG");
        }
    }

    private Map<String, Rule> mergeRuleSet(Map<String, Rule> parentRules, Map<String, Rule> childRules) {
        HashMap<String, Rule> finalRules = new HashMap<String, Rule>();
        finalRules.putAll(parentRules);
        finalRules.putAll(childRules);
        return finalRules;
    }

    private void getProcessVariables(Map<String, Rule> rules) {
        if (rules.get("ProcessVariablesModelChecker").isActive() || rules.get("ProcessVariablesNameConventionChecker").isActive() || rules.get("DataFlowChecker").isActive()) {
            this.getFileScanner();
            this.variableScanner = new OuterProcessVariablesScanner(FileScanner.getJavaResourcesFileInputStream());
            this.readOuterProcessVariables(this.variableScanner);
            this.setCheckProcessVariables(true);
        } else {
            this.setCheckProcessVariables(false);
        }
    }

    private void createIssues(Map<String, Rule> rules, Collection<DataFlowRule> dataFlowRules) throws RuntimeException {
        this.issues = this.checkModels(rules, this.getFileScanner(), this.variableScanner, dataFlowRules);
    }

    private void removeIgnoredIssues() throws RuntimeException {
        this.filteredIssues = this.filterIssues(this.issues);
    }

    private void writeOutput(Collection<CheckerIssue> filteredIssues, Collection<BpmnElement> elements, Collection<ProcessVariable> processVariables) throws RuntimeException {
        if (filteredIssues.size() > 0) {
            XmlOutputWriter xmlOutputWriter = new XmlOutputWriter();
            JsonOutputWriter jsonOutputWriter = new JsonOutputWriter();
            JsOutputWriter jsOutputWriter = new JsOutputWriter();
            try {
                jsOutputWriter.prepareMaps(this.getWrongCheckersMap(), this.getIgnoredIssuesMap(), this.getModelPath());
                xmlOutputWriter.write(filteredIssues);
                jsonOutputWriter.write(filteredIssues);
                jsOutputWriter.write(filteredIssues);
                jsOutputWriter.writeVars(elements, processVariables);
            }
            catch (OutputWriterException e) {
                throw new RuntimeException("Output couldn't be written", e);
            }
        }
        try {
            JsOutputWriter jsOutputWriter = new JsOutputWriter();
            jsOutputWriter.prepareMaps(this.getWrongCheckersMap(), this.getIgnoredIssuesMap(), this.getModelPath());
            jsOutputWriter.write(filteredIssues);
            jsOutputWriter.writeVars(elements, processVariables);
        }
        catch (OutputWriterException e) {
            throw new RuntimeException("JavaScript File couldn't be written", e);
        }
    }

    private void createvPAVFolder() {
        boolean success;
        File vPavDir = new File("target/vPAV/");
        if (!vPavDir.exists() && !(success = vPavDir.mkdirs())) {
            throw new RuntimeException("vPAV directory does not exist and could not be created");
        }
    }

    private void deleteFiles() {
        File index = new File("target/vPAV/");
        if (index.exists()) {
            String[] entries;
            for (String entry : entries = index.list()) {
                File currentFile = new File(index.getPath(), entry);
                if (currentFile.isDirectory()) {
                    String[] subEntries;
                    for (String subentry : subEntries = currentFile.list()) {
                        File file = new File(currentFile.getPath(), subentry);
                        file.delete();
                    }
                }
                currentFile.delete();
            }
        }
    }

    private void copyFiles() throws RuntimeException {
        ArrayList<Path> outputFiles = new ArrayList<Path>();
        for (String file : this.allOutputFilesArray) {
            outputFiles.add(Paths.get(this.fileMapping.get(file), file));
        }
        if (this.rules.get("CreateOutputHTML").isActive()) {
            for (String file : this.allOutputFilesArray) {
                this.copyFileToVPAVFolder(file);
            }
        }
    }

    private ArrayList<String> createAllOutputFilesArray() {
        ArrayList<String> allFiles = new ArrayList<String>();
        allFiles.add("bootstrap.min.js");
        allFiles.add("bpmn-navigated-viewer.js");
        allFiles.add("bpmn.io.viewer.app.js");
        allFiles.add("jquery-3.2.1.min.js");
        allFiles.add("popper.min.js");
        allFiles.add("infoPOM.js");
        allFiles.add("download.js");
        allFiles.add("bootstrap.min.css");
        allFiles.add("viadee.css");
        allFiles.add("MarkerStyle.css");
        allFiles.add("vPAV.png");
        allFiles.add("viadee_weiss.png");
        allFiles.add("GitHub.png");
        allFiles.add("error.png");
        allFiles.add("warning.png");
        allFiles.add("info.png");
        allFiles.add("success.png");
        allFiles.add("dl_button.png");
        allFiles.add("validationResult.html");
        return allFiles;
    }

    private Map<String, String> createFileFolderMapping() {
        HashMap<String, String> fMap = new HashMap<String, String>();
        fMap.put("bootstrap.min.js", "target/vPAV/js/");
        fMap.put("bpmn-navigated-viewer.js", "target/vPAV/js/");
        fMap.put("bpmn.io.viewer.app.js", "target/vPAV/js/");
        fMap.put("jquery-3.2.1.min.js", "target/vPAV/js/");
        fMap.put("popper.min.js", "target/vPAV/js/");
        fMap.put("infoPOM.js", "target/vPAV/js/");
        fMap.put("download.js", "target/vPAV/js/");
        fMap.put("bootstrap.min.css", "target/vPAV/css/");
        fMap.put("viadee.css", "target/vPAV/css/");
        fMap.put("MarkerStyle.css", "target/vPAV/css/");
        fMap.put("vPAV.png", "target/vPAV/img/");
        fMap.put("viadee_weiss.png", "target/vPAV/img/");
        fMap.put("GitHub.png", "target/vPAV/img/");
        fMap.put("error.png", "target/vPAV/img/");
        fMap.put("warning.png", "target/vPAV/img/");
        fMap.put("info.png", "target/vPAV/img/");
        fMap.put("success.png", "target/vPAV/img/");
        fMap.put("dl_button.png", "target/vPAV/img/");
        fMap.put("validationResult.html", "target/vPAV/");
        return fMap;
    }

    private void copyFileToVPAVFolder(String file) throws RuntimeException {
        InputStream source = Runner.class.getClassLoader().getResourceAsStream(file);
        Path destination = Paths.get(this.fileMapping.get(file) + file, new String[0]);
        try {
            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Files couldn't be written");
        }
    }

    private Collection<CheckerIssue> filterIssues(Collection<CheckerIssue> issues) throws RuntimeException {
        Collection<CheckerIssue> filteredIssues;
        try {
            filteredIssues = this.getFilteredIssues(issues);
        }
        catch (IOException e) {
            throw new RuntimeException("Ignored issues couldn't be read successfully", e);
        }
        Collections.sort((List)filteredIssues);
        return filteredIssues;
    }

    private Collection<CheckerIssue> getFilteredIssues(Collection<CheckerIssue> issues) throws IOException {
        HashMap<String, CheckerIssue> issuesMap = new HashMap<String, CheckerIssue>();
        for (CheckerIssue issue : issues) {
            if (issuesMap.containsKey(issue.getId())) continue;
            issuesMap.put(issue.getId(), issue);
        }
        Collection<String> ignoredIssues = this.collectIgnoredIssues("src/test/resources/ignoreIssues.txt");
        HashMap<String, CheckerIssue> filteredIssues = new HashMap<String, CheckerIssue>();
        filteredIssues.putAll(issuesMap);
        for (Map.Entry entry : issuesMap.entrySet()) {
            if (!ignoredIssues.contains(entry.getKey())) continue;
            filteredIssues.remove(entry.getKey());
        }
        ArrayList<CheckerIssue> finalFilteredIssues = new ArrayList<CheckerIssue>();
        for (Map.Entry entry : filteredIssues.entrySet()) {
            finalFilteredIssues.add((CheckerIssue)entry.getValue());
        }
        return finalFilteredIssues;
    }

    private Collection<String> collectIgnoredIssues(String filePath) throws IOException {
        Map<String, String> ignoredIssuesMap = this.getIgnoredIssuesMap();
        ArrayList<String> ignoredIssues = new ArrayList<String>();
        FileReader fileReader = this.createFileReader(filePath);
        if (fileReader != null) {
            String zeile;
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String prevLine = zeile = bufferedReader.readLine();
            while (zeile != null) {
                this.addIgnoredIssue(ignoredIssuesMap, ignoredIssues, zeile, prevLine);
                prevLine = zeile;
                zeile = bufferedReader.readLine();
            }
            bufferedReader.close();
            fileReader.close();
        }
        return ignoredIssues;
    }

    private FileReader createFileReader(String filePath) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader("src/test/resources/.ignoreIssues");
            if (fileReader != null) {
                logger.warning("Usage of .ignoreIssues is deprecated. Please use ignoreIssues.txt to whitelist issues.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            fileReader = new FileReader(filePath);
        }
        catch (FileNotFoundException ex) {
            logger.info(ex.getMessage());
        }
        return fileReader;
    }

    private Collection<CheckerIssue> checkModels(Map<String, Rule> rules, FileScanner fileScanner, OuterProcessVariablesScanner variableScanner, Collection<DataFlowRule> dataFlowRules) throws RuntimeException {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        for (String pathToModel : fileScanner.getProcessdefinitions()) {
            issues.addAll(this.checkModel(rules, pathToModel, fileScanner, variableScanner, dataFlowRules));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkModel(Map<String, Rule> rules, String processdef, FileScanner fileScanner, OuterProcessVariablesScanner variableScanner, Collection<DataFlowRule> dataFlowRules) {
        BpmnModelDispatcher bpmnModelDispatcher = new BpmnModelDispatcher();
        ModelDispatchResult dispatchResult = variableScanner != null ? bpmnModelDispatcher.dispatchWithVariables(new File("src/main/resources/" + processdef), fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), variableScanner.getMessageIdToVariableMap(), variableScanner.getProcessIdToVariableMap(), dataFlowRules, fileScanner.getResourcesNewestVersions(), rules) : bpmnModelDispatcher.dispatchWithoutVariables(new File("src/main/resources/" + processdef), fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), fileScanner.getResourcesNewestVersions(), rules);
        this.elements.addAll(dispatchResult.getBpmnElements());
        this.processVariables.addAll(dispatchResult.getProcessVariables());
        this.setWrongCheckersMap(bpmnModelDispatcher.getIncorrectCheckers());
        return dispatchResult.getIssues();
    }

    private void readOuterProcessVariables(OuterProcessVariablesScanner scanner) throws RuntimeException {
        try {
            scanner.scanProcessVariables();
        }
        catch (IOException e) {
            throw new RuntimeException("Outer process variables couldn't be read: " + e.getMessage());
        }
    }

    private Map<String, String> addIgnoredIssue(Map<String, String> ignoredIssuesMap, Collection<String> issues, String row, String prevLine) {
        if (row != null && !row.isEmpty() && !row.trim().startsWith("#")) {
            ignoredIssuesMap.put(row, prevLine);
            issues.add(row);
        }
        return ignoredIssuesMap;
    }

    private static boolean setIsStatic(Map<String, Rule> rules) {
        Setting setting;
        Rule rule = rules.get("ProcessVariablesModelChecker");
        if (rule != null && (setting = rule.getSettings().get("UseStaticAnalysisBoolean")) != null && setting.getValue().equals("true")) {
            isStatic = true;
        }
        return isStatic;
    }

    public Set<String> getModelPath() {
        return this.getFileScanner().getProcessdefinitions();
    }

    public Collection<CheckerIssue> getfilteredIssues() {
        return this.filteredIssues;
    }

    public Map<String, String> getIgnoredIssuesMap() {
        return this.ignoredIssuesMap;
    }

    public void setIgnoredIssuesMap(Map<String, String> ignoredIssuesMap) {
        this.ignoredIssuesMap = ignoredIssuesMap;
    }

    public boolean isCheckProcessVariables() {
        return this.checkProcessVariables;
    }

    public void setCheckProcessVariables(boolean checkProcessVariables) {
        this.checkProcessVariables = checkProcessVariables;
    }

    public void setDataFlowRules(Collection<DataFlowRule> dataFlowRules) {
        this.dataFlowRules = dataFlowRules;
    }

    public FileScanner getFileScanner() {
        return this.fileScanner;
    }

    public void setFileScanner(FileScanner fileScanner) {
        this.fileScanner = fileScanner;
    }

    public Map<String, String> getWrongCheckersMap() {
        return this.wrongCheckersMap;
    }

    public void setWrongCheckersMap(Map<String, String> wrongCheckersMap) {
        this.wrongCheckersMap = wrongCheckersMap;
    }

    public static boolean getIsStatic() {
        return isStatic;
    }
}

