/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.FileScanner;
import de.viadee.bpm.vPAV.OuterProcessVariablesScanner;
import de.viadee.bpm.vPAV.ProcessApplicationValidator;
import de.viadee.bpm.vPAV.RuntimeConfig;
import de.viadee.bpm.vPAV.beans.BeanMappingGenerator;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.processing.BpmnModelDispatcher;
import de.viadee.bpm.vPAV.processing.ElementGraphBuilder;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.graph.IGraph;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.springframework.context.ApplicationContext;
import org.xml.sax.SAXException;

public class ProcessApplicationVariableParser {
    public static Collection<ProcessVariable> parseProcessVariables(File modelFile, ApplicationContext ctx) {
        RuntimeConfig.getInstance().setApplicationContext(ctx);
        RuntimeConfig.getInstance().setBeanMapping(BeanMappingGenerator.generateBeanMappingFile(ctx));
        RuntimeConfig.getInstance().setClassLoader(ProcessApplicationValidator.class.getClassLoader());
        FileScanner fileScanner = new FileScanner(new HashMap<String, Rule>(), "src/main/java/");
        OuterProcessVariablesScanner variableScanner = ProcessApplicationVariableParser.readOuterProcessVariables(fileScanner);
        BpmnScanner bpmnScanner = ProcessApplicationVariableParser.createScanner(modelFile);
        BpmnModelInstance modelInstance = Bpmn.readModelFromFile((File)modelFile);
        Collection baseElements = modelInstance.getModelElementsByType(BaseElement.class);
        ElementGraphBuilder graphBuilder = new ElementGraphBuilder(fileScanner.getDecisionRefToPathMap(), fileScanner.getProcessIdToPathMap(), variableScanner.getMessageIdToVariableMap(), variableScanner.getProcessIdToVariableMap(), bpmnScanner);
        Collection<IGraph> graphCollection = graphBuilder.createProcessGraph(modelInstance, modelFile.getPath(), new ArrayList<String>());
        Map<AnomalyContainer, List<Path>> invalidPathMap = graphBuilder.createInvalidPaths(graphCollection);
        Collection<BpmnElement> bpmnElements = BpmnModelDispatcher.getBpmnElements(modelFile, baseElements, graphBuilder);
        return BpmnModelDispatcher.getProcessVariables(bpmnElements);
    }

    private static OuterProcessVariablesScanner readOuterProcessVariables(FileScanner fileScanner) throws RuntimeException {
        try {
            OuterProcessVariablesScanner variableScanner = new OuterProcessVariablesScanner(fileScanner.getJavaResourcesFileInputStream());
            variableScanner.scanProcessVariables();
            return variableScanner;
        }
        catch (IOException e) {
            throw new RuntimeException("Outer process variables couldn't be read", e);
        }
    }

    private static BpmnScanner createScanner(File processdefinition) {
        BpmnScanner bpmnScanner;
        try {
            bpmnScanner = new BpmnScanner(processdefinition.getPath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Model couldn't be parsed");
        }
        return bpmnScanner;
    }
}

