/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.AbstractRunner;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.Signal;
import org.camunda.bpm.model.bpmn.instance.SignalEventDefinition;

public class SignalEventChecker
extends AbstractElementChecker {
    private static SignalEventChecker instance;

    public SignalEventChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    public static SignalEventChecker getInstance(Rule rule, BpmnScanner bpmnScanner) {
        if (instance == null) {
            instance = new SignalEventChecker(rule, bpmnScanner);
        }
        return instance;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        Event event;
        Collection signalEventDefinitions;
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if ((baseElement.getElementType().getTypeName().equals("startEvent") || baseElement.getElementType().getTypeName().equals("endEvent") || baseElement.getElementType().getTypeName().equals("intermediateCatchEvent") || baseElement.getElementType().getTypeName().equals("intermediateThrowEvent") || baseElement.getElementType().getTypeName().equals("boundaryEvent")) && (signalEventDefinitions = (event = (Event)baseElement).getChildElementsByType(SignalEventDefinition.class)) != null) {
            for (SignalEventDefinition eventDef : signalEventDefinitions) {
                if (eventDef == null) continue;
                Signal signal = eventDef.getSignal();
                if (signal == null) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("SignalEventChecker.0"), CheckName.checkName(baseElement))));
                    continue;
                }
                if (signal.getName() == null || signal.getName().isEmpty()) {
                    issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("SignalEventChecker.1"), CheckName.checkName(baseElement))));
                    continue;
                }
                if (!baseElement.getElementType().getTypeName().equals("startEvent")) continue;
                issues.addAll(this.checkDoubleUsage(element, baseElement, signal));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkDoubleUsage(BpmnElement element, BaseElement baseElement, Signal signal) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        if (!AbstractRunner.addSignal(baseElement, signal.getName())) {
            issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("SignalEventChecker.2"), CheckName.checkName(baseElement), CheckName.checkName(AbstractRunner.getSignal(signal.getName())))));
        }
        return issues;
    }
}

