/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.AbstractRunner;
import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.CheckName;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;

public class OverlapChecker
extends AbstractElementChecker {
    private static OverlapChecker instance;

    public OverlapChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    public static OverlapChecker getInstance(Rule rule, BpmnScanner bpmnScanner) {
        if (instance == null) {
            instance = new OverlapChecker(rule, bpmnScanner);
        }
        return instance;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement bpmnElement = element.getBaseElement();
        if (bpmnElement instanceof SequenceFlow) {
            ArrayList<String> sequenceFlowDef = this.bpmnScanner.getSequenceFlowDef(bpmnElement.getId());
            if (AbstractRunner.getSequenceFlowList().isEmpty()) {
                AbstractRunner.addToSequenceFlowList(bpmnElement.getId(), sequenceFlowDef);
            }
            for (Map.Entry<String, ArrayList<String>> entry : AbstractRunner.getSequenceFlowList().entrySet()) {
                if (!sequenceFlowDef.equals(entry.getValue()) || bpmnElement.getId().equals(entry.getKey())) continue;
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, String.format(Messages.getString("OverlapChecker.0"), CheckName.checkName(bpmnElement))));
                return issues;
            }
            if (!AbstractRunner.getSequenceFlowList().containsKey(bpmnElement.getId())) {
                AbstractRunner.addToSequenceFlowList(bpmnElement.getId(), sequenceFlowDef);
            }
        }
        return issues;
    }
}

