/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.checker;

import de.viadee.bpm.vPAV.BpmnScanner;
import de.viadee.bpm.vPAV.Messages;
import de.viadee.bpm.vPAV.config.model.Rule;
import de.viadee.bpm.vPAV.output.IssueWriter;
import de.viadee.bpm.vPAV.processing.checker.AbstractElementChecker;
import de.viadee.bpm.vPAV.processing.model.data.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.CriticalityEnum;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Script;
import org.camunda.bpm.model.bpmn.instance.ScriptTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaScript;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.codehaus.groovy.control.CompilationFailedException;

public class EmbeddedGroovyScriptChecker
extends AbstractElementChecker {
    private static EmbeddedGroovyScriptChecker instance;

    public EmbeddedGroovyScriptChecker(Rule rule, BpmnScanner bpmnScanner) {
        super(rule, bpmnScanner);
    }

    public static EmbeddedGroovyScriptChecker getInstance(Rule rule, BpmnScanner bpmnScanner) {
        if (instance == null) {
            instance = new EmbeddedGroovyScriptChecker(rule, bpmnScanner);
        }
        return instance;
    }

    @Override
    public Collection<CheckerIssue> check(BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        issues.addAll(this.checkScriptTask(element.getProcessdefinition(), element));
        ExtensionElements extensionElements = baseElement.getExtensionElements();
        if (extensionElements != null) {
            issues.addAll(this.checkExecutionListener(element.getProcessdefinition(), element, baseElement, extensionElements));
            issues.addAll(this.checkTaskListener(element.getProcessdefinition(), element, baseElement, extensionElements));
        }
        return issues;
    }

    private Collection<CheckerIssue> checkScriptTask(String bpmnFile, BpmnElement element) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        BaseElement baseElement = element.getBaseElement();
        if (baseElement instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)baseElement;
            Script script = scriptTask.getScript();
            if (script != null && scriptTask.getCamundaResource() == null) {
                CheckerIssue issueInvalidScript;
                CheckerIssue issueEmptyFormat;
                CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, element, baseElement, scriptTask.getScriptFormat(), script.getTextContent());
                if (issueEmptyScript != null) {
                    issues.add(issueEmptyScript);
                }
                if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, element, baseElement, scriptTask.getScriptFormat(), script.getTextContent())) != null) {
                    issues.add(issueEmptyFormat);
                }
                if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, element, baseElement, scriptTask.getScriptFormat(), script.getTextContent())) != null) {
                    issues.add(issueInvalidScript);
                }
            } else if (scriptTask.getCamundaResource() == null) {
                issues.addAll(IssueWriter.createIssue(this.rule, CriticalityEnum.ERROR, element, Messages.getString("EmbeddedGroovyScriptChecker.0")));
            }
        }
        return issues;
    }

    private Collection<CheckerIssue> checkExecutionListener(String bpmnFile, BpmnElement element, BaseElement baseElement, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaExecutionListener.class).list();
        for (CamundaExecutionListener listener : listenerList) {
            CheckerIssue issueInvalidScript;
            CheckerIssue issueEmptyFormat;
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaResource() != null) continue;
            CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, element, baseElement, script.getCamundaScriptFormat(), script.getTextContent());
            if (issueEmptyScript != null) {
                issues.add(issueEmptyScript);
            }
            if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, element, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) != null) {
                issues.add(issueEmptyFormat);
            }
            if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, element, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) == null) continue;
            issues.add(issueInvalidScript);
        }
        return issues;
    }

    private Collection<CheckerIssue> checkTaskListener(String bpmnFile, BpmnElement element, BaseElement baseElement, ExtensionElements extensionElements) {
        ArrayList<CheckerIssue> issues = new ArrayList<CheckerIssue>();
        List listenerList = extensionElements.getElementsQuery().filterByType(CamundaTaskListener.class).list();
        for (CamundaTaskListener listener : listenerList) {
            CheckerIssue issueInvalidScript;
            CheckerIssue issueEmptyFormat;
            CamundaScript script = listener.getCamundaScript();
            if (script == null || script.getCamundaResource() != null) continue;
            CheckerIssue issueEmptyScript = this.checkEmptyScriptContent(bpmnFile, element, baseElement, script.getCamundaScriptFormat(), script.getTextContent());
            if (issueEmptyScript != null) {
                issues.add(issueEmptyScript);
            }
            if ((issueEmptyFormat = this.checkEmptyScriptFormat(bpmnFile, element, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) != null) {
                issues.add(issueEmptyFormat);
            }
            if ((issueInvalidScript = this.checkInvalidScriptContent(bpmnFile, element, baseElement, script.getCamundaScriptFormat(), script.getTextContent())) == null) continue;
            issues.add(issueInvalidScript);
        }
        return issues;
    }

    private CheckerIssue parseGroovyCode(String bpmnFile, BpmnElement element, BaseElement baseElement, String scriptText) {
        GroovyShell shell = new GroovyShell();
        try {
            shell.evaluate(scriptText);
        }
        catch (MissingPropertyException | CompilationFailedException ex) {
            if (ex instanceof CompilationFailedException) {
                return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, ex.getMessage());
            }
            return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, String.format(Messages.getString("EmbeddedGroovyScriptChecker.1"), ex.getMessage()));
        }
        return null;
    }

    private CheckerIssue checkEmptyScriptContent(String bpmnFile, BpmnElement element, BaseElement baseElement, String scriptFormat, String script) {
        if (scriptFormat != null && (script == null || script.isEmpty())) {
            return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, Messages.getString("EmbeddedGroovyScriptChecker.2"));
        }
        return null;
    }

    private CheckerIssue checkEmptyScriptFormat(String bpmnFile, BpmnElement element, BaseElement baseElement, String scriptFormat, String script) {
        if (scriptFormat == null && script != null) {
            return IssueWriter.createSingleIssue(this.rule, CriticalityEnum.ERROR, element, bpmnFile, Messages.getString("EmbeddedGroovyScriptChecker.3"));
        }
        return null;
    }

    private CheckerIssue checkInvalidScriptContent(String bpmnFile, BpmnElement element, BaseElement baseElement, String scriptFormat, String script) {
        if (scriptFormat != null && scriptFormat.toLowerCase().equals("groovy") && script != null) {
            return this.parseGroovyCode(bpmnFile, element, baseElement, script);
        }
        return null;
    }
}

